<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	#------------------------------------------------------

	if(!function_exists('title')){

		function title(){

			$CI =& get_instance();
			echo $CI->template->title.' : DMS';

		}

	}

	#------------------------------------------------------

	if ( !function_exists('styles')){

		function styles(){

			$CI =& get_instance();
			foreach($CI->template->css as $css){
				echo '<link rel="stylesheet" href="'.$css.'" />';
			}
		}
	}

	#-------------------------------------------------------

	if ( !function_exists('scripts')){

		function scripts(){

			$CI =& get_instance();
			foreach($CI->template->script as $script){
				echo '<script language="javascript" src="'.$script.'" ></script>';
			}
		}
	}

	#--------------------------------------------------------

	if(!function_exists('sidebar_1')){

		function sidebar_1(){

			$CI =& get_instance();
			foreach($CI->template->sidebar_1 as $sidebar_1){
				echo $sidebar_1;
			}

		}
	}

	#--------------------------------------------------------

	if(!function_exists('sidebar_2')){

		function sidebar_2(){

			$CI =& get_instance();
			if(!empty($CI->template->sidebar_2)){
				echo '<div class="panel panel-danger">';
				echo '<div class="panel-body">';
				foreach($CI->template->sidebar_2 as $sidebar_2){
					echo $sidebar_2;
				}
				echo '</div><div class="panel-footer"></div></div>';
			}
		}
	}

	#-------------------------------------------------------

	if(!function_exists('messages')){

		function messages(){

			$CI =& get_instance();
			$types = array('s'=>'alert-success','w'=>'alert-warning','i'=>'alert-info');

			if(!empty($CI->template->messages)){
				foreach($CI->template->messages as $message=>$type){
					echo "<div class='alert ".$types[$type]." alert-dismissable'><button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>".$message."</div>";
				}
			}
		}
	}

	#--------------------------------------------------------

	#date : 15-10-2014
	#purpose : export to excel icon
	function export_to_excel($url){
		echo '<a href='.base_url($url).' class="pull-right pad-left-20 marge-bottom" target="new"><i class="icon-file-excel green font-30"></i></a>';
	}

	#--------------------------------------------------------

	if(!function_exists('content')){

		function content(){
			$CI =& get_instance();
			foreach($CI->template->content as $content){
				echo $content;
			}

			foreach($CI->template->append_content as $content){
				echo $content;
			}
		}
	}

	#-----------------------------------------------------------

	if(!function_exists('links1')){

		function links1(){
			$CI =& get_instance();
			if(!empty($CI->template->links)){
				echo '<ul class="list-group">';
				foreach($CI->template->links as $link){
					echo '<li class="list-group-item active white">'.$link.'</li>';
				}
				echo '</ul>';
			}
		}
	}

	#-----------------------------------------------------------

	if(!function_exists('links')){
		function links(){
			$CI =& get_instance();
			if(!empty($CI->template->links)){
				echo '<div class="row">';
				echo '<div class="col-sm-6"></div>';
				echo '<div class="col-sm-6">';
				foreach($CI->template->links as $link){
					echo '<li class="list-group-item active white">'.$link.'</li>';
				}
				echo '</div></div></div>';
			}
		}
	}

	#----------------------------------------------------------------
	if(!function_exists('buttons')){

		function buttons(){
			$CI =& get_instance();
			if(!empty($CI->template->buttons)){
				foreach($CI->template->buttons as $button){
					echo $button;
				}
			}
		}
	}

	#--------------------------------------------------------

	if(!function_exists('footer')){

		function footer(){
			$CI =& get_instance();
			echo $CI->template->footer;
		}
	}

	#---------------------------------------------------------

	if(!function_exists('top_bar')){
		function top_bar(){
			$CI =& get_instance();
			#get employee name
			$emp_name = $CI->user->get_fname_lname($CI->session->userdata('id'));
			$CI->load->view('menus/top_bar',array('emp_name'=>$emp_name));
		}
	}

	#-----------------------------------------------------------

	if(!function_exists('app_dashboard_menu')){

		function app_dashboard_menu(){
			$CI =& get_instance();
			$user_id =  $CI->session->userdata('id');
			#get all menu id-s for the user
			if($user_id == -1 && empty($CI->session->userdata('fiscal_yr_id'))){
				$main_menus = $CI->user->get_user_privileges($user_id,0,103);
			}else{
				$main_menus = $CI->user->get_user_privileges($user_id);
			}
			$CI->load->view('menus/dash_board_menu',array('main_menus'=>$main_menus,'user_id'=>$user_id));
		}
	}

	#----------------------------------------------------------

	if(!function_exists('app_breadcrumb')){

		function app_breadcrumb(){

			$CI =& get_instance();
			if(!empty($CI->template->breadcrumb)){

				?><ul class="breadcrumb"><?php
  				foreach($CI->template->breadcrumb as $name=>$link){
					if($link != 'no_link'){
						?>	<li ><a href="<?=base_url($link);?>"><?=ucwords($name);?></a></li><?php
					}else{
						?><li class="active"><a href="javascript:void();"></a><?=ucwords($name);?></li><?php
					}
				}
				?></ul><?php
			}
		}
	}

	#-----------------------------------------------------------

	if(!function_exists('app_table_links')){

		function app_table_links($pk,$menus=array(),$column_count = 0){

			$CI =& get_instance();
			$user_id =  $CI->session->userdata('id');
			#get all menu id-s for the user
			$main_menus = $CI->user->get_action_privileges($user_id,$menus);
			$menu_count = count($main_menus);

			$CI->load->view('menus/actions_menu',array('main_menus'=>$main_menus,'user_id'=>$user_id,'id'=>$pk,'menu_count' => $menu_count,'column_count' => $column_count));
		}

	}

	#------------------------------------------------------------

	if(!function_exists('app_export_menus')){

		function app_export_menus($pk,$menus=array()){

			$CI =& get_instance();
			$user_id =  $CI->session->userdata('id');

			#get all menu id-s for the user
			$main_menus = $CI->user->get_action_privileges($user_id,$menus);
            if (is_array($menus) && is_array($main_menus)) {
			$menu_count = count($menus)-count($main_menus);
            }
            else
            {
                $menu_count = 0;
            }
			$CI->load->view('menus/export_menu',array('main_menus'=>$main_menus,'user_id'=>$user_id,'id'=>$pk,'menu_count' => $menu_count));

		}

	}

	#------------------------------------------------------------

	if(!function_exists('the_user')){

		function the_user(){

			$CI =& get_instance();
			$CI->db->cache_on();
			$query = $CI->db->select(array('fname','lname'))->get_where('users',array('id'=>$CI->session->userdata('id')));
			$CI->db->cache_off();
			$row = $query->result();
			echo ucwords($row[0]->fname).' '.ucwords($row[0]->lname);

		}
	}

	#-----------------------------------------------------------------

	if(!function_exists('the_designation')){

		function the_designation(){

			$CI =& get_instance();
			$CI->db->select(array('dm.designation_name'));
			$CI->db->from('designation_master dm');
			$CI->db->join('users','users.designation_id=dm.id');
			$CI->db->where('users.id',$CI->session->userdata('id'));
			$row = $CI->db->get()->row_array();

			if(empty($row)){
				echo get_user_type();
			}else{
				echo strtoupper($row['designation_name']);
			}
		}
	}

	#------------------------------------------------------------------

	if(!function_exists('sub_heading')){

		function sub_heading(){

			$CI =& get_instance();
			echo $CI->template->sub_heading;
		}
	}

	#------------------------------------------------------------------

	if(!function_exists('main_heading')){

		function main_heading(){

			$CI =& get_instance();
			echo $CI->template->main_heading;
		}
	}

	#------------------------------------------------------------------

	if(!function_exists('the_branch')){

		function the_branch(){

			$CI =& get_instance();
			$CI->db->cache_on();
			if($CI->session->userdata('designation_id') <= 1){
				$CI->db->select(array('branch_short_name as short_name','branch_name as branch_name'))->from('branch_master')->where(array('id'=>$CI->session->userdata('under_id')));
			}else{
				$CI->db->select(array('retailer_name as branch_name','retailer_short_name as short_name'))->from('retailer_master')->where(array('id'=>$CI->session->userdata('under_id')));
			}
			$query = $CI->db->get();
		    $CI->db->cache_off();
		    $branch_ar = $query->result();
		    if(count($branch_ar) > 0){
				if(strlen($branch_ar[0]->short_name)>8){
					echo $branch_ar[0]->short_name;
				}else{
					echo $branch_ar[0]->short_name.' '.$branch_ar[0]->branch_name;
				}
			}else{
				echo strtoupper('Branch Name');
			}
		}
	}

	#------------------------------------------------------------------

	#date : 18-7-2014
	#purpose : get company name
	if(!function_exists('the_company')){

		function the_company(){
			$CI =& get_instance();
			$CI->db->cache_on();
		    $CI->db->select('company_name')->from('company_master')->where(array('id'=>$CI->session->userdata('company_id')));
		    $query = $CI->db->get();
		    $CI->db->cache_off();
		    $row = $query->result();
		    if(count($row) > 0){
				echo strtoupper($row[0]->company_name);
			}else{
				echo strtoupper('COMPANY NAME');
			}
		}
	}

	#------------------------------------------------------------------

	if(!function_exists('the_language')){
		function the_language(){
			$CI =& get_instance();
			$row = $CI->db->select('user_language')->get_where('users',array('id'=>$CI->session->userdata('id')))->row_array();
			return $row['user_language'];
		}
	}

	#--------------------------------------------------------------------

	if(!function_exists('settings_menu')){

		function settings_menu($id){

			$CI =& get_instance();
			$CI->db->cache_on();
			$CI->db->select('mm.*');
			$CI->db->from('menu_master mm');
			if($CI->session->userdata('user_desig') != -1){
				$CI->db->join('user_privileges up','up.menu_id=mm.id');
				$CI->db->where('up.user_group','individual');
				$CI->db->where('up.owner_id',$CI->session->userdata('id'));
			}
			$CI->db->where('mm.id',$id);
			$query = $CI->db->get();
			$CI->db->cache_off();
			$row = $query->result();
			if(!empty($row)){
				?><li><a title="<?=$row[0]->menu_title;?>" href="<?=base_url($row[0]->menu_controller.'/'.$row[0]->menu_action.'/'.$row[0]->menu_args);?>"><i class="icon-cog"></i><?=$CI->lang->line($row[0]->menu_name);?></a></li><?php
			}
		}
	}

	#--------------------------------------------------------------------

	if(!function_exists('single_menu')){

		function single_menu($pk,$id){

			$CI =& get_instance();
			$CI->db->select('mm.*');
			$CI->db->from('menu_master mm');
			if($CI->session->userdata('user_desig') != -1){
				$CI->db->join('user_privileges up','up.menu_id=mm.id');
				$CI->db->where('up.user_group','individual');
				$CI->db->where('up.owner_id',$CI->session->userdata('id'));
			}
			$CI->db->where('mm.id',$id);
			$row = $CI->db->get()->row_array();

			if(!empty($row)){
				?><li><a title="<?=$row['menu_title'];?>" href="<?=base_url($row['menu_controller'].'/'.$row['menu_action'].'/'.$pk);?>" class="<?=$row['menu_class'];?>"><?php if($row['menu_icon']):?><i class="<?=$row['menu_icon'];?>"></i><?php endif;?><?=$CI->lang->line($row['menu_name']);?></a></li><?php
			}
		}
	}

	#--------------------------------------------------------------------

	if(!function_exists('the_fiscal_year_display')){

		function the_fiscal_year_display(){

			$CI =& get_instance();
			$row = $CI->db->get_where('fiscal_year_master',array('id'=>$CI->session->userdata('fiscal_yr_id')))->row_array();

			if(empty($row)){
				echo 'No fiscal year set';
			}else{
				$start = date_parse($row['start_date']);
				if($row['end_date'] == '0000-00-00' || empty($row['end_date'])){
					$row['end_date'] = date('Y-m-d');
				}
				$end = date_parse($row['end_date']);
				?><i><?=$start['day'];?></i> <b><i><?=date('M',strtotime($row['start_date']));?></i> <i><?=$start['year'];?></i></b><em> - </em><i><?=$end['day'];?></i> <b><i><?=date('M',strtotime($row['end_date']));?></i> <i><?=$end['year'];?></i></b><?php
			}
		}
	}

	#---------------------------------------------------------------------

	if(!function_exists('get_user_type')){

		function get_user_type(){
			$CI =& get_instance();
			$CI->db->cache_on();
			$CI->db->select('b.designation_name');
			$CI->db->from('users a');
			$CI->db->join('designation_master b','a.designation_id=b.id');
			$CI->db->where('a.id',$CI->session->userdata('id'));
			$query = $CI->db->get();
			$CI->db->cache_off();
			$row = $query->row_array();
			if(!empty($row)){
				return strtoupper($row['designation_name']);
			}
			return false;
		}
	}

	#---------------------------------------------------------------------

	if(!function_exists('the_profile_pic')){

		function the_profile_pic(){
			$CI =& get_instance();
			$CI->db->cache_on();
			$query = $CI->db->select(array('photo','gender'))->from('users')->where('id',$CI->session->userdata('id'))->get();
			$CI->db->cache_off();
			$row = $query->result();
			if(!empty($row[0]->photo) && file_exists("assets/images/photos/".$row[0]->photo)){
				echo img(base_url('assets/images/photos/'.$row[0]->photo));
			}else if(!empty($row[0]->gender)){
				#male or female
				echo img(base_url('assets/images/photos/'.strtolower($row[0]->gender).'.jpg'));
			}else{
				echo img(base_url('assets/images/photos/no_profile_pic.jpg'));
			}
		}
	}

	#-----------------------------------------------------------------------------

	if(!function_exists('financial_years')){

		function financial_years(){
			$CI =& get_instance();
			$CI->db->select();
			$CI->db->from('fiscal_year_master');
			$CI->db->where('status',1);
			$CI->db->limit(5);
			$rows = $CI->db->get()->result_array();
			$years = array();
			$uri_array = $CI->uri->uri_to_assoc(1);
			foreach($rows as $row){
				$start = date_parse($row['start_date']);
				if($row['end_date'] == '0000-00-00' || empty($row['end_date'])){
					$row['end_date'] = date('Y-m-d');
				}
				$end = date_parse($row['end_date']);
				if($row['id']==$CI->session->userdata('fiscal_yr_id')){
					$class='active';
				}else{
					$class='';
				}
				?>	<li class="<?=$class;?>"><a href="<?=base_url('fiscal/set_default/'.$row['id'].'/'.$CI->uri->assoc_to_uri($uri_array));?>"><i class="icon-arrow-right4"></i><?=$start['year'].'-'.date('y',strtotime($row['end_date']));?></a></li><?php
			}
			?><li><a href="<?=base_url('fiscal/manage'); ?>"><i class="icon-arrow-right4"></i><h5><?=$CI->lang->line('close');?></h5></a></li><?php
		}
	}


	#----------------------------------------------------------------------------

	if(!function_exists('dateFormat')){
		function dateFormat($date){
			if(!empty($date) && ($date !='0000-00-00' && $date !='0000-00-00 00:00:00')){
				return date(DATE_FORMAT,strtotime($date));
			}
			return "";
		}
	}

	#----------------------------------------------------------------------------

	if(!function_exists('cdateFormat')){
		function cdateFormat($date){
			if(!empty($date) && ($date !='0000-00-00' && $date !='0000-00-00 00:00:00')){
				return date(CAL_FORMAT,strtotime($date));
			}
			return "";
		}
	}

	#----------------------------------------------------------------------------

	if(!function_exists('dateTimeFormat')){

		function dateTimeFormat($date){
			if(!empty($date) && ($date !='0000-00-00' && $date !='0000-00-00 00:00:00')){
				return date(DATE_FORMAT." h:i:s A",strtotime($date));
			}
			return "";
		}

	}

	#----------------------------------------------------------------------------

	if(!function_exists('fiscal_status')){
		#segment => segment to be blocked
		#methods => blocking segments array
		#redirect => redirection page
		function fiscal_status($segment,$methods,$redirect){
			$CI =& get_instance();
			if(!$CI->fiscal_check()){
				$CI->message->set($CI->lang->line('set-fiscal-year'),'e');
				redirect("fiscal/manage");
			}else{
				if(!$CI->fiscal_check($CI->session->userdata('fiscal_yr_id'))){
					if(in_array($segment,$methods)){
						$CI->message->set($CI->lang->line('close-fiscal-year'),'e');
						redirect($redirect);
					}
				}
			}
		}
	}

	#----------------------------------------------------------------------------

	if(!function_exists('get_username')){
		function get_username($user_id){
			$CI =& get_instance();
			$row = $CI->db->select(array("concat(fname,' ',lname) as user_name"))->get_where('users',array('id'=>$user_id))->row_array();
			if(!empty($row)){
				return $row['user_name'];
			}
			return false;
		}
	}


	#-----------------------------------------------------------------------------

	if(!function_exists('numberFormat')){

		function numberFormat($number){
			$CI =& get_instance();
			$row = $CI->db->select(array("decimal_place"))->get_where('constant_master',array('company_id'=>$CI->session->userdata('company_id')))->row_array();
			if(!empty($row)){
				$decimal_place = $row['decimal_place'];
			}else{
				$decimal_place = 0;
			}
			if(is_numeric($number)){
				return number_format($number,$decimal_place);
			}
			return NULL;
		}
	}

	#----------------------------------------------------------------------------


	if(!function_exists('round_this')){
		function round_this($amount,$decimal_place=NULL){
			$CI =& get_instance();
			if(empty($decimal_place)){
				$row = $CI->db->select(array("decimal_place"))->get_where('constant_master',array('company_id'=>$CI->session->userdata('company_id')))->row_array();
				if(!empty($row)){
					$decimal_place = $row['decimal_place'];
				}else{
					$decimal_place = 0;
				}
			}
			//$decimal_place=2;
			return round($amount,$decimal_place);
		}
	}

	#-----------------------------------------------------------------

	if(!function_exists('round_off')){

		function round_off($amount){
			$rounded_amount = get_rounded($amount);
			return $round_off = round($rounded_amount-$amount,2);
		}
	}

	#-----------------------------------------------------------------

	if(!function_exists('get_rounded')){

		function get_rounded($amount){
			if(show_round_off()){
				return round($amount,0);
			}else{
				return $amount;
			}
		}
	}


	#-------------------------------------------------------------

	if(!function_exists('show_round_off')){

		function show_round_off(){
			# returns true when round off option enabled / otherwise returns false
			$CI =& get_instance();
			$row = $CI->db->select(array("net_amount_round"))->get_where('constant_master',array('company_id'=>$CI->session->userdata('company_id')))->row_array();
			if(!empty($row) && !empty($row['net_amount_round'])){
				return true;
			}
			return false;
		}

	}


	#-----------------------------------------------------------------

	if(!function_exists('get_currency')){
		function get_currency(){
			$CI =& get_instance();
			$row = $CI->db->select(array("currency_symbol"))->get_where('constant_master',array('company_id'=>$CI->session->userdata('company_id')))->row_array();
			if(!empty($row)){
				return $row['currency_symbol'];
			}
		}
	}

	#-------------------------------------------------------------
	#date : 16-03-2015
	#purpose : export to excel icon
	function export_to_word($url){
		echo '<a href='.base_url($url).' class="pull-right pad-left-20 marge-bottom" target="new"><i class="icon-file-word font-30"></i></a>';
	}

	#----------------------------------------------------------------------------

	if(!function_exists('stringFormat')){
		function stringFormat($string,$type = 'uf'){
			$string = xss_clean($string);
			if(!empty($string)){
				if($type == 'uf'){
					return ucfirst(strtolower($string));
				}elseif($type == 'uw'){
					return ucwords(strtolower($string));
				}elseif($type == 'u'){
					return strtoupper(strtolower($string));
				}elseif($type == 'l'){
					return strtolower($string);
				}
			}
			return false;
		}
	}

	#----------------------------------------------------------------------------

	if( ! function_exists('getTrim')){

		function getTrim($string,$length=30){
			$return_string = $string;
			if(strlen($string) > $length){
				$return_string = "<div title='".$string."'>".substr($string,0,$length)." ...</div>";
			}
			return $return_string;
		}
	}

	#-------------------------------------------------------------
	if( ! function_exists('get_voucher_prefix')){
		function get_voucher_prefix($vid){
			$CI =& get_instance();
			$row = $CI->db->select(array('vprefix'))->get_where('dms_voucher_prefixes',array('company_id'=>$CI->session->userdata('company_id'),'vid'=>$vid))->row_array();
			if(!empty($row)){
				return $row['vprefix'];
			}
			return false;
		}
	}
?>