<?php
class Accounts
{
	public $CI;
	public $company_id;
	public $branch_id;
	public $created_by;

	public function __construct(){

		$this->CI =& get_instance();
		$this->company_id = $this->CI->session->userdata('company_id');
		$this->branch_id = $this->CI->session->userdata('under_id');
		$this->created_by = $this->CI->session->userdata('id');
	}

	#------- current financial year opening balance of a particular ledger ----------#
	public function cur_open_bal($ledger_id,$type = 0)
	{
		//type = 1 => returns vat and open_date , 0 => returns open balance and dc
		$open_date = $this->CI->dms->get_fiscal_year()['start_date'];
		$this->CI->db->query("CALL cur_open_bal('$ledger_id','$open_date','".$this->branch_id."',@ob,@dc)");
		$qry = $this->CI->db->query("SELECT @ob AS open_amount,@dc AS dc");
		$row = $qry->row_array();
		if($type == 1)
		{
			$row1 = $this->CI->db->select(array('open_date','vat'))->get_where('dms_ledger_open_bals',array('ledger_id' => $ledger_id,'open_date' => $open_date,'status' => 1))->row_array();
			if(!empty($row1)){
				$row = $row+$row1;
			}
			else{
				$row['open_date'] = "";
				$row['vat'] = 0;
			}
		}
		return $row;
	}

	#--------------------- get debit / credit of a ledger ------------------------#
	public function get_dc($ledger_id)
	{
		$row = $this->CI->db->select('dc')->get_where('dms_ledgers',array('id' => $ledger_id))->row_array();
		if(!empty($row)){
			return $row['dc'];
		}
		return false;
	}

	#------------------------------ get ledgers ----------------------------------#
	public function get_legders($args = array())
	{
		if(isset($args['columns']))
		{
			$this->CI->db->select($args['columns'])->from('dms_ledgers as a')->join('account_sub_groups as b','a.sgroup_id=b.id')->where('sgroup_id!=',15)->where('a.status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			if(isset($args['or']))
			{
				$this->CI->db->where($args['or']);
			}
			$row = $this->CI->db->get()->result_array();
			if(!empty($row)){
				return $row;
			}
			return false;
		}
		else
		{
			$ledger_array = array();
			$this->CI->db->select(array('id','ledger_name'))->from('dms_ledgers')->where('sgroup_id!=',15)->where('status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			$row = $this->CI->db->get()->result_array();
			foreach($row as $key => $value)
			{
				$ledger_array[$value['id']] = $value['ledger_name'];
			}
			return $ledger_array;
		}
	}

	#-------------------------- get ledger name ----------------------------------#
	public function get_ledger_name($ledger_id)
	{
		$row = $this->CI->db->select('ledger_name')->get_where('dms_ledgers',array('id' => $ledger_id))->row_array();
		if(!empty($row)){
			return $row['ledger_name'];
		}
		return false;
	}

	#------------------------------ get ledgers ----------------------------------#
	public function get_account_groups($args = array())
	{
		if(isset($args['columns']))
		{
			$this->CI->db->select($args['columns'])->from('account_sub_groups')->where("(company_id=".$this->company_id." or company_id=0)")->where('status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			if(isset($args['or']))
			{
				$this->CI->db->where($args['or']);
			}
			$row = $this->CI->db->get()->result_array();
			if(!empty($row)){
				return $row;
			}
			return false;
		}
		else
		{
			$sub_group_array = array();
			$this->CI->db->select(array('id','sub_group'))->from('account_sub_groups')->where("(company_id=".$this->company_id." or company_id=0)")->where('status',1);
			if(isset($args['conditions']))
			{
				$this->CI->db->where($args['conditions']);
			}
			$row = $this->CI->db->get()->result_array();
			foreach($row as $key => $value)
			{
				$sub_group_array[$value['id']] = $value['sub_group'];
			}
			return $sub_group_array;
		}
	}

	#---------------------------- get vouchers ----------------------------------#
	public function get_vouchers($args = array())
	{
		$this->CI->db->select($args['columns'])->from('dms_vouchers as a')->join('dms_ledgers as c','a.dr_ledger = c.id or a.cr_ledger=c.id')->join('dms_voucher_banks as b','a.group_id = b.group_id','left')->where(array('a.company_id' => $this->company_id,'a.status' => 1));
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		if(isset($args['between']))
		{
			$this->CI->db->where($args['between']['column']." between '".$args['between']['first']."' and '".$args['between']['last']."'");
		}
		$this->CI->db->order_by('a.vdate','asc');
		$this->CI->db->order_by('a.vtype_id','asc');
		$this->CI->db->order_by('a.vno','asc');
		$this->CI->db->order_by('a.vorder_no','asc');
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function voucher_name($vtype_id)
	{
		$row = $this->CI->db->select('vtype')->get_where('dms_voucher_types',array('id' => $vtype_id))->row_array();
		if(!empty($row)){
			return $row['vtype'];
		}
		return false;
	}

	public function last_closed_yr($date = NULL)
	{
		$where = array('company_id' => $this->company_id,'close_status' => 0,'status' => 1);
		if($date != NULL){
			$where['end_date <'] = $date;
		}
		$row = $this->CI->db->select(array('id','start_date','end_date'))->from('fiscal_year_master')->where($where)->order_by('fiscal_order','desc')->limit(1)->get()->row_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function fiscal_years($to_date,$from_date = NULL)
	{
		$to_date = date('Y-m-d',strtotime($to_date));
		$this->CI->db->select(array('id','start_date','end_date'))->from('fiscal_year_master')->where('company_id',$this->company_id);
		if($from_date != NULL)
		{
			$from_date = date('Y-m-d',strtotime($from_date));
			$this->CI->db->where("start_date between '$from_date' and '$to_date'",NULL,false);
		}
		else
		{
			$this->CI->db->where('start_date <=',$to_date);
		}
		$this->CI->db->where(array('close_status' => 1,'status' => 1))->order_by('fiscal_order','asc');
		$row = $this->CI->db->get()->result_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function opening_bal($id,$to_date,$type = 0,$from_date = NULL)
	{
		//type = 0 => ledger_id , type = 1 => sgroup_id , type = 2 => ledger_id for all branches , type = 3 => sgroup_id for all branches

		$to_date = date('Y-m-d',strtotime($to_date));
		$closed = $this->last_closed_yr($to_date);
		$this->CI->db->select_sum('open_amount')->from('dms_ledgers as a')->join('dms_ledger_open_bals as b','a.id=b.ledger_id')->where(array('a.status' => 1,'b.status' => 1));
		if($type == 0){
			$this->CI->db->where(array('a.id' => $id,'b.branch_id' => $this->branch_id));
		}
		elseif($type == 1){
			$this->CI->db->where(array('a.sgroup_id' => $id,'b.branch_id' => $this->branch_id));
		}
		elseif($type == 2){
			$this->CI->db->where(array('a.id' => $id,'b.company_id' => $this->company_id));
		}
		else{
			$this->CI->db->where(array('a.sgroup_id' => $id,'b.company_id' => $this->company_id));
		}

		if($closed){
			$from_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
		}
		if($from_date == NULL){
			$this->CI->db->where('b.open_date <=',$to_date);
		}
		else{
			$from_date = date('Y-m-d',strtotime($from_date));
			$this->CI->db->where("b.open_date between '".$from_date."' and '".$to_date."'");
		}
		$row = $this->CI->db->get()->row_array();
		return $row['open_amount'];
	}

	/*public function voucher_bal($id,$to_date,$type = 0,$from_date = NULL)
	{
		//type = 0 => ledger_id , type = 1 => sgroup_id , type = 2 => ledger_id for all branches , type = 3 => sgroup_id for all branches

		$where = "a.status=1";
		$condition_array = array();
		$to_date = date('Y-m-d',strtotime($to_date));
		$closed = $this->last_closed_yr($to_date);
		if($type == 0){
			$where .= " and a.branch_id=".$this->branch_id." and b.id = ?";
		}
		elseif($type == 1){
			$where .= " and a.branch_id=".$this->branch_id." and b.sgroup_id = ?";
		}
		elseif($type == 2){
			$where .= " and a.company_id=".$this->company_id." and b.id = ?";
		}
		else{
			$where .= " and a.company_id=".$this->company_id." and b.sgroup_id = ?";
		}
		$condition_array[0] = $id;
		if($from_date == NULL){
			if($closed){
				$from_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
				if($from_date == $to_date){
					return array('dr_amount' => 0,'cr_amount' => 0);
				}
				else{
					$to_date = date('Y-m-d',(strtotime($to_date)-86400));
				}
				$where .= " and a.vdate between ? and ?";
				$condition_array[1] = $from_date;
				$condition_array[2] = $to_date;
			}
			else{
				$where .= " and a.vdate < ?";
				$condition_array[1] = $to_date;
			}
		}
		else{
			$from_date = date('Y-m-d',strtotime($from_date));
			$where .= " and a.vdate between ? and ?";
			$condition_array[1] = $from_date;
			$condition_array[2] = $to_date;
		}
		$qry1 = "select sum(vamount) as vamount from dms_vouchers as a inner join dms_ledgers as b on a.dr_ledger=b.id where $where";
		$qry2 = "select sum(vamount) as vamount from dms_vouchers as a inner join dms_ledgers as b on a.cr_ledger=b.id where $where";

		$qry1_res = $this->CI->db->query($qry1, $condition_array);
		$qry2_res = $this->CI->db->query($qry2, $condition_array);

		$dr_amount = $qry1_res->row();
		$cr_amount = $qry2_res->row();
		return array('dr_amount' => $dr_amount->vamount,'cr_amount' => $cr_amount->vamount);
	}*/
	
	//==========================================new vou bal==================================================================//	
	
	public function voucher_bal($id, $to_date, $type = 0, $from_date = NULL)
{
    $to_date = date('Y-m-d', strtotime($to_date));
    $closed = $this->last_closed_yr($to_date);

    $where = "a.status=1";
    $params = [];
    
    switch ($type) {
        case 0:
            $where .= " AND a.branch_id=? AND (b.id = ?)";
            $params[] = $this->branch_id;
            break;
        case 1:
            $where .= " AND a.branch_id=? AND (b.sgroup_id = ?)";
            $params[] = $this->branch_id;
            break;
        case 2:
            $where .= " AND a.company_id=? AND (b.id = ?)";
            $params[] = $this->company_id;
            break;
        case 3:
            $where .= " AND a.company_id=? AND (b.sgroup_id = ?)";
            $params[] = $this->company_id;
            break;
    }
    $params[] = $id;

    if ($from_date == NULL) {
        if ($closed) {
            $from_date = date('Y-m-d', (strtotime($closed['end_date']) + 86400));
            if ($from_date == $to_date) {
                return ['dr_amount' => 0, 'cr_amount' => 0];
            } else {
                $to_date = date('Y-m-d', (strtotime($to_date) - 86400));
            }
            $where .= " AND a.vdate BETWEEN ? AND ?";
            $params[] = $from_date;
            $params[] = $to_date;
        } else {
            $where .= " AND a.vdate < ?";
            $params[] = $to_date;
        }
    } else {
        $from_date = date('Y-m-d', strtotime($from_date));
        $where .= " AND a.vdate BETWEEN ? AND ?";
        $params[] = $from_date;
        $params[] = $to_date;
    }

    $qry = "SELECT 
                SUM(CASE WHEN a.dr_ledger = b.id THEN vamount ELSE 0 END) as dr_amount,
                SUM(CASE WHEN a.cr_ledger = b.id THEN vamount ELSE 0 END) as cr_amount
            FROM dms_vouchers a
            INNER JOIN dms_ledgers b ON (a.dr_ledger = b.id OR a.cr_ledger = b.id)
            WHERE $where";

    $result = $this->CI->db->query($qry, $params)->row();

    return [
        'dr_amount' => $result->dr_amount ?: 0,
        'cr_amount' => $result->cr_amount ?: 0
    ];
}


	
	
	
//==========================================end vou bal==================================================================//

	public function get_vid($vtype)
	{
		$row = $this->CI->db->select('vid')->get_where('dms_voucher_types',array('id' => $vtype))->row_array();
		return $row['vid'];
	}

	public function account_group_name($id)
	{
		$row = $this->CI->db->select('sub_group')->get_where('account_sub_groups',array('id' => $id))->row_array();
		if(!empty($row)){
			return $row['sub_group'];
		}
		return false;
	}

	/*public function stock_bal_amt($to_date,$type = 0,$bal_type = 0)
	{
		//type = 0 => branch , type = 1 => company
		//bal_type = 0 => opening_bal , bal_type = 1 => closing_bal
		$bal_amt = 0;$from_date = "";
		$closed = $this->last_closed_yr($to_date);
		$pre_date = $to_date;
		if($closed)
		{
			$from_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
			$bal_amt = $this->stock_opening_bal($from_date,0,1);
		}
		if($bal_type == 0)
		{
			$pre_date = date('Y-m-d',(strtotime($to_date)-86400));
			$stock_open_date = $this->stock_open_date();
			if($stock_open_date == $to_date){
				$bal_amt = $this->stock_opening_bal($to_date);
			}
		}
		$fiscal_years = $this->fiscal_years($pre_date,$from_date);//unclosed fiscal years
		$row = $this->CI->db->select('id')->get_where('item_master',array('company_id' => $this->company_id,'stock_type' => 1,'status' => 1))->result_array();
		if(!empty($row) && !empty($fiscal_years))
		{
			#---------stock value type
			$stock_value_type = $this->CI->dms->stock_value_type($this->CI->session->userdata('fiscal_yr_id'));

			foreach($fiscal_years as $fkey => $fvalue)
			{
				if($fvalue['end_date'] == '0000-00-00'){
					$fvalue['end_date'] = $to_date;
				}
				if(strtotime($fvalue['end_date']) > strtotime($pre_date)){
					$fvalue['end_date'] = $pre_date;
				}
				foreach($row as $key => $value)
				{
					$rate = $qty = 0;
					$rate = $this->item_rate($value['id'],$fvalue['start_date'],$fvalue['end_date'],$type,$stock_value_type);
					$qty = $this->item_bal_qty($value['id'],$fvalue['start_date'],$fvalue['end_date'],$type);
					$bal_amt +=($rate*$qty);
				}
			}
		}
		return $bal_amt;
	}
*/

	//===================================================new stk bal amt==================================================================//

    public function stock_bal_amt($to_date, $type = 0, $bal_type = 0)
    {
        $to_date = date('Y-m-d', strtotime($to_date));
        $bal_amt = 0;
        $from_date = "";
        $closed = $this->last_closed_yr($to_date);
        $pre_date = $to_date;
    
        if ($closed) {
            $from_date = date('Y-m-d', strtotime($closed['end_date']) + 86400);
            $bal_amt = $this->stock_opening_bal($from_date, 0, 1);
        }
    
        if ($bal_type == 0) {
            $pre_date = date('Y-m-d', strtotime($to_date) - 86400);
            $stock_open_date = $this->stock_open_date();
            if ($stock_open_date == $to_date) {
                $bal_amt = $this->stock_opening_bal($to_date);
            }
        }
    
        $fiscal_years = $this->fiscal_years($pre_date, $from_date); // unclosed fiscal years
        $items = $this->CI->db->select('id')
                              ->where(['company_id' => $this->company_id, 'stock_type' => 1, 'status' => 1])
                              ->get('item_master')
                              ->result_array();
    
        if (!empty($items) && !empty($fiscal_years)) {
            $stock_value_type = $this->CI->dms->stock_value_type($this->CI->session->userdata('fiscal_yr_id'));
    
            foreach ($fiscal_years as $fvalue) {
                $end_date = $fvalue['end_date'] === '0000-00-00' ? $to_date : $fvalue['end_date'];
                if (strtotime($end_date) > strtotime($pre_date)) {
                    $end_date = $pre_date;
                }
    
                // Prepare data for bulk queries
                $item_ids = array_column($items, 'id');
                $rates = $this->bulk_item_rate($item_ids, $fvalue['start_date'], $end_date, $type, $stock_value_type);
                $quantities = $this->bulk_item_bal_qty($item_ids, $fvalue['start_date'], $end_date, $type);
    
                foreach ($item_ids as $item_id) {
                    $rate = $rates[$item_id] ?? 0;
                    $qty = $quantities[$item_id] ?? 0;
                    $bal_amt += ($rate * $qty);
                }
            }
        }
    
        return $bal_amt;
    }

private function bulk_item_rate($item_id, $from_date, $to_date, $type = 0, $stock_value_type = 0)
{
    // Convert dates to 'Y-m-d' format
    $from_date = date('Y-m-d', strtotime($from_date));
    $to_date = date('Y-m-d', strtotime($to_date));

  $condition_array = [$from_date, $to_date];
$rate = 0;

if ($stock_value_type == 1) {
    // Last purchase cost
    $qry = "SELECT rate 
            FROM dms_purchase_items a 
            INNER JOIN dms_vouchers b 
            ON a.group_id = b.table_group_id 
            WHERE a.item_status > 0 
            AND a.status = 1 
            AND a.item_id = ? 
            AND b.vdate BETWEEN ? AND ? ";
    if ($type == 0) {
        $qry .= "AND b.branch_id = ? ";
        $condition_array[] = $this->branch_id;
    } else {
        $qry .= "AND b.company_id = ? ";
        $condition_array[] = $this->company_id;
    }
    $qry .= "ORDER BY b.vdate DESC, b.vno DESC LIMIT 1";
    
    $qry_res = $this->CI->db->query($qry, array_merge([$item_id], $condition_array));
    $row = $qry_res->row();
    if (!empty($row)) {
        $rate = $row->rate;
    }
} else {
    // Average purchase cost
    // Ensure $item_ids is an array
    if (!is_array($item_ids)) {
        $item_ids = explode(',', $item_ids);
    }

    // Use IN with a placeholder for array
    $placeholders = implode(',', array_fill(0, count($item_ids), '?'));

    $qry = "SELECT SUM(rate) AS rate, COUNT(id) AS total_count 
            FROM dms_stocks 
            WHERE item_id IN ($placeholders) 
            AND stock_date BETWEEN ? AND ? 
            AND stock_status = 2 
            AND status = 1 ";
    if ($type == 0) {
        $qry .= "AND branch_id = ? ";
        $condition_array[] = $this->branch_id;
    } else {
        $qry .= "AND company_id = ? ";
        $condition_array[] = $this->company_id;
    }

    $qry_res = $this->CI->db->query($qry, array_merge($item_ids, $condition_array));
    $result = $qry_res->row();
    if ($result->total_count > 0) {
        $rate = $result->rate / $result->total_count;
    }
}

    return $rate;

    
   
}

private function bulk_item_bal_qty($item_ids, $from_date, $to_date, $type = 0)
{
    // Convert dates to 'Y-m-d' format
    $from_date = date('Y-m-d', strtotime($from_date));
    $to_date = date('Y-m-d', strtotime($to_date));

    // Ensure $item_ids is an array
    if (!is_array($item_ids)) {
        $item_ids = explode(',', $item_ids);
    }

    $condition_array = [$from_date, $to_date];
    
    $branch_or_company = ($type == 0) ? 'branch_id' : 'company_id';
    $branch_or_company_id = ($type == 0) ? $this->branch_id : $this->company_id;

    // Use IN with a placeholder for array
    $placeholders = implode(',', array_fill(0, count($item_ids), '?'));

    $qry = "SELECT 
                SUM(CASE WHEN stock_status IN (0, 1, 2, 7, 8, 9, 10) THEN qty ELSE 0 END) AS positive_qty,
                SUM(CASE WHEN stock_status IN (3, 4, 5, 6) THEN qty ELSE 0 END) AS negative_qty
            FROM dms_stocks
            WHERE $branch_or_company = ? 
            AND item_id IN ($placeholders)
            AND stock_date BETWEEN ? AND ?
            AND status = 1";
            
    // Prepare the condition array
    $condition_array = array_merge([$branch_or_company_id], $item_ids, [$from_date, $to_date]);

    $qry_res = $this->CI->db->query($qry, $condition_array);
    $result = $qry_res->row();

    if ($result) {
        $total_qty = $result->positive_qty - $result->negative_qty;
    } else {
        $total_qty = 0;
    }

    return $total_qty;
}

//===================================================end stk bal amt==============================================================//

	public function item_rate($item_id,$from_date,$to_date,$type = 0,$stock_value_type = 0)
	{
		//type = 0 => branch , type = 1 => company
		$condition_array = array();
		$to_date = date('Y-m-d',strtotime($to_date));
		$from_date = date('Y-m-d',strtotime($from_date));
		$rate = 0;
		if($stock_value_type == 1)//last purchase cost
		{
			$qry = "select rate from dms_purchase_items as a";
			if($type == 0){
				$qry .= " inner join dms_vouchers as b on a.group_id=b.table_group_id where b.branch_id=".$this->branch_id;
			}
			else{
				$qry .= " inner join dms_vouchers as b on a.group_id=b.table_group_id where b.company_id=".$this->company_id;
			}
			$qry .= " and a.item_status > 0 and a.status=1 and a.item_id= ?";
			$condition_array[0] = $item_id;
			$qry .= " and b.vdate between ? and ?";
			$condition_array[1] = $from_date;
			$condition_array[2] = $to_date;
			$qry .= "order by vdate,vno desc limit 1";
			$qry_res = $this->CI->db->query($qry, $condition_array);
			$row = $qry_res->row();
			if(!empty($row)){
				$rate = $row->rate;
			}
		}
		else//avg purchase cost
		{
			$qry = "select sum(rate) as rate,count(id) as total_count from dms_stocks";
			if($type == 0){
				$qry .= " where branch_id=".$this->branch_id;
			}
			else{
				$qry .= " where company_id=".$this->company_id;
			}

			$qry .= " and item_id = ?";
			$condition_array[0] = $item_id;
			$qry .= " and stock_date between ? and ?";
			$condition_array[1] = $from_date;
			$condition_array[2] = $to_date;
			$qry .= " and stock_status = 2 and status = 1";//purchase
			$qry_res = $this->CI->db->query($qry, $condition_array);//purchase
			$total_rate = $qry_res->row()->rate;
			$total_count = $qry_res->row()->total_count;
			if($total_count > 0){
				$rate = $total_rate/$total_count;
			}
		}
		if(empty($rate))
		{
			$this->CI->db->select('rate')->from('dms_stocks');
			if($type == 0){
				$this->CI->db->where('branch_id',$this->branch_id);
			}
			else{
				$this->CI->db->where('company_id',$this->company_id);
			}
			$this->CI->db->where(array('item_id' => $item_id,'stock_status' => 0,'status' => 1));
			$row = $this->CI->db->get()->row_array();
			if(!empty($row)){
				$rate = $row['rate'];
			}
		}
		return $rate;
	}

	public function item_bal_qty($item_id,$from_date,$to_date,$type = 0)
	{
		//type = 0 => branch , type = 1 => company
		$condition_array = array();$total_qty = 0;
		$to_date = date('Y-m-d',strtotime($to_date));
		$from_date = date('Y-m-d',strtotime($from_date));
		$qry = "select sum(qty) as qty from dms_stocks";
		if($type == 0){
			$qry .= " where branch_id=".$this->branch_id;
		}
		else{
			$qry .= " where company_id=".$this->company_id;
		}

		$qry .= " and item_id = ?";
		$condition_array[0] = $item_id;
		$qry .= " and stock_date between ? and ?";
		$condition_array[1] = $from_date;
		$condition_array[2] = $to_date;

		$qry1 = $qry." and stock_status = 0 and status = 1";//opening
		$qry2 = $qry." and stock_status = 1 and status = 1";//receipt
		$qry3 = $qry." and stock_status = 2 and status = 1";//purchase
		$qry4 = $qry." and stock_status = 3 and status = 1";//rejection_out
		$qry5 = $qry." and stock_status = 4 and status = 1";//debit
		$qry6 = $qry." and stock_status = 5 and status = 1";//delivery
		$qry7 = $qry." and stock_status = 6 and status = 1";//sales
		$qry8 = $qry." and stock_status = 7 and status = 1";//rejection_in
		$qry9 = $qry." and stock_status = 8 and status = 1";//credit
		$qry10 = $qry." and stock_status = 9 and status = 1";//phy_stock
		$qry11 = $qry." and stock_status = 10 and status = 1";//transfer

		$qry1_res = $this->CI->db->query($qry1, $condition_array);//opening
		$qry2_res = $this->CI->db->query($qry2, $condition_array);//receipt
		$qry3_res = $this->CI->db->query($qry3, $condition_array);//purchase
		$qry4_res = $this->CI->db->query($qry4, $condition_array);//rejection_out
		$qry5_res = $this->CI->db->query($qry5, $condition_array);//debit
		$qry6_res = $this->CI->db->query($qry6, $condition_array);//delivery
		$qry7_res = $this->CI->db->query($qry7, $condition_array);//sales
		$qry8_res = $this->CI->db->query($qry8, $condition_array);//rejection_in
		$qry9_res = $this->CI->db->query($qry9, $condition_array);//credit
		$qry10_res = $this->CI->db->query($qry10, $condition_array);//phy_stock
		$qry11_res = $this->CI->db->query($qry11, $condition_array);//transfer

		$opening = $qry1_res->row()->qty;
		$receipt = $qry2_res->row()->qty;
		$purchase = $qry3_res->row()->qty;
		$rejection_out = $qry4_res->row()->qty;
		$debit = $qry5_res->row()->qty;
		$delivery = $qry6_res->row()->qty;
		$sales = $qry7_res->row()->qty;
		$rejection_in = $qry8_res->row()->qty;
		$credit = $qry9_res->row()->qty;
		$phy_stock = $qry10_res->row()->qty;
		$transfer = $qry11_res->row()->qty;

		$total_qty = ($opening + $receipt + $purchase + $rejection_in + $credit + $phy_stock + $transfer)-($rejection_out + $delivery + $sales + $debit);
		return $total_qty;
	}

#-------------------------------------Item stock------------------------------------------#


public function item_bal_qty_new($item_id,$from_date,$to_date,$type = 0)
	{
		//type = 0 => branch , type = 1 => company
		$condition_array = array();$total_qty = 0;
		$to_date = date('Y-m-d',strtotime($to_date));
		$from_date = date('Y-m-d',strtotime($from_date));
		$qry = "select qty from item_stock";
		if($type == 0){
			$qry .= " where branch_id=".$this->branch_id;
		}
		else{
			$qry .= " where company_id=".$this->company_id;
		}

		$qry .= " and item_id = ?";
		$condition_array[0] = $item_id;
		//$qry .= " and stock_date between ? and ?";
		//$condition_array[1] = $from_date;
		//$condition_array[2] = $to_date;

		$qry1 = $qry;//opening
		/*$qry2 = $qry." and stock_status = 1 and status = 1";//receipt
		$qry3 = $qry." and stock_status = 2 and status = 1";//purchase
		$qry4 = $qry." and stock_status = 3 and status = 1";//rejection_out
		$qry5 = $qry." and stock_status = 4 and status = 1";//debit
		$qry6 = $qry." and stock_status = 5 and status = 1";//delivery
		$qry7 = $qry." and stock_status = 6 and status = 1";//sales
		$qry8 = $qry." and stock_status = 7 and status = 1";//rejection_in
		$qry9 = $qry." and stock_status = 8 and status = 1";//credit
		$qry10 = $qry." and stock_status = 9 and status = 1";//phy_stock
		$qry11 = $qry." and stock_status = 10 and status = 1";//transfer*/

		$qry1_res = $this->CI->db->query($qry1, $condition_array);//opening
	/*	$qry2_res = $this->CI->db->query($qry2, $condition_array);//receipt
		$qry3_res = $this->CI->db->query($qry3, $condition_array);//purchase
		$qry4_res = $this->CI->db->query($qry4, $condition_array);//rejection_out
		$qry5_res = $this->CI->db->query($qry5, $condition_array);//debit
		$qry6_res = $this->CI->db->query($qry6, $condition_array);//delivery
		$qry7_res = $this->CI->db->query($qry7, $condition_array);//sales
		$qry8_res = $this->CI->db->query($qry8, $condition_array);//rejection_in
		$qry9_res = $this->CI->db->query($qry9, $condition_array);//credit
		$qry10_res = $this->CI->db->query($qry10, $condition_array);//phy_stock
		$qry11_res = $this->CI->db->query($qry11, $condition_array);//transfer*/

		$opening = $qry1_res->row()->qty;
		/*$receipt = $qry2_res->row()->qty;
		$purchase = $qry3_res->row()->qty;
		$rejection_out = $qry4_res->row()->qty;
		$debit = $qry5_res->row()->qty;
		$delivery = $qry6_res->row()->qty;
		$sales = $qry7_res->row()->qty;
		$rejection_in = $qry8_res->row()->qty;
		$credit = $qry9_res->row()->qty;
		$phy_stock = $qry10_res->row()->qty;
		$transfer = $qry11_res->row()->qty;*/
$total_qty =$opening;
		//$total_qty = ($opening + $receipt + $purchase + $rejection_in + $credit + $phy_stock + $transfer)-($rejection_out + $delivery + $sales + $debit);
		return $total_qty;
	}





#----------------------------------------------------------------------------------------#

public function item_bal_qty_new1($item_id,$branch_id)
	{
		
		$condition_array = array();$total_qty = 0;
		$to_date = date('Y-m-d',strtotime($to_date));
		$from_date = date('Y-m-d',strtotime($from_date));
		$qry = "select qty from item_stock";
		
			$qry .= " where branch_id=".$this->branch_id;
		

		$qry .= " and item_id = ?";
		$condition_array[0] = $item_id;
	    $condition_array[1] = $branch_id;

		$qry1 = $qry;//opening
	

		$qry1_res = $this->CI->db->query($qry1, $condition_array);//opening
	

		$opening = $qry1_res->row()->qty;
		
$total_qty =$opening;
		return $total_qty;
	}








	#---------------------------- get voucher sum ----------------------------------#
	public function get_voucher_sum($args = array())
	{
		$this->CI->db->select_sum('vamount')->from('dms_vouchers')->where(array('company_id' => $this->company_id,'status' => 1));
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		$row = $this->CI->db->get()->row_array();
		return $row['vamount'];
	}
	public function get_voucher_summation($args = array())
	{
		$this->CI->db->select_sum('vamount')->from('dms_vouchers')->where(array('company_id' => $this->company_id,'status' => 1,));
		if(isset($args['conditions']))
		{
			$this->CI->db->where($args['conditions']);
		}
		$row = $this->CI->db->get()->row_array();
		return $row['vamount'];
	}

	public function stock_opening_bal($to_date,$type = 0,$bal_type = 0)
	{
		//type = 0 => branch , type = 1 => company
		//bal_type = 0 => opening , bal_type = 1 => closed

		$to_date = date('Y-m-d',strtotime($to_date));
		$closed = $this->last_closed_yr($to_date);

		$this->CI->db->select_sum('open_amount')->from('dms_stock_open_bals');
		if($type == 0){
			$this->CI->db->where('branch_id',$this->branch_id);
		}
		else{
			$this->CI->db->where('company_id',$this->company_id);
		}
		if($closed){
			$from_date = date('Y-m-d',(strtotime($closed['end_date'])+86400));
			$this->CI->db->where("open_date between '".$from_date."' and '".$to_date."'");
		}
		else{
			$this->CI->db->where('open_date <=',$to_date);
		}
		$this->CI->db->where(array('bal_type' => $bal_type,'status' => 1));
		$row = $this->CI->db->get()->row_array();
		return $row['open_amount'];
	}

	public function stock_open_date($type = 0)
	{
		//type = 0 => branch , type = 1 => company

		$this->CI->db->select('open_date')->from('dms_stock_open_bals');
		if($type == 0){
			$this->CI->db->where('branch_id',$this->branch_id);
		}
		else{
			$this->CI->db->where('company_id',$this->company_id);
		}
		$this->CI->db->where(array('bal_type' => 0,'status' => 1));
		$row = $this->CI->db->get()->row_array();
		if(!empty($row)){
			return $row['open_date'];
		}
		return false;
	}
}