<?php
class Barcode_lib{
    
    public function __construct()
    {
		$this->CI =& get_instance();
	}
	
	public function items()
	{
		$company_id = $this->CI->session->userdata('company_id');
        $conditions = array();
		$conditions['company_id'] = $company_id;
		$conditions['status'] = 1;
		
		$rows = $this->CI->db->select(array('id','item_code','item_name','model_no'))->get_where('item_master',$conditions)->result_array();

		$items = array();
		foreach($rows as $row)
		{ 
		    $item_name = $row['item_code']."| ".$row['item_name'];
		    if($row['model_no'] !=''){ $item_name .= " | ".$row['model_no']; }
		    
		    $items[$item_name] = $item_name; 
		}
		
		return $items;
	}
    
    public function get_item_rate($itemID)
    {  
	    $branch_id = $this->CI->session->userdata('under_id');
		    
	    $res = $this->CI->db->query("select rate from dms_item_rates where item_id ='$itemID' and valid_from >= '2021-08-01' and created_by='-2' order by id desc")->row_array();
		if(!empty($res['rate']))
		{
		    $rate = $res['rate'];
		}
		else
		{
    		$row = $this->CI->db->query("select max(si.rate) as rt from dms_sales as s inner join dms_sales_items as si on s.group_id=si.group_id where si.status='1' and s.branch_id='$branch_id' and si.item_id='$itemID'")->row_array();
                    
    		if(!empty($row['rt']))
    		{
    		    $rate = $row['rt'];
    		}
    		else
    		{
    		    $this->CI->db->select('rate');
            	$this->CI->db->from('dms_item_rates');
            	$this->CI->db->where(array('company_id' => $this->CI->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
            	$this->CI->db->order_by('id','desc');
            	$this->CI->db->limit(1);
        
        		$row1 = $this->CI->db->get()->row_array();
        	    $rate = $row1['rate'];
    	    }
		} 

		if($rate!='')
		{
			return $rate;
		}
		return false;
	}
	
	public function get_stock_count($godown_id,$item_id,$date = NULL)
	{
		if(empty($date))
		{
			$date = $this->CI->dms->get_fiscal_year()['end_date'];
		    $s_date = $this->CI->dms->get_fiscal_year()['start_date'];
		}
		$s_date = $this->CI->dms->get_fiscal_year()['start_date'];
		$date = date('Y-m-d',strtotime($date)); $in=0; $out=0;
        $ops = $this->CI->db->query("SELECT sum(qty) as open_qty from dms_stocks where godown_id='$godown_id' and item_id='$item_id' and stock_date >='$s_date' and stock_date <='$date' and stock_status in (0,1,2,7,8,9,10) and status=1");
		$row = $ops->row_array();
		if(!empty($row))
		{
            $in = $row['open_qty'];
		}
        $opss = $this->CI->db->query("SELECT sum(qty) as open_qty from dms_stocks where godown_id='$godown_id' and item_id='$item_id' and stock_date >='$s_date' and stock_date <='$date' and stock_status in (3,4,5,6) and status=1");
		$rows = $opss->row_array();
        if(!empty($rows))
		{
            $out = $rows['open_qty'];
		}        
        $bal = $in-$out;

        return $bal;
	}
	
	public function get_branch_godown($branch_id)
	{
		$row = $this->CI->db->select('id')->get_where('godown_master',array('branch_id' => $branch_id,'status'=>1))->row_array();
		if(!empty($row))
		{
			return $row['id'];
		}
		return false;
	} 

    public function get_item_by_code($item_code)
    { 
        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');

		$this->CI->db->select(array('id','item_name','model_no'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code'=>$item_code,'status'=>1));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $data['id'] = $item_id;
		    $data['code'] = $item_code;
		    $data['name'] = $row['item_name'];
		    $data['model'] = $row['model_no'];
		    
		    $rate = $this->get_item_rate($item_id);
		    if(empty($rate)){ $rate=0;}
		    $data['rate'] = $rate;
		    
		    $godown = $this->get_branch_godown($branchID);
		    
		    $cqty = $this->get_stock_count($godown,$item_id,date('Y-m-d'));
		    $data['cqty'] = $cqty;
		    
			return $data;
		}
		return false;
	}
	
	public function get_item_by_name($item_name)
    { 
        $data = array();
        $companyID = $this->CI->session->userdata('company_id');
        $branchID = $this->CI->session->userdata('under_id');
        
        $item_array = explode("|",$item_name);
        $item_code = $item_array[0];
        
		$this->CI->db->select(array('id','item_code','item_name','model_no'));
		$this->CI->db->from('item_master');
		$this->CI->db->where(array('item_code'=>$item_code));
		$this->CI->db->order_by('id','desc');
		$this->CI->db->limit(1);

		$row = $this->CI->db->get()->row_array();
		
		$item_id = $row['id'];

		if(!empty($row))
		{
		    $data['id'] = $item_id;
		    $data['code'] = $row['item_code'];
		    $data['name'] = $item_name;
		    $data['model'] = $model_no;
		    
		    $rate = $this->get_item_rate($item_id);
		    if(empty($rate)){ $rate=0;}
		    $data['rate'] = $rate;
		    
		    $godown = $this->get_branch_godown($branchID);
		    
		    $cqty = $this->get_stock_count($godown,$item_id,date('Y-m-d'));
		    $data['cqty'] = $cqty;
		    
			return $data;
		}
		return false;
	}
    
}
?>