<?php 

	class Cart_lib{

	#-------------------------------------------
	
	function prepare_cart(){

		$cart = $this->get_current_active_cart();

		if(!$cart){
			$cart_id = $this->add_new_cart();
		}else{
			$cart_id = $cart['id'];
		}

		return $cart_id;
	}	

	#-------------------------------------------
	
	function add_new_cart(){

		$CI =& get_instance();
		$chars = 'abcdefghijklmnopqrstuvwxyzABDEFGHIJKLMNOPQRSTUVWXYZ';
		$data['cart_ID'] = rand(0,9999999).$chars[rand(0,25)];
		$data['status'] = 1;
		$data['created_by'] = $CI->session->userdata('id');
		$data['created_on'] = date('Y-m-d h:i:s');

		$CI->db->insert('cart_master',$data);
		return $CI->db->insert_id();
		
	}	

	#-------------------------------------------

	function get_current_active_cart(){

		$CI =& get_instance();

		$row = $CI->db->get_where('cart_master',array('status'=>1))->row_array();

		if(empty($row)){ return FALSE; }
		else{ return $row; }
	}

	#-------------------------------------------	
	function empty_the_cart(){

		$CI =& get_instance();
		$cart = $this->get_current_active_cart();
		return $CI->db->update('cart_master',array('status'=>0),array('id'=>$cart[id]));
	}

	#--------------------------------------------

	function total_items(){

		$CI =& get_instance();
		$row = $this->get_current_active_cart();

		if($row){
			$total = $CI->db->from('requested_stocks')->where(array('cart_id'=>$row['id']))->count_all_results();
			if($total > 0){
				return $total;
			}
		}

		return 0;
	}


	#--------------------------------------------
	#date : 22-8-2014
	#purpose : has added for a purchase trip (input : request_stocks PK - id)?
	function has_added_for_trip($id){

		$cart = $this->get_current_active_cart();

		$CI =& get_instance();
		$row = $CI->db->get_where('temp_cart_item_vehicles',array('rs_id'=>$id,'cart_id'=>$cart['id']))->row_array();
		
		if(!empty($row)){ return TRUE; }
		else{ return FALSE; }
	}
	#----------------------------------------------

	#date : 22-8-2014
	#purpose : get currently added-for_trip items
	function added_for_trip_items(){

		$cart = $this->get_current_active_cart();

		$CI =& get_instance();
		$CI->db->select(array('rs.*','i.item_name','u.symbol'));
		$CI->db->from('requested_stocks rs');
		$CI->db->join('item_master i','i.id=rs.item_id');
		$CI->db->join('unit_master u','u.id=rs.item_unit');
		$CI->db->join('temp_cart_item_vehicles tciv','tciv.rs_id=rs.id');
		$CI->db->where('tciv.cart_id',$cart['id']);
		return $CI->db->get()->result_array();

	}

	#-------------------------------------------------
	#date : 04-09-2014
		function convert_to_primary($args){

			#get units primary unit
			#$row = $this->db->get_where('item_units',array('item_id'=>$args['item_id'],'status'=>'primary'))->row_array();
			$CI =& get_instance();

			$CI->db->select(array('unit_master.symbol','item_units.unit_id'));
			$CI->db->from('item_units');
			$CI->db->join('unit_master','unit_master.id=item_units.unit_id');
			$CI->db->where(array('item_units.item_id'=>$args['item_id'],'item_units.status'=>'primary'));
			$row = $CI->db->get()->row_array();
			$primary_unit = $row['unit_id'];

			$conversion = $this->find_conversion_rate($primary_unit,$args['current_unit']);
			return $conversion;
			return array('conversion'=>$conversion,'unit'=>$row['symbol']);
		}


		#----------------------------------------------

		#date : 04-09-2014
		function find_conversion_rate($primary,$current_unit,$conversion = 1){

			#echo $current_unit;die;
			$CI =& get_instance();

			#if(!isset($conversion)){ $conversion = 1; }

			if($primary == $current_unit){ return $conversion; }

			$row = $CI->db->get_where('unit_master',array('id'=>$current_unit/*,'unit_type'=>'compound'*/))->row_array();
			#echo $CI->db->last_query().'<hr/>';

			$conversion = $conversion * $row['conversion'];

			if($row['second_unit'] == $primary || $row['unit_type'] == 'simple'){
				return $conversion;
			}else{
				return $this->find_conversion_rate($primary,$row['second_unit'],$conversion);
			}

			#die('Could not find conversion unit');

		}

		#-----------------------------------------------

	}

?>