<?php
class Leaves
{
	public function __construct()
	{
		$this->CI =& get_instance();
	}

	public function leave_types($type = 0,$select = 0)
	{
		#------type = 0 => both company = 0 and current company, 1 => current company only
		#------select = 0 => result in select box

		$leave_types = array();
		$this->CI->db->select(array('id','leave_type','type_color','type_description'))->from('employee_leave_type');
		if($type == 0){
			$this->CI->db->where("(company_id = 0 or company_id = ".$this->CI->session->userdata('company_id').")");
		}
		else{
			$this->CI->db->where('company_id',$this->CI->session->userdata('company_id'));
		}
		$row = $this->CI->db->where('status', 1)->order_by('id')->get()->result_array();
		if(!empty($row))
		{
			if($select == 0)
			{
				foreach($row as $key){
					$leave_types[$key['id']] = $key['leave_type'];
				}
				return $leave_types;
			}
			return $row;
		}
		return false;		
	}

	public function ltype_name($id)
	{
		$row = $this->CI->db->select('leave_type')->get_where('employee_leave_type',array('id' => $id,'status' => 1))->row_array();
		if(!empty($row)){
			return $row['leave_type'];
		}
		return false;
	}

	#--------------leave balance
	public function leave_bal($user_id,$year,$type = 0)
	{
		#----------type = 0 => leave types including max_leave = 0, type = 1 => non zero max_leave leave_types only

		$leave_type_array = array();
		$from_date = $year."-01-01";
		$to_date = $year."-12-31";

		#-----------designation id
		$desig_id = $this->CI->dms->get_desig($user_id);		

		$row = $this->CI->db->select(array('leave_type_id'))->get_where('designation_leave_types',array('designation' => $desig_id,'from_date' => $from_date,'to_date' => $to_date))->result_array();
		if(!empty($row))
		{
			foreach($row as $key => $value)
			{
				$leave_type_array += $this->total_assigned_leaves($user_id,$from_date,$value['leave_type_id'],$type);				
			}
		}
		return $leave_type_array;
	}

	#---------------total assigned leaves
	public function total_assigned_leaves($user_id,$from_date,$leave_type,$type = 0)
	{
		$leave_bal = $leaves_taken = 0;$leave_array = array();
		$year = date('Y',strtotime($from_date));
		$from_date = $year."-01-01";

		#-----------designation id
		$desig_id = $this->CI->dms->get_desig($user_id);	

		$row = $this->CI->db->select(array('max_permissible','from_date','to_date'))->get_where('designation_leave_types',array('designation' => $desig_id,'leave_type_id' => $leave_type,'from_date' => $from_date,'status' => 1))->row_array();
		if(!empty($row))
		{
			#-------------total leaves taken in current year
			$leaves_taken = $this->total_leaves_taken($user_id,$row['from_date'],$row['to_date'],$leave_type);

			$leave_bal += ($row['max_permissible'] - $leaves_taken);
		}
		$row1 = $this->CI->db->select(array('max_permissible','from_date','to_date'))->get_where('designation_leave_types',array('designation' => $desig_id,'leave_type_id' => $leave_type,'carry_forward' => 1,'from_date <' => $from_date,'status' => 1))->result_array();
		if(!empty($row1))
		{
			foreach($row1 as $key => $value)
			{
				#-------------total assigned leaves in this year
				$total_yr_leaves = $value['max_permissible'];

				#-------------total leaves taken in pre years
				$total_leaves_taken = $this->total_leaves_taken($user_id,$value['from_date'],$value['to_date'],$leave_type);

				$leave_bal += ($total_yr_leaves - $leaves_taken);
			}
		}
		if($type == 0){
			$leave_array[$leave_type] = array('leave_bal' => $leave_bal,'leaves_taken' => $leaves_taken);
		}
		else{
			if($leave_bal > 0){
				$leave_array[$leave_type] = $this->ltype_name($leave_type);
			}
		}
		return $leave_array;
	}	

	public function total_leaves_taken($user_id,$from_date,$to_date,$leave_type)
	{
		#-------------total full leave taken in this year
		$this->CI->db->from('employee_attendance')->where('user_id',$user_id);
		$this->CI->db->where("date between '$from_date' and '$to_date'",NULL,false);
		$full_leave_count = $this->CI->db->where(array('attend' => 0,'leave_type' => $leave_type,'status' => 1))->count_all_results();

		#-------------total half leave taken in this year
		$this->CI->db->from('employee_attendance')->where('user_id',$user_id);
		$this->CI->db->where("date between '$from_date' and '$to_date'",NULL,false);
		$this->CI->db->where("(attend=1 or attend=2)");
		$half_leave_count = ($this->CI->db->where(array('leave_type' => $leave_type,'status' => 1))->count_all_results())/2;
		return ($full_leave_count + $half_leave_count);
	}

	public function attendance_marked($user_id,$from_date,$to_date)
	{
		#-------------total present
		$this->CI->db->from('employee_attendance')->where('user_id',$user_id);
		$this->CI->db->where("date between '$from_date' and '$to_date'",NULL,false);
		$present = $this->CI->db->where(array('attend' => 3,'status' => 1))->count_all_results();

		#-------------total full-day leaves
		$this->CI->db->from('employee_attendance')->where('user_id',$user_id);
		$this->CI->db->where("date between '$from_date' and '$to_date'",NULL,false);
		$full_leave = $this->CI->db->where(array('attend' => 0,'status' => 1))->count_all_results();

		#-------------total half-day leaves
		$this->CI->db->from('employee_attendance')->where('user_id',$user_id);
		$this->CI->db->where("date between '$from_date' and '$to_date'",NULL,false);
		$half_leave = $this->CI->db->where("(attend=1 or attend=2) and status=1")->count_all_results();
		
		$total_marked = $present + $full_leave + $half_leave;
		$total_leaves = $full_leave + ($half_leave/2);
		$present += ($half_leave/2);
		return array('marked' => $total_marked,'present' => $present,'absent' => $total_leaves);
	}
}