<?php
class My_pdf{
	
	/*-----------------------------------------------------------*/
	var $obj_pdf;
	var $pdf_contents = NULL;
	var $companyID;
	var $branchID;
		
	public function __construct(){
		
			$this->CI =& get_instance();
			$this->companyID = $this->CI->session->userdata('company_id');
			$this->branchID = $this->CI->session->userdata('under_id');
					
			require_once APPPATH.'third_party/pdf/tcpdf.php';
			$this->obj_pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
			$this->obj_pdf->SetCreator(PDF_CREATOR);
			$this->obj_pdf->SetFontSize(12);
			$this->obj_pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
			$this->obj_pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
			$this->obj_pdf->AddPage('P','A4',false,false);
			$this->obj_pdf->SetMargins (5,5,5,true);
			#$this->pdf_contents .= ''
	}
	
	#------------------------------------------------------------
	public function set_tin(){
		
			$company = $this->CI->db->select(array('company_register_no','cst_no','pin_no','tin_no'))->get_where('company_master',array('id'=>$this->CI->session->userdata('company_id')))->row_array();
			$regNo = $company['company_register_no'];
			$cstRegNo = $company['cst_no'];
			$pinNum = $company['pin_no'];
			$tinNum = $company['tin_no'];
			
			$this->pdf_contents .= '<style>';
			$this->pdf_contents .= '.small{font-size:8px;}';
			$this->pdf_contents .= '.medium{font-size:10px;}';
			$this->pdf_contents .= '.large{font-size:16px;}';
			$this->pdf_contents .= '.xlarge{font-size:18px;}';
			$this->pdf_contents .= '.header{width:530px;}';
			$this->pdf_contents .= '.company-name{color:#000; font-weight:bold; font-size:14px;}';
			$this->pdf_contents .= '.company-address{color:#000; font-size:10px;}';
			$this->pdf_contents .= '.center{text-align:center;}'	;
			$this->pdf_contents .= '.bold{font-weight:bold;}';
			$this->pdf_contents .= '</style>';	
			$this->pdf_contents .= '<table align="center" class="header" border="0">';
			$this->pdf_contents .= '<tr class="small"><td align="left">TIN : '.$tinNum.'</td><td align="right">CST Reg. No : '.$cstRegNo.'</td></tr>';
			$this->pdf_contents .= '</table>';
	}
	
	#------------------------------------------------------------
	
	public function set_header(){
		
		$company = $this->CI->db->select(array('company_name','company_address','country','state','company_landline','company_mobile','company_website','gstn','company_email'))->get_where('company_master',array('id'=>$this->CI->session->userdata('company_id')))->row_array();
		$company_name = $company['company_name'];
		$country = (!empty($company['country']))?' , '.$company['country']:'';
		$state = (!empty($company['state']))?' , '.$company['state']:'';
		$website = (!empty($company['company_website']))?'Website : '.$company['company_website']:'';
		
		$branch = $this->CI->db->select(array('branch_name','branch_address','branch_landline','branch_mobile','branch_email','gstin'))->get_where('branch_master',array('id'=>$this->branchID))->row_array();
		$company_address = $branch['branch_address'];
		$country = 	$state = NULL;
		$land_line = (!empty($branch['branch_landline']))?' Ph : '.$branch['branch_landline']:'';
		$mobile = $branch['branch_mobile'];
		$gstn =  $branch['gstin'];
		$email = (!empty($branch['branch_email']))?' Email : '.$branch['branch_email']:'';
			
		$this->pdf_contents .= '<style>';
		$this->pdf_contents .= '.small{font-size:8px;}';
		$this->pdf_contents .= '.medium{font-size:10px;}';
		$this->pdf_contents .= '.large{font-size:16px;}';
		$this->pdf_contents .= '.xlarge{font-size:18px;}';
		$this->pdf_contents .= '.header{width:530px;}';
		$this->pdf_contents .= '.company-name{color:#000; font-weight:bold; font-size:14px;}';
		$this->pdf_contents .= '.company-address{color:#000; font-size:10px;}';
		$this->pdf_contents .= '.center{text-align:center;}'	;
		$this->pdf_contents .= '.bold{font-weight:bold;}';
		$this->pdf_contents .= '</style>';	
		
                           		
		$this->pdf_contents .= '<table  class="header" border="0">';
		$this->pdf_contents .= '<tr><td align="left" width="50%" rowspan="4"><img src ="https://allenopticals.relents.in/assets/images/logo.png" width="70px"></td>';
		$this->pdf_contents .= '<td align="right"><b><h4>'.$company_name.'</h4></b></td></tr>';
		$this->pdf_contents .= '<tr><td align="right">'.$company_address.'</td></tr>';
		$this->pdf_contents .= '<tr><td align="right">'.$land_line.' Mob : '.$mobile.'</td></tr>';
		$this->pdf_contents .= '<tr><td align="right">'.$email.'</td></tr>';
		$this->pdf_contents .= '</table>';
		$this->pdf_contents .= '<hr>';
	}
	#------------------------------------------------------------
	
	public function set_content($pdf_contents){
		$this->pdf_contents .= $pdf_contents;
	}
	#------------------------------------------------------------
	public function set_margin($left,$top,$right=-1,$keepmargins=false){
		$this->obj_pdf->SetMargins ($left, $top,$right,$keepmargins);
	}
	#------------------------------------------------------------
	
	public function set_image($image_file,$x=NULL,$y=NULL,$w=40,$h=40,$type=NULL,$link=NULL,$align=NULL,$resize=false,$dpi=300,$palign=NULL,$ismask=false,$imgmask=false,$border=0,$fitbox=false,$hidden=false, $fitonpage=false){
		
		$this->obj_pdf->setJPEGQuality(75);
		if(file_exists($image_file)){
			$this->obj_pdf->Image($image_file,$x,$y,$w,$h,$type,$link,$align,$resize,$dpi,$palign,$ismask,$imgmask,$border,$fitbox,$hidden,$fitonpage);		
		}

	}
	
	#------------------------------------------------------------
	
	public function set_barcode($code){
		
		$style = array('position' => 'L','align' => 'L','stretch' => false,'fitwidth' => false,'cellfitalign' => '','border' => false,'hpadding' => '','vpadding' => '','fgcolor' => array(0,0,0),'bgcolor' => false,'text' => true,'font' => 'helvetica','fontsize' => 8,'stretchtext' => 100);
		$this->obj_pdf->write1DBarcode($code, 'MSI', '', '', '', 10, 0.6, $style, 'N');
		
	}
	
	#--------------------------------------------------------------------------------------------
	
	public function add_page($orientation='P',$format='A4',$keepmargins=false,$tocpage=false){
		
		$this->obj_pdf->writeHTML($this->pdf_contents, true, false, true, false,'');
		$this->pdf_contents = NULL;
		$this->obj_pdf->AddPage($orientation,$format,$keepmargins,$tocpage);
		
	}

	#------------------------------------------------------------
	
	public function set_footer(){
		$this->obj_pdf->setFooterData(array(0,64,0), array(0,64,128));
	}
	
	#-------------------------------------------------------------
	
	public function output($file_name=NULL,$pdf_contents=NULL){

		$this->pdf_contents .= $pdf_contents;
		if(empty($file_name)){
			$file_name = 'pdf_'.date('d_M-Y');
		}
		$this->obj_pdf->SetTitle(utf8_encode($file_name));
    	$this->obj_pdf->writeHTML($this->pdf_contents, true, false, true, false,'');
		$this->obj_pdf->Output($file_name.'.pdf', 'I');
				
	}
}
?>