<?php
class Payment_ab_lib{

	#=========================
	# Receipt Against Bill Library
	#=========================

	public function __construct(){
		$this->CI =& get_instance();
	}

	#=========================

	public function get_vendor_bill($vendor_id){

		$vendorBills = array();
		$this->CI->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$branchID = $this->CI->session->userdata('under_id');
		$args = array();
		$args['vendor_id'] = $vendor_id;
		$vendorBillsArray = $this->CI->payment_against_bill->get_vendor_bill($args);

		foreach($vendorBillsArray as $key=>$bill_details){

			$bill_amount = $this->get_purchase_bill($bill_details['id'])['bill_amount'];
			$billPaidAmount = $this->get_bill_payment($bill_details['id']);
			$balanceAmount = $bill_amount-$billPaidAmount;
			$args = array();
			$args['select'] = array('dvab.id');
			$args['conditions'] = array('dvab.branch_id'=>$branchID,'dvab.bill_type'=>1,'dvab.status'=>-1,'dvabi.ps_id'=>$bill_details['id']);
			$args['join'] = array('dms_voucher_against_bill_items as dvabi'=>	'dvab.id=dvabi.vid');
			$exists = $this->CI->payment_against_bill->get($args);
			if(empty($exists)){
				$vendorBills[$bill_details['id']] = $bill_details['bill_no'];
			}
		}
		if(empty($vendorBills)){
			$vendorBills[''] ='No bill found!';
		}
		return $vendorBills;

	}

	#=========================

	public function get_purchase_bill($purchase_bill_ID){

		$bill_details = array();
		$this->CI->load->model('payments/Payment_against_bill_model','payment_against_bill');
		$this->CI->load->library('Stock');
                $purchase_bill = $this->CI->payment_against_bill->get_purchase_bill($purchase_bill_ID);

                if(!empty($purchase_bill)){
			$presumptive_tax = $this->CI->stock->get_tax_type();
			$i=$totalAmount=$totalDiscountAmt=$totalNetValue=$totalVatAmt=$totalNetAmount=0;
			$grandNetAmount=0;$total_cst_amount = 0;
			$cess = $purchase_bill[0]['cess'];
			$bill_freight = $purchase_bill[0]['bill_freight'];
			$other_expense = $purchase_bill[0]['other_expense'];
			$bill_discount_amt = $purchase_bill[0]['bill_discount_amt'];
            $courier_charge = $purchase_bill[0]['courier_charge'];
			$bill_date = $purchase_bill[0]['bill_date'];

			foreach($purchase_bill as $key=>$purchase){

				$qty = $purchase['qty'];
				$rate = $purchase['rate'];
				$itemID = $purchase['item_id'];
				$discount_per = $purchase['discount_per'];
				$discount_amt = $purchase['discount_amt'];
				$vat = 0;$vatAmount = 0;$cst_amount = 0;
				$amount = $purchase['amount'];
				$taxable = $purchase['taxable_amt'];
				$totalAmount += $amount;
				$netValue = $amount-$discount_amt;
				
				$vatAmount = $purchase['vat_amt'];
                $cessAmount = $purchase['cess_amt'];
                                
				$netAmount = $taxable+$vatAmount+$cessAmount;	
				
				$totalNetAmount += $netAmount;
				$totalDiscountAmt += $discount_amt;
			}
			$grandNetAmount = $totalNetAmount;
			$presumptive_tax_amt = 0;
						
			$grandNetAmount += (($bill_freight+$other_expense+$courier_charge)-$bill_discount_amt);
			$bill_details['bill_date'] = cdateFormat($bill_date);
			$bill_details['bill_amount'] = round_this($grandNetAmount)+round_off($grandNetAmount);
		}


                
		return $bill_details;

	}

	#==========================

	public function get_bill_payment($purchase_bill_ID,$conditions=array(),$return=NULL){

		$this->CI->db->select(array("sum(received_amount) as received_amount",'sum(discount) as discount'));
		$this->CI->db->from('dms_voucher_against_bills dvab');
		$this->CI->db->join('dms_voucher_against_bill_items as dvabi','dvab.id=dvabi.vid');
		$this->CI->db->where(array('dvabi.ps_id'=>$purchase_bill_ID,'dvabi.status'=>1,'dvab.bill_type'=>1));
		if(!empty($conditions)){
			$this->CI->db->where($conditions);
		}
		$row = $this->CI->db->get()->row_array();
		if($return == NULL){
			return $row['received_amount'];
		}else{
			return array('amount'=>$row['received_amount'],'discount'=>$row['discount']);
		}
	}

	#==========================

       public function get_all_vendor_bill($vendor_id){

		$vendorBills = array();
		$bill_details = array();
		$vendorBills= $this->get_vendor_bill($vendor_id);
                if(!empty($vendorBills))
                {
		        foreach($vendorBills as $key => $value)
                        {
                        	$bill_det = array();
                                $purchase_ID = $key;
                                
				$purchase_bill = $this->get_purchase_bill($purchase_ID);
				$bill_payment = $this->get_bill_payment($purchase_ID);
				if(empty($bill_payment)){$bill_payment=0;}
		                if(empty($purchase_bill)){$purchase_bill=0;}	
		                $bill_det['bill_no']= $value;	
		                $bill_det['bill_date'] = cdateFormat($purchase_bill['bill_date']);
		                $bill_det['bill_amount'] = get_rounded($purchase_bill['bill_amount']);
		                $bill_det['prev_amount'] = $bill_payment;
		                $bill_details[$key] = $bill_det;																
			}
		}
		return $bill_details;
	} 
}
?>