<?php
class Purchase_lib
{
	public function __construct()
	{		
		$this->CI =& get_instance();
		
		#-----------fiscal year dates
		$this->fiscal_start_date = $this->CI->dms->get_fiscal_year()['start_date'];
		$this->fiscal_end_date = $this->CI->dms->get_fiscal_year()['end_date'];
		$this->branch_id = $this->CI->session->userdata('under_id');
	}
	
	public function get_bill_date($pid,$p_status)
	{
		if($p_status == 2){//purchase_order		
			$row = $this->CI->db->select('po_date')->get_where('dms_purchase_orders',array('id' => $pid))->row_array();
			return $row['po_date'];
		}
		elseif($p_status == 3){//receipt_note		
			$row = $this->CI->db->select('bill_date')->get_where('dms_receipt_notes',array('id' => $pid))->row_array();
			return $row['bill_date'];
		}
		elseif($p_status == 1){//purchase_requests		
			$row = $this->CI->db->select('request_date')->get_where('dms_purchase_requests',array('id' => $pid))->row_array();
			return $row['request_date'];
		}
	}
	
	#-----------purchase_order to receipt_note conversion/checking group_id exists
	public function por_group_id_exists($group_id)
	{		
		$row = $this->CI->db->select(array('pid','p_status'))->from('dms_receipt_notes')->where(array('group_id !=' => $group_id,'status' => -1,'branch_id' => $this->branch_id))->where("bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,false)->get()->row_array();		
		if(!empty($row)){
			if(!empty($row['pid'])){
				if($row['p_status'] == 2){//purchase_order				
					return "order_to_receipt/receipt/".$row['pid'];
				}
				elseif($row['p_status'] == 1){//purchase_request				
					//return "order_to_receipt/receipt/".$row['pid'];
				}
			}
			else{
				return "receipt_note/add";
			}
		}
		else{
			$row1 = $this->CI->db->select('id')->get_where('dms_purchases',array('group_id' => $group_id,'status !=' => 0))->row_array();			
			if(!empty($row1)){
				return "users/logout";
			}
			else{
				$row2 = $this->CI->db->select('id')->from('dms_receipt_notes')->where('group_id',$group_id)->where("(status = 1 or status = 2)")->get()->row_array();
				if(!empty($row2)){
					return "users/logout";
				}
				return false;
			}
		}
	}
	
	#-----------purchase_order to purchase conversion/checking group_id exists
	public function pop_group_id_exists($group_id)
	{		
		$row = $this->CI->db->select(array('pid','p_status'))->from('dms_purchases')->where(array('group_id !=' => $group_id,'status' => -1,'branch_id' => $this->branch_id))->where("bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,false)->get()->row_array();
		if(!empty($row)){
			if(!empty($row['pid'])){
				if($row['p_status'] == 3){//receipt_note				
					return "receipt_to_purchase/purchase/".$row['pid'];
				}
				elseif($row['p_status'] == 1){//purchase_request				
					//return "order_to_receipt/receipt/".$row['pid'];
				}
			}
			else{
				return "purchase/add";
			}
		}
		else{
			$row1 = $this->CI->db->select('id')->get_where('dms_receipt_notes',array('group_id' => $group_id,'status !=' => 0))->row_array();
			if(!empty($row1)){
				return "users/logout";
			}
			else{
				$row2 = $this->CI->db->select('id')->from('dms_purchases')->where('group_id',$group_id)->where("(status = 1 or status = 2)")->get()->row_array();
				if(!empty($row2)){
					return "users/logout";
				}
				return false;
			}
		}
	}
	
	#-----------receipt_note to purchase conversion/checking group_id exists
	public function rp_group_id_exists($group_id)
	{		
		$row = $this->CI->db->select(array('pid','p_status'))->from('dms_purchases')->where(array('group_id !=' => $group_id,'status' => -1,'branch_id' => $this->branch_id))->where("bill_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,false)->get()->row_array();
		if(!empty($row)){
			if(!empty($row['pid'])){
				if($row['p_status'] == 2){//purchase_order				
					return "order_to_purchase/po_purchase/".$row['pid'];
				}
				elseif($row['p_status'] == 1){//purchase_request				
					//return "order_to_receipt/receipt/".$row['pid'];
				}
			}
			else{
				return "purchase/add";
			}
		}
		else{
			$row1 = $this->CI->db->select('id')->from('dms_purchases')->where('group_id',$group_id)->where("(status = 1 or status = 2)")->get()->row_array();
			if(!empty($row1)){
				return "users/logout";
			}
			return false;
		}
	}
}