<?php
class Tax
{
	public function __construct(){

		$this->CI =& get_instance();
	}

	public function getAllTaxes()
	{
		$row = $this->CI->db->distinct()->select('vat')->get_where('tax_master',array('company_id' => $this->CI->session->userdata('company_id')))->result_array();
		if(!empty($row)){
			return $row;
		}
		return false;
	}

	public function getTotalSalesVat($vat,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$row = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.vat' => $vat,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$vat_amt = round_this($row['vat_amt']);
		if($vat_amt != 0){
			return array('vat' => $vat,'amount' => $amount,'vat_amt' => $vat_amt);
		}
		return false;
	}
    
	public function getTotalWholesalesVat($vat,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$row = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(b.vat_amt) as vat_amt'))->from('dms_wholesale as a')->join('dms_wholesale_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.vat' => $vat,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$vat_amt = round_this($row['vat_amt']);

	    if($vat_amt != 0){
			return array('vat' => $vat,'amount' => $amount,'vat_amt' => $vat_amt);
		}
		return false;
	}
	public function getTotalSalesCess($cess,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
	    $row = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(b.cess_amt) as cessamt'))->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1,'a.vtype_id!='=>16))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$cess_amt = round_this($row['cessamt']);
		if($cess_amt != 0)
		{
			return array('cess' => $cess,'amount' => $amount,'cess_amt' => $cess_amt);
		}
		return false;
	}

	public function getTotalSalesReturnVat($vat,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$row = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->from('dms_sales_returns as a')->join('dms_sales_return_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.vat' => $vat,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$vat_amt = round_this($row['vat_amt']);
		if($vat_amt != 0){
			return array('vat' => $vat,'amount' => -$amount,'vat_amt' => -$vat_amt,'type' => 1);
		}
		return false;
	}

	public function getTotalSalesReturnCess($cess,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$row = $this->CI->db->select(array('sum(taxable_amt) as amount','(sum(cess_amt)) as cessamt'))->from('dms_sales_returns as a')->join('dms_sales_return_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.vat' => $vat,'b.status' => 1,'a.vtype_id!='=>18))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$cess_amt = round_this($row['cessamt']);
		if($cess_amt != 0){
			return array('cess' => $cess,'amount' => -$amount,'cess_amt' => -$cess_amt,'type' => 1);
		}
		return false;
	}

	public function getTotalPurchaseVat($vat,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$row = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->from('dms_purchases as a')->join('dms_purchase_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.vat' => $vat,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$vat_amt = round_this($row['vat_amt']);
		if($vat != 0){
			return array('vat' => $vat,'amount' => $amount,'vat_amt' => $vat_amt);
		}
		return false;
	}

	public function getTotalPurchaseReturnVat($vat_percent,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$row = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->from('dms_purchase_returns as a')->join('dms_purchase_return_items as b','a.group_id = b.group_id')->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.vat' => $vat,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->row_array();
		$amount = round_this($row['amount']);
		$vat_amt = round_this($row['vat_amt']);
		if($vat != 0){
			return array('vat' => $vat,'amount' => -$amount,'vat_amt' => -$vat_amt,'type' => 1);
		}
		return false;
	}

	public function getVouchers($vat_type,$vat = NULL,$from_date,$to_date)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		$voucher_array = array();
		if($vat_type == 1)//sales
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','a.group_id','payment_mode','customer_type_id','customer_id'))->from("dms_sales as a");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_sales_items as c","a.group_id=c.group_id")->where(array('c.vat' => $vat,'c.status' => 1,'a.vtype_id!='=>16));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->get_customer($value['customer_type_id'],$value['customer_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->get_where('dms_sales_items',array('group_id' => $value['group_id'],'vat' => $vat,'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$vat_amt = round_this($result['vat_amt']);
					
				    if($amount != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'customer'=>$customer,'payment_mode' => $value['payment_mode'],'ledger_name' => 'Sales','vtype' => 'Sales','amount' => $amount,'vat_amt' => $vat_amt);
					}
				}
			}
		}
		elseif($vat_type == 2)//sales_return
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','a.group_id','payment_mode','ledger_name','customer_type_id','customer_id'))->from("dms_sales_returns as a")->join("dms_ledgers as b","a.payment_mode=b.id");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_sales_return_items as c","a.group_id=c.group_id")->where(array('c.vat' => $vat,'c.status' => 1));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->get_customer($value['customer_type_id'],$value['customer_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->get_where('dms_sales_return_items',array('group_id' => $value['group_id'],'vat' => $vat,'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$vat_amt = round_this($result['vat_amt']);
				
				    if($amount != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'customer'=>$customer,'payment_mode' => $value['payment_mode'],'ledger_name' => $value['ledger_name'],'vtype' => 'Sales Return','amount' => -$amount,'vat_amt' => -$vat_amt);
					}
				}
			}
		}
		elseif($vat_type == 3)//purchase
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','invoice_no','invoice_date','a.group_id','payment_mode','ledger_name','vendor_id'))->from("dms_purchases as a")->join("dms_ledgers as b","a.payment_mode=b.id");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_purchase_items as c","a.group_id=c.group_id")->where(array('c.vat' => $vat,'c.status' => 1));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->vendor_name($value['vendor_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->get_where('dms_purchase_items',array('group_id' => $value['group_id'],'vat' => $vat,'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$vat_amt = round_this($result['vat_amt']);
			
				    if($amount != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'invoice_no' => $value['invoice_no'],'customer'=>$customer,'invoice_date' => $value['invoice_date'],'payment_mode' => $value['payment_mode'],'ledger_name' => $value['ledger_name'],'vtype' => 'Purchase','amount' => $amount,'vat_amt' => $vat_amt);
					}
				}
			}
		}
		elseif($vat_type == 4)//purchase_return
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','a.group_id','payment_mode','ledger_name','vendor_id'))->from("dms_purchase_returns as a")->join("dms_ledgers as b","a.payment_mode=b.id");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_purchase_return_items as c","a.group_id=c.group_id")->where(array('c.vat' => $vat,'c.status' => 1));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->vendor_name($value['vendor_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->get_where('dms_purchase_return_items',array('group_id' => $value['group_id'],'vat' => $vat,'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$vat_amt = round_this($result['vat_amt']);
				
				    if($amount != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'customer'=>$customer,'payment_mode' => $value['payment_mode'],'ledger_name' => $value['ledger_name'],'vtype' => 'Purchase Return','amount' => -$amount,'vat_amt' => -$vat_amt);
					}
				}
			}
		}
		elseif($vat_type == 5)//cess
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','a.group_id','payment_mode','ledger_name','customer_type_id','customer_id'))->from("dms_sales as a")->join("dms_ledgers as b","a.payment_mode=b.id");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_sales_items as c","a.group_id=c.group_id")->where(array('c.status' => 1,'a.vtype_id!='=>16));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->get_customer($value['customer_type_id'],$value['customer_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(cess_amt) as cessamt'))->get_where('dms_sales_items',array('group_id' => $value['group_id'],'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$cess_amt = round_this($result['cessamt']);
					if($cess_amt != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'customer'=>$customer,'payment_mode' => $value['payment_mode'],'ledger_name' => $value['ledger_name'],'vtype' => 'Sales','amount' => $amount,'vat_amt' => $cess_amt);
					}
				}
			}
		}
		elseif($vat_type == 6)//cess_return
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','a.group_id','payment_mode','ledger_name','customer_type_id','customer_id'))->from("dms_sales_returns as a")->join("dms_ledgers as b","a.payment_mode=b.id");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_sales_return_items as c","a.group_id=c.group_id")->where(array('c.status' => 1));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->get_customer($value['customer_type_id'],$value['customer_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(cess_amt) as cessamt'))->get_where('dms_sales_return_items',array('group_id' => $value['group_id'],'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$cess_amt = round_this($result['cessamt']);
					if($cess_amt != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'customer'=>$customer,'payment_mode' => $value['payment_mode'],'ledger_name' => $value['ledger_name'],'vtype' => 'Sales Return','amount' => -$amount,'vat_amt' => -$cess_amt);
					}
				}
			}
		}
		elseif($vat_type == 7)//wholesales
		{
			$this->CI->db->distinct()->select(array('bill_no','bill_date','a.group_id','payment_mode','ledger_name','branch_to_id'))->from("dms_wholesale as a")->join("dms_ledgers as b","a.payment_mode=b.id");
			if($vat_percent != NULL){
				$this->CI->db->join("dms_wholesale_items as c","a.group_id=c.group_id")->where(array('c.vat' => $vat,'c.status' => 1,'a.vtype_id!='=>16));
			}
			$row = $this->CI->db->where(array('a.branch_id' => $this->CI->session->userdata('under_id'),'a.status' => 1,'b.status' => 1))->where("a.bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
			if($row)
			{
				foreach($row as $key => $value)
				{
				    $customer = $this->CI->stock->get_customer(1,$value['branch_to_id']);
					$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt'))->get_where('dms_wholesale_items',array('group_id' => $value['group_id'],'vat' => $vat,'status' => 1))->row_array();
					$amount = round_this($result['amount']);
					$vat_amt = round_this($result['vat_amt']);
					if($vat != 0){
						$voucher_array[$value['group_id']] = array('bill_no' => $value['bill_no'],'bill_date' => $value['bill_date'],'customer'=>$customer,'payment_mode' => $value['payment_mode'],'ledger_name' => $value['ledger_name'],'vtype' => 'Sales','amount' => $amount,'vat_amt' => $vat_amt);
					}
				}
			}
		}
		return $voucher_array;
	}

	public function generate_purchase_evat($from_date,$to_date,$get_amount=NULL)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		delete_files('assets/evats/purchase/');
		$i = 0;
		$total_purchase_amount = 0;
		#-------------get company branches
		$branches = $this->getBranches();
		$data = '';
		#-------------purchase
		$row = $this->CI->db->select(array('vtype_id','bill_no','bill_date','invoice_no','	invoice_date','group_id','vendor_id','payment_mode'))->from("dms_purchases")->where_in('branch_id',$branches)->where(array('status' => 1))->where("bill_date between '$from_date' and '$to_date'",NULL,false)->order_by('bill_date','asc')->get()->result_array();
		if($row)
		{
			foreach($row as $key => $value)
			{
				
				$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt','sum(discount_amt) as discount'))->get_where('dms_purchase_items',array('group_id' => $value['group_id'],'status' => 1))->row_array();#sum(discount_amt)
				$discount = round_this($result['discount']);
				$amount = round_this($result['amount']);
				$vat_amt = round_this($result['vat_amt']);
				
				$total_purchase_amount += $amount;
				if($this->CI->dms->branch_type())
				{
					$user_details = $this->CI->db->select(array('ledger_name','address','tin_no'))->from('dms_ledgers as a')->join('item_manufacturer_master as b','a.id = b.ledger_id')->where(array('b.id' => $value['vendor_id']))->get()->row_array();
				}
				else
				{
					$user_details = $this->CI->db->select(array('(branch_address) as address','tin_no','ledger_name'))->from('comapny_master as a')->join('branch_master as b','a.id = b.company_id')->join('dms_ledgers as c','b.ledger_id = c.id')->where(array('b.id' => $value['vendor_id']))->get()->row_array();
				}

				if($vat != 0){
					$i++;
					$total_amount = ($amount) + $vat;#$discount
					$bill_prefix = $this->CI->stock->get_voucher_prefix($value['vtype_id']);
					if(!empty($user_details['address'])){
						$user_address = $user_details['address'];
					}else{
						$user_address = 'X';
					}
					if($i == 1)
					{
						$data .= $i."|".$bill_prefix.$value['invoice_no']."|".date('d-m-Y',strtotime($value['invoice_date']))."|".$user_details['tin_no']."|".$user_details['ledger_name']."|".$user_address."|".$amount."|".$vat_amt."|".$total_amount;
					}
					else
					{
						$data .= "\r\n".$i."|".$bill_prefix.$value['invoice_no']."|".date('d-m-Y',strtotime($value['invoice_date']))."|".$user_details['tin_no']."|".$user_details['ledger_name']."|".$user_address."|".$amount."|".$vat_amt."|".$total_amount;
					}
					
				}
			}
			if($get_amount == NULL){
				write_file('assets/evats/purchase/Purchase.txt', $data,'a+');
			}
		}

		#------------purchase_return
		/*$row = $this->CI->db->select(array('bill_no','bill_date','group_id','vendor_id','payment_mode'))->from("dms_purchase_returns")->where(array('branch_id' => $this->CI->session->userdata('under_id'),'status' => 1))->where("bill_date between '$from_date' and '$to_date'",NULL,false)->get()->result_array();
		if($row)
		{
			foreach($row as $key => $value)
			{
				$result = $this->CI->db->select(array('sum(amount) as amount','sum(vat_amt) as vat_amt'))->get_where('dms_purchase_return_items',array('group_id' => $value['group_id'],'status' => 1))->row_array();
				$amount = round_this($result['amount']);
				$vat = round_this($result['vat_amt']);

				if($this->CI->dms->branch_type())
				{
					$vendor = $this->CI->db->select('tin_no')->get_where('item_manufacturer_master',array('id' => $value['vendor_id']))->row_array();//tin no
					$ledger = $this->CI->db->select('ledger_name')->from('dms_ledgers as a')->join('item_manufacturer_master as b','a.id = b.ledger_id')->where(array('b.id' => $value['vendor_id']))->get()->row_array();
				}
				else
				{
					$vendor = $this->CI->db->select('tin_no')->get_where('company_master',array('id' => $this->session->userdata('company_id')))->row_array();
					$ledger = $this->CI->db->select('ledger_name')->from('dms_ledgers as a')->join('branch_master as b','a.id = b.ledger_id')->where(array('b.id' => $value['vendor_id']))->get()->row_array();
				}

				if($vat != 0){
					$i++;
					$total_amount = $amount + $vat;
					if($i == 1)
					{
						$data = $i."|".$value['bill_no']."|".$value['bill_date']."|".$vendor['tin_no']."|".$ledger['ledger_name']."|".-$total_amount."|".-$amount."|".-$vat;
					}
					else
					{
						$data = "\r\n".$i."|".$value['bill_no']."|".$value['bill_date']."|".$vendor['tin_no']."|".$ledger['ledger_name']."|".-$total_amount."|".-$amount."|".-$vat;
					}
					write_file('assets/evats/purchase/purchase.txt', $data,'a+');
				}
			}
		}*/
		if(file_exists('assets/evats/purchase/Purchase.txt') && $get_amount == NULL){
			return true;
		} else {
			return $total_purchase_amount;
		}
		return false;
	}

	public function generate_sales_evat($from_date,$to_date,$get_amount=NULL)
	{
	    $from_date = date('Y-m-d',strtotime($from_date));
	    $to_date = date('Y-m-d',strtotime($to_date));
		delete_files('assets/evats/sales/');
		$i = 0;

		$total_sales_amount = 0;
		#-------------get company branches
		$branches = $this->getBranches();

		#-------------sales
		$row = $this->CI->db->select(array('vtype_id','bill_no','bill_date','group_id','customer_type_id','customer_id','payment_mode'))->from("dms_sales")->where_in('branch_id',$branches)->where(array('status' => 1))->where("bill_date between '$from_date' and '$to_date'",NULL,false)->order_by('bill_date','asc')->get()->result_array();
		if($row)
		{
			foreach($row as $key => $value)
			{
				$result = $this->CI->db->select(array('sum(taxable_amt) as amount','sum(vat_amt) as vat_amt','sum(discount_amt) as discount'))->get_where('dms_sales_items',array('group_id' => $value['group_id'],'status' => 1))->row_array();
				#-sum(discount_amt)
				$amount = round_this($result['amount']);
				$vat_amt = round_this($result['vat_amt']);
				
				$total_sales_amount += $amount;
				if($value['customer_type_id'] == 1)//branches
				{
					$user_details = $this->CI->db->select(array('(branch_address) as address','tin_no','ledger_name'))->from('company_master as a')->join('branch_master as b','a.id = b.company_id')->join('dms_ledgers as c','b.ledger_id = c.id')->where(array('b.id' => $value['customer_id']))->get()->row_array();
				}
				elseif($value['customer_type_id'] == 2)//customer
				{
					$user_details = $this->CI->db->select(array('address','ledger_name'))->from('customer_master as a')->join('dms_ledgers as b','a.ledger_id = b.id')->where('a.id',$value['customer_id'])->get()->row_array();
					$user_details['tin_no'] = "99999999999";//tin no
				}
				else//retailer
				{
					$user_details = $this->CI->db->select(array('tin_no','(retailer_address) as address','ledger_name'))->from('retailer_master as a')->join('dms_ledgers as b','a.ledger_id = b.id')->where(array('a.id' => $value['customer_id']))->get()->row_array();
				}

				if($vat != 0){
					$i++;
					$total_amount = ($amount) + $vat;#-$discount
					$bill_prefix = $this->CI->stock->get_voucher_prefix($value['vtype_id']);
					
					if(!empty($user_details['address'])){
						$user_address = $user_details['address'];
					}else{
						$user_address = "X";
					}
					if($i == 1)
					{
						$data = $i."|".$bill_prefix.$value['bill_no']."|".date('d-m-Y',strtotime($value['bill_date']))."|".$user_details['tin_no']."|".$user_details['ledger_name']."|".$user_address."|".$amount."|".$vat_amt."|".$total_amount;
					}
					else
					{
						$data .= "\r\n".$i."|".$bill_prefix.$value['bill_no']."|".date('d-m-Y',strtotime($value['bill_date']))."|".$user_details['tin_no']."|".$user_details['ledger_name']."|".$user_address."|".$amount."|".$vat_amt."|".$total_amount;
					}
					
				}
			}
			if($get_amount == NULL){
				write_file('assets/evats/sales/Sales.txt', $data,'a+');
			}
		}
		if(file_exists('assets/evats/sales/Sales.txt') && $get_amount == NULL){
				return true;//$total_sales_amount;
		}else{
			return $total_sales_amount;
		}
		return false;
	}

	public function getBranches()
	{
		$branches = array();
		$row = $this->CI->db->select('id')->get_where('branch_master',array('company_id' => $this->CI->session->userdata('company_id'),'status' => 1))->result_array();
		if($row){
			foreach($row as $key => $value){
				$branches[] = $value['id'];
			}
		}
		return $branches;
	}
}