<?php 
class To_words{
	
	#---------------------------------------------------
	
	public function num_to_words($no){

		$no_in_words=""; 
		if($no > 0){
			$exp=explode('.',$no);
			if(count($exp) > 1){
				if(strlen($exp[1]) == 1 && $exp[1] != 0){
					$exp[1]*=10;
					$rupees=$this->numberWords($exp[0]);
					$paisa=$this->numberWords($exp[1]);
					if(!empty($rupees) || !empty($paisa)){
						$no_in_words=ucwords("AED ".$rupees." and ".$paisa." FILS only.");
					}
				}elseif($exp[1] == 0){
					$rupees=$this->numberWords($exp[0]);
					if(!empty($rupees)){
						$no_in_words=ucwords("AED ".$rupees." only.");	
					}
				}else{
					$rupees=$this->numberWords($exp[0]);
					$paisa=$this->numberWords($exp[1]);
					if(!empty($rupees) || !empty($paisa)){
						$no_in_words=ucwords("AED ".$rupees." and ".$paisa." FILS only.");
					}
				}
			}else{
				$rupees=$this->numberWords($no);
				if(!empty($rupees)){
					$no_in_words=ucwords("AED ".$rupees." only.");
				}
			}
		}
		return $no_in_words;	
	}
	
	#---------------------------------------------------------------------------
	
	public function numberWords($no){
		try{
			if(strlen($no) >9){
				return NULL;
			}
			$words = array('0'=>'' ,'1'=>'one' ,'2'=>'two' ,'3'=>'three','4' =>'four','5' =>'five','6' => 'six','7' => 'seven','8' => 'eight','9' => 'nine','10' => 'ten','11' => 'eleven','12' => 'twelve','13' => 'thirteen','14' => 'fourteen','15' => 'fifteen','16' => 'sixteen','17' => 'seventeen','18' => 'eighteen','19' => 'nineteen','20' => 'twenty','30' => 'thirty','40' => 'fourty','50' => 'fifty','60' => 'sixty','70' => 'seventy','80' => 'eighty','90' => 'ninety','100' => 'hundred','1000' => 'thousand','100000' => 'lakh','10000000' => 'crore'); 
			if($no == 0){
				return ' ';
			}else{
				$novalue='';$highno=$no;$remainno=0;$value=100;$value1=1000;        
				while($no>=100){
					if(($value <= $no) && ($no  < $value1)){
						$novalue=$words["$value"];
						$highno = (int)($no/$value);
						$remainno = $no % $value;
						break;
					}
					$value= $value1;
					$value1 = $value*100;
				}
				if(array_key_exists("$highno",$words)){
					return $words["$highno"]." ".$novalue." ".$this->numberWords($remainno);
				}else{
					 $unit=$highno%10;
					 $ten =(int)($highno/10)*10;             
					 return $words["$ten"]." ".$words["$unit"]." ".$novalue." ".$this->numberWords($remainno);
				}
			}
		}catch(Exception $e){
		}
	}
	
	#-----------------------------------------------------------------------
	
	public function dob($date){
		
		$day=idate('d',strtotime($date));
		$month_in_words=date('F',strtotime($date));
		$year=date('Y',strtotime($date));
		
		$words_day=array('0'=>'' ,'1'=>'first' ,'2'=>'second' ,'3'=>'third','4' =>'fourth','5' =>'fifth','6' => 'sixth','7' => 'seventh','8' => 'eighth','9' => 'ninth','10' => 'tenth','11' => 'eleventh','12' => 'twelfth','13' => 'thirteenth','14' => 'fourteenth','15' => 'fifteenth','16' => 'sixteenth','17' => 'seventeenth','18' => 'eighteenth','19' => 'nineteenth','20' => 'twenty','30' => 'thirty');
		
		$words_year=array('0'=>'' ,'1'=>'one' ,'2'=>'two' ,'3'=>'three','4' =>'four','5' =>'five','6' => 'six','7' => 'seven','8' => 'eight','9' => 'nine','10' => 'ten','11' => 'eleven','12' => 'twelve','13' => 'thirteen','14' => 'fourteen','15' => 'fifteen','16' => 'sixteen','17' => 'seventeen','18' => 'eighteen','19' => 'nineteen','20' => 'twenty','30' => 'thirty','40' => 'fourty','50' => 'fifty','60' => 'sixty','70' => 'seventy','80' => 'eighty','90' => 'ninety','100' => 'hundred','2000' => 'two thousand'); 
		
		if($day<20){
			$day_in_words=$words_day[$day];
		}elseif($day>=20){
			$day1=floor(($day/10))*10;
			$day2=$day%10;
			if($day2==0){
				$day_in_words=$words_day[$day1]."th";
			}else{
				$day_in_words=$words_day[$day1]." ".$words_day[$day2];
			}
		}
		
		$year1=floor($year/100);
		$year2=$year%100;
		if($year1<20){
			if($year2>20){
				$year3=floor(($year2/10))*10;
				$year4=$year2%10;
				$year_in_words=$words_year[$year1]." ".$words_year[$year3]." ".$words_year[$year4];
			}else{
				$year_in_words=$words_year[$year1]." ".$words_year[$year2];
			}
		}else{
			if($year2>20){
				$year3=floor(($year2/10))*10;
				$year4=$year2%10;
				$year_in_words=$words_year[2000]." ".$words_year[$year3]." ".$words_year[$year4];
			}else{
				$year_in_words=$words_year[2000]." ".$words_year[$year2];
			}
		}
		return $dob_in_words=$day_in_words." ".$month_in_words." ".$year_in_words;
	}

	#----------------------------------------------------------------------
}
?>