<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cess_model extends MY_Model
{
	public function insert($data)
	{
		$this->db->select('id')->from('cess_master')->where(array('company_id' => $data['company_id'],'fiscal_yr_id' => $data['fiscal_yr_id']));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$result=$this->my_update("cess_master",array('cess_percent' => $data['cess_percent']),array('id' => $row['id']));
		}
		else
		{			
			$result=$this->f_save("cess_master",$data);
		}
		return $result;
	}
	
	public function get($args = array())
	{
		if(isset($args['columns'])){
			$columns = $args['columns'];
		}
		else{
			$columns = array('c.id','c.company_id','c.cess_percent','c.fiscal_yr_id');	
		}
		$this->db->select($columns)->from('cess_master as c')->join('fiscal_year_master as f','c.fiscal_yr_id = f.id');				
		$this->db->where('c.company_id',$this->session->userdata('company_id'));
		$this->db->where('c.branch_id',$this->session->userdata('under_id'));
		$this->db->where('c.fiscal_yr_id <= ',$this->session->userdata('fiscal_yr_id'));					
		$this->db->order_by('start_date', 'DESC');
		$this->db->limit(1);
		$result = $this->db->get()->row_array();
		if(!empty($result)){
			return $result;		
		}
		return false;
	}	
}
?>