<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vat_model extends MY_Model
{
	public function get($args = array())
	{
		$args['conditions']['company_id'] = $this->session->userdata('company_id');
		$args['conditions']['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');				
		$this->db->select(array('id','item_type'))->from('item_type_master')->where(array('status'=>1,'company_id'=>$this->session->userdata('company_id')))->order_by('item_type');
		$row = $this->db->get()->result_array();
		foreach($row as $items => $item_details)
		{
			$vat = $this->get_item_vat($item_details['id']);
			$row[$items]['vat'] = $vat;
		}
		return $row;
	}

	public function get_item_vat($item_grp_id)
	{
		$this->db->select('a.vat')->from('tax_master as a')->join('fiscal_year_master as b','a.fiscal_yr_id=b.id')->where(array('a.company_id' => $this->session->userdata('company_id'),'a.item_grp_id' => $item_grp_id,'fiscal_yr_id <= ' => $this->session->userdata('fiscal_yr_id')))->order_by('fiscal_order','DESC')->limit(1);
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			return $row['vat'];
		}
		return false;
	}
    
	public function update($data)
	{
		$data['company_id'] = $this->session->userdata('company_id');
		$data['fiscal_yr_id'] = $this->session->userdata('fiscal_yr_id');
		$this->db->select('id')->from('tax_master')->where(array('company_id' => $data['company_id'],'fiscal_yr_id' => $data['fiscal_yr_id'],'item_grp_id' => $data['item_grp_id']));
		$row = $this->db->get()->row_array();
		if(!empty($row))
		{
			$result=$this->my_update("tax_master",array('vat' => $data['vat']),array('id' => $row['id']));
		}
		else
		{			
			$result=$this->f_save("tax_master",$data);
		}
		return $result;
	}

	public function check_vat($item_group_id,$vat_value)
	{		
		$fiscal_year = $this->dms->get_fiscal_year();
		$fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		
		#-----------dms_stocks
		$this->db->from('dms_stocks as a')->join('item_master as b','a.item_id=b.id')->where(array('b.item_group_id' => $item_group_id,'b.status' => 1,'a.stock_status >' => 0,'a.stock_status <' => 9,'a.status' => 1));
		$this->db->where("stock_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		$count1 = $this->db->count_all_results();
		if(!$count1)
		{				
			#-----------dms_purchase_orders
			$this->db->from('dms_purchase_orders as a')->join('dms_purchase_items as b','a.group_id=b.group_id')->join('item_master as c','b.item_id=c.id')->where(array('a.status' => 1,'b.status !=' => 0,'c.item_group_id' => $item_group_id,'c.status' => 1));
			$this->db->where("a.po_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
			$count2 = $this->db->count_all_results();
			if(!$count2)
			{					
				#-----------dms_quotations
				$this->db->from('dms_quotations as a')->join('dms_quotations_items as b','a.id=b.qt_id')->join('item_master as c','b.item_id=c.id')->where(array('a.status >' => 0,'b.status >' => 0,'c.item_group_id' => $item_group_id,'c.status' => 1));
				$this->db->where("a.qt_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
				return $this->db->count_all_results();
			}
			return true;
		}
		return true;
	}
}