<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Target_model extends MY_Model{



		#purpuse:get financial year starting and ending date
		public function get_fiscal_year($fiscal_year_id){


			//return $user_id;
			$row = $this->db->select(array('start_date','end_date'))->get_where('fiscal_year_master',array('id'=>$fiscal_year_id))->row_array();
			if(!empty($row)){
				if($row['end_date'] == '0000-00-00' || empty($row['end_date'])){
					$row['end_date'] = date('Y-m-d');
				}
				return $row;
			}
			return false;
		}



		#-------------------------------------------

		#date : 17-01-2017
		#purpose : get all targets for an employee
		public function get_all($args=FALSE,$fiscal_year_id=FALSE){

			$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
			$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

			$fiscal_start_date_time = date('Y-m-d',strtotime($fiscal_start_date));
			$fiscal_end_date_time = date('Y-m-d',strtotime($fiscal_end_date));

			$this->db->select(array('itm.item_type','u.symbol','u.formal_name','t.*','m.*'));
			$this->db->from('target_items m');
			$this->db->join('targets t','t.id=m.targets_id');
			$this->db->join('unit_master u','u.id=m.unit_id','left');
			$this->db->join('item_type_master itm','itm.id=m.item_group_id');
			$this->db->where('t.status',1);
			$this->db->where('itm.status',1);

			$where = "((t.valid_from <= '$fiscal_start_date_time' && t.valid_to >= '$fiscal_start_date_time') or (t.valid_from <= '$fiscal_end_date_time' && t.valid_to >= '$fiscal_end_date_time') or (t.valid_from > '$fiscal_start_date_time' && t.valid_to < '$fiscal_end_date_time'))";

			$this->db->where($where,NULL,TRUE);

			$args = func_get_args()[0];
			foreach($args as $key=>$value){
				if($key == 'total'){
					return $this->db->get()->num_rows();
					exit;
				}else if($key == 'limit'){
					$this->db->limit($value,$args['offset']);
				}else if($key != 'offset'){
					$this->db->where($key,$value);
				}
			}

			$this->db->order_by('t.valid_to','DESC');
			return $this->db->get()->result_array();

		}


	#-------------------------------------------

		public function get_count($args=FALSE,$fiscal_year_id=FALSE){

			$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
			$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

			$fiscal_start_date_time = date('Y-m-d',strtotime($fiscal_start_date));
			$fiscal_end_date_time = date('Y-m-d',strtotime($fiscal_end_date));

			$this->db->select(array('itm.item_type','u.symbol','u.formal_name','t.*','m.*'));
			$this->db->from('target_items m');
			$this->db->join('targets t','t.id=m.targets_id');
			$this->db->join('unit_master u','u.id=m.unit_id','left');
			$this->db->join('item_type_master itm','itm.id=m.item_group_id');
			$this->db->where('t.status',1);
			$this->db->where('itm.status',1);
			$this->db->where('t.seen_status',0);


			$where = "((t.valid_from <= '$fiscal_start_date_time' && t.valid_to >= '$fiscal_start_date_time') or (t.valid_from <= '$fiscal_end_date_time' && t.valid_to >= '$fiscal_end_date_time') or (t.valid_from > '$fiscal_start_date_time' && t.valid_to < '$fiscal_end_date_time'))";

			$this->db->where($where,NULL,TRUE);

			$args = func_get_args()[0];
			foreach($args as $key=>$value){
				if($key == 'total'){
					return $this->db->get()->num_rows();
					exit;
				}else if($key == 'limit'){
					$this->db->limit($value,$args['offset']);
				}else if($key != 'offset'){
					$this->db->where($key,$value);
				}
			}


			return $this->db->get()->num_rows();

		}

		#------------------------------------------------------------

		public function get_count_task($user_id){


				$this->db->select(array('id','task_title','task_date','task_file','task_description','task_status','seen_status','completed_on','employee_comments'));
				$this->db->from('employee_tasks');

				$this->db->where('status',1);
				$this->db->where('seen_status',0);
				$this->db->where('employee_id',$user_id);
				return $this->db->get()->num_rows();

		}

		#------------------------------------------------------------
		#date : 28-1-2017
		#purpose : update all targets of a particular user as seen (seen_status => 1)
		public function i_have_seen_my_targets($user_id){
			$this->db->update('targets',array('seen_status'=>1),array('user_id'=>$user_id));
			return true;
		}

		#-------------------------------------------

		#date : 28-1-2017
		#purpose : update all task of a particular user as seen (seen_status => 1)


		public function i_have_seen_my_task($user_id){
			$this->db->update('employee_tasks',array('seen_status'=>1),array('employee_id'=>$user_id));
			return true;
		}

		#-------------------------------------------

		#date : 28-1-2017
		#purpose : update all gift of a particular user as seen (seen_status => 1)


		public function i_have_seen_my_gift($gift_id){
			$this->db->update('dms_user_achievements',array('seen_status'=>1),array('id'=>$gift_id));
			return true;
		}





	#-------------------------------------------
	public function get_sales($args = array())
	{

		$fiscal_year_id = 2;
		$fiscal_start_date = $this->get_fiscal_year($fiscal_year_id)['start_date'];
		$fiscal_end_date = $this->get_fiscal_year($fiscal_year_id)['end_date'];

		if(!isset($args['columns']))
		{
			$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.customer_id','b.item_id','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.godown_id');
		}
		$this->db->select($args['columns'])->from('dms_sales as a')->join('dms_sales_items as b','a.group_id = b.group_id');
		#$this->db->where('a.branch_id',$this->branch_id);
		$this->db->where("a.bill_date between '$fiscal_start_date' and '$fiscal_end_date'",NULL,false);
		if(!array_key_exists('a.branch_id',$args['conditions'])){
			$args['conditions']['a.branch_id']= $this->branch_id;
		}
		if(empty($args['conditions']['a.branch_id'])){
			unset($args['conditions']['a.branch_id']);
		}
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}


	#--------------------------

}