<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Customer_master_model extends MY_Model{

		#----------------------------------------------------------
		public function get_all($args)
		{
			$this->db->select(array('cm.*','bm.branch_name','am.area'));
			$this->db->from('customer_master cm');
			$this->db->where('cm.status',1);
			$this->db->join('branch_master bm','bm.id=cm.branch_id');
			$this->db->join('area_master am','am.id=cm.area_id',"left");
			$this->db->where('bm.status',1);
			$this->db->where('bm.company_id',$this->session->userdata('company_id'));
			
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
            if(isset($args['like']))
		    {
		        $this->db->like($args['like'],true,'');
		    }
			if(isset($args['group_by']))
			{
				$this->db->group_by($args['group_by']);
			}
			if(isset($args['numrows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order-by']))
			{
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'],$args['offset']);
			}
			return $this->db->get()->result_array();
		}
		
		#----------------------------------------------------------	

		public function open_balance($ledger_id)
		{
			$this->db->select(array('ledger.*','ledger.id as dms_ledger_id'));
			$this->db->from('dms_ledgers ledger');
			$this->db->where('ledger.id',$ledger_id);
			$this->db->where('ledger.status',1);
			$ledgers1 = $this->db->get()->row_array();

			$this->db->select(array('open_bals.*','open_bals.id as open_bals_id'));
			$this->db->from('dms_ledger_open_bals open_bals');
			$this->db->where('open_bals.ledger_id',$ledger_id);
			$this->db->where('open_bals.status',1);
			$ledgers = $this->db->get()->row_array();
            $ledgers1 = is_array($ledgers1) ? $ledgers1 : []; // Ensure $ledgers1 is an array
            $ledgers = is_array($ledgers) ? $ledgers : []; // Ensure $ledgers is a
			return array_merge($ledgers1,$ledgers);	
		}

		#-----------------------------------------------------------
		
		public function listing($args=array())
		{
			$customers = array();
			$customersmob = array();
			$this->db->select(array('id','concat(fname," ",lname) as name','mobile_no','phone_no'));
			$this->db->from('customer_master');
			if(!isset($args['conditions']['status !=']))
			{
				$args['conditions']['status'] = 1;
			}
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$customers[$row['id']] = $row['name'];
				}
			}
			return $customers;
		}
		
		#-----------------------------------------------------------demo
		public function listingmob_nos($args=array())
		{
			$customers = array();
			$customersmob = array();
			$this->db->select(array('id','concat(fname," ",lname) as name','mobile_no','phone_no'));
			$this->db->from('customer_master');
			if(!isset($args['conditions']['status !=']))
			{
				$args['conditions']['status'] = 1;
			}
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);
			}
			$rows = $this->db->get()->result_array();
			if(!empty($rows))
			{
				foreach($rows as $key=>$row)
				{
					$customersmob[$row['id']] = $row['mobile_no'];
		        }
			}
			return $customersmob;
		}
		
		#------------------------------------------------------------
		
		public function get($args=array())
		{
			if(!isset($args['select']))
			{
				$args['select'] = array('id','branch_id','ledger_id','fname','lname','address','state','district','area_id','mobile_no','phone_no','email_id','dob');
			}
			$this->db->select($args['select']);
			$this->db->from('customer_master');
			if(isset($args['conditions']))
			{
				$this->db->where($args['conditions']);			
			}
		    if(isset($args['num_rows']))
			{
				return $this->db->count_all_results();
			}
			if(isset($args['order_by']))
			{ 
				if(!isset($args['order'])){$args['order'] = 'asc';}
				$this->db->order_by($args['order_by'],$args['order']);
			}
			if(isset($args['limit']))
			{
				$this->db->limit($args['limit'], $args['offset']);
			}
			return $this->db->get()->result_array();				
		}
	}
?>