<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Daily_task_model extends MY_Model{
		

		#------------------------------------------------------

		function save($data){

			$data['task_date'] = date('Y-m-d',strtotime($data['task_date']));
			return $this->f_save('employee_tasks',$data);
			
		}

		#------------------------------------------------------
		#date:4-09-2014
		#purpose:get all details
		function get_all($args){

			$this->db->select(array('task.*'));
			$this->db->from('(select * from employee_tasks group by task_title) task');
			$this->db->where('task.status',1);

			#$this->db->join('users u','task.employee_id = u.id');

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				return $this->db->get()->result_array();
			}

			return FALSE;
		}
		#------------------------------------------------------
		#date:10-9-2014
		#purpose:get distinct count of task_title
		function get_count_task_title($args){

			$this->db->distinct('task_title');
			$this->db->get('employee_tasks');

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}
		}
		#------------------------------------------------------
		#date:20-9-2014
		#purpose:get my tasks
		function get_all_my_task($args){

			$this->db->select(array('task.*'));
			$this->db->from(' employee_tasks task');
			$this->db->where('task.status',1);

			#$this->db->join('users u','task.employee_id = u.id');

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				return $this->db->get()->result_array();
			}

			return FALSE;
		}
		#------------------------------------------------------
		#date : 26-09-2014
		#purpose : update all tasks of a particular user as seen (seen_status => 1)
		public function i_have_seen_my_tasks($user_id){
			$this->db->update('employee_tasks',array('seen_status'=>1),array('employee_id'=>$user_id));
			return true;
		}
		#------------------------------------------------------
		#date:29-09-2014
		#purpose :Listing task titles
		public function  title_listing($conditions){
			$conditions['status'] = 1;
			$this->db->select('id,task_title');
			$this->db->from('employee_tasks');
			$this->db->where($conditions);
			$rows = $this->db->get()->result_array();

			if(empty($rows)){
				return false;
			}

			$tasks = array();
			foreach ($rows as $row) {
				$tasks[$row['task_title']] = $row['task_title'];
			}
			return $tasks;
		}
		#------------------------------------------------------
	}

?>