<?php
class Constant_master_model extends MY_Model{
	
	var $fiscal_year_id,$company_id;
	#---------------------------------------
	
	public function __construct(){
		
		$this->fiscal_year_id = $this->session->userdata('fiscal_yr_id');
		$this->company_id = $this->session->userdata('company_id');
	}
	
	#---------------------------------------
	
	public function update($data,$conditions){
		if($this->my_update('constant_master',$data,$conditions)){
			return true;
		}
		return false;		
	}
	
	#---------------------------------------	
	
	public function save_stock_value_type($stock_value_type){

		$stock_values = $this->get_stock_value_type();
		
		if(!empty($stock_values)){
			
			$upID = $stock_values['id'];
			$prev_fiscal = $stock_values['fiscal_yr_id'];
			$prev_value_type = $stock_values['value_type'];
			
			if($stock_value_type != $prev_value_type){

				if($this->fiscal_year_id != $prev_fiscal ){
					#if(empty($this->get_stock_value_type(array('company_id'=>$this->company_id,'fiscal_yr_id'=>$this->fiscal_year_id)))){
						$this->f_save("dms_stock_value_types",array('company_id'=>$this->company_id,'fiscal_yr_id'=>$this->fiscal_year_id,'value_type'=>$stock_value_type));
					#}
				}else{
					$this->my_update('dms_stock_value_types',array('value_type'=>$stock_value_type),array('id'=>$upID));
				}

			}

		}else{
			$this->f_save("dms_stock_value_types",array('company_id'=>$this->company_id,'fiscal_yr_id'=>$this->fiscal_year_id,'value_type'=>$stock_value_type));

		}
		return true;
	}
	
	#--------------------------------------
	
	public function get_stock_value_type($conditions = array()){
		
		$stckValues = array();
		if(empty($conditions)){
			$conditions = array('company_id'=>$this->company_id,'fiscal_yr_id <='=>$this->fiscal_year_id);
		}
		$this->db->select('dms_stock_value_types.*');
		$this->db->from('dms_stock_value_types');
		#$this->db->join('fiscal_year_master','fym');
		$this->db->where($conditions);
		$this->db->order_by('fiscal_yr_id','desc');
		$this->db->limit(1);
		
		$stckValues = $this->db->get()->row_array();

		return $stckValues;
	}
	
	#--------------------------------------
	
	public function get_transactions(){
		
		return $this->db->select('id')->get_where('dms_stocks',array('company_id'=>$this->company_id,'stock_status !='=>0,'status !='=>0))->num_rows();
	}
	
	#-------------------------------------
}
?>