<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Product_rate_model extends MY_Model{


	  #--------------------------------------------------------
		public function get_all($args){

			$this->db->select(array('i_rate.*','im.item_code','im.item_name','im.item_manufacturer_id','imm.manufacturer_name'));
			$this->db->from('dms_item_rates i_rate');
			$this->db->where('i_rate.status',1);
			$this->db->where('i_rate.company_id',$this->session->userdata('company_id'));
			$this->db->join('item_master im','im.id=i_rate.item_id');
			$this->db->join('item_manufacturer_master imm','imm.id = im.item_manufacturer_id');
			$this->db->where('im.status',1);

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
	  #--------------------------------------------------------
	  
	  public function get_item_rate($itemID){

		$this->db->select('rate');
		$this->db->from('dms_item_rates as');
		$this->db->where(array('company_id' => $this->session->userdata('company_id'),'item_id' => $itemID,'status'=>1));
		
		$row = $this->db->get()->row_array();

		if(!empty($row)){
			return $row['rate'];
		}
		return false;
		
	  }
	  
	  #---------------------------------------------------------
	}

?>