<?php
class Stock_count_model extends MY_Model{
	
	public function __construct(){
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
	}
	
	public function save($data)
	{
	    $this->db->insert('stock_lmsb',$data);
	}

    public function update($args = array())
	{
		if($this->db->update($args['table'],$args['data'],$args['conditions']))
		{
			return true;
		}
		return false;
	}
	
	public function newsave($data)
	{
	    $this->db->insert('stock_count_new',$data);
	}
	
	public function savenew($data)
	{
		$this->db->insert('dms_stocks',$data);
	}

	public function itemsave($data)
	{
		$this->db->insert('dms_item_rates',$data);
	}

	public function get_all($args)
	{
        $this->db->select(array('cm.*','bm.branch_name','am.item_name','am.item_code','am.model_no'));
        $this->db->from('stock_lmsb cm');
		$this->db->join('branch_master bm','bm.id=cm.branch_id');
		$this->db->join('item_master am','am.id=cm.item_id',"left");
		$this->db->where('bm.status',1);
		$this->db->where('cm.status',1);
		$this->db->where('bm.company_id',$this->session->userdata('company_id'));
		$this->db->where('cm.branch_id',$this->session->userdata('under_id'));
		
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
        
        if(isset($args['like']))
		{
		    $this->db->like($args['like'],true,'');
		}

		if(isset($args['group_by']))
		{
			$this->db->group_by($args['group_by']);
		}

		if(isset($args['numrows']))
		{
			return $this->db->count_all_results();
		}

		if(isset($args['order-by']))
		{
			$this->db->order_by($args['order_by'],$args['order']);
		}
		else
		{
		    $this->db->order_by('cm.id','ASC');
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'],$args['offset']);
		}
		
		return $this->db->get()->result_array();
	}
	
	public function get_allstock1($args)
	{
        $this->db->select(array('sm.*','cm.quantity,cm.item_id'));
        $this->db->from('stock_count_new sm');
        $this->db->join('stock_lmsb cm','cm.group_id=sm.group_id');
        $this->db->where('sm.branch_id',$this->session->userdata('under_id'));
		
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
        
        if(isset($args['like']))
		{
		    $this->db->like($args['like'],true,'');
		}

		if(isset($args['group_by']))
		{
			$this->db->group_by($args['group_by']);
		}

		if(isset($args['numrows']))
		{
			return $this->db->count_all_results();
		}

		if(isset($args['order-by']))
		{
			$this->db->order_by($args['order_by'],$args['order']);
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'],$args['offset']);
		}
		
		return $this->db->get()->result_array();
	}
		
	public function get_allstock($args)
	{
        $this->db->select(array('cm.*','am.item_id','am.quantity','bm.item_code','bm.item_name'));
			$this->db->from('stock_count_new cm');
			$this->db->where('cm.status',1);
			$this->db->join('stock_lmsb am','cm.group_id=am.group_id');
	        $this->db->join('item_master bm','bm.id=am.item_id',"left");
			$this->db->where('cm.branch_id',$this->session->userdata('under_id'));
			//$this->db->query("select cm.month,bm.item_id,bm.quantity from stock_count_new as cm inner join stock_lmsb as bm on cm.group_id=bm.group_id where bm.branch_id='$branch_id'");
		
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
                        if(isset($args['like']))
		        {
		            
			        $this->db->like($args['like'],true,'');
		        }

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		
		
		#-------------------------------------------------------------------
		public function get_allstock22($args){

			$this->db->select(array('cm.*','am.item_name,am.item_code'));
			$this->db->from('stock_lmsb cm');
			$this->db->join('stock_lmsb bm','bm.group_id=cm.group_id');
			$this->db->join('item_master am','am.id=cm.item_id',"left");
			$this->db->where('cm.branch_id',$this->branchID);
			//$this->db->where('cm.status',1);
			

			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
                        if(isset($args['like']))
		        {
		             //$this->db->like($args['like'],false,'before');
			        $this->db->like($args['like'],true,'');
		        }

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		
		
		
		#------------------------------------------------------------
		
		public function get_all_mnth($args){

			$this->db->select(array('cm.*'));
			$this->db->from('stock_count_new cm');
			$this->db->where('cm.branch_id',$this->branchID);
			$this->db->where('cm.status',1);
			//$this->db->join('branch_master bm','bm.id=$this->branchID');
			//$this->db->join('stock_lmsb bm','bm.group_id=cm.group_id');
			//$this->db->where('cm.status',1);
		/*	$this->db->join('branch_master bm','bm.id=cm.branch_id');
			$this->db->join('item_master am','am.id=cm.item_id',"left");*/
		//	$this->db->where('cm.status',1);
		//	$this->db->where('bm.company_id',$this->session->userdata('company_id'));
			#$this->db->where('am.status',1);

			//$this->db->join('vehicle_master vehicle','insurance.vehicle_id = vehicle.id');
			if(isset($args['conditions'])){
				$this->db->where($args['conditions']);
			}
                        if(isset($args['like']))
		        {
		             //$this->db->like($args['like'],false,'before');
			        $this->db->like($args['like'],true,'');
		        }

			if(isset($args['group_by'])){
				$this->db->group_by($args['group_by']);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order-by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			return $this->db->get()->result_array();
		}
		
		
		
		#------------------------------------------------------------
		
		public function getnew($args=array()){
		
		if(!isset($args['select'])){
			$args['select'] = array('itm.id','itm.company_id','itm.godown_id','itm.item_id','itm.qty','itm.unit_id','itm.rate','itm.amount');
		}
		
		$this->db->select($args['select']);
		$this->db->from('stock_lmsb itm');
		$this->db->join('stock_count_new mnth','mnth.group_id=itm.group_id');

		if(isset($args['conditions'])){
			
			$this->db->where($args['conditions']);			
		}
		
		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->count_all_results();
		}
		#-- for order by
		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
			
		}
		#--for limit 
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}			
		return $this->db->get()->result_array();		
		
	}
	
	
	#-------------------------------------------------------------------------------------------------
	
	public function get($args = array())

	{

		if(!isset($args['columns']))

		{

			$args['select'] = array('a.id','a.company_id','a.godown_id','a.item_id','a.quantity','a.unit_id','a.rate','a.amount');

			//$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.s_type','a.ref_no','a.customer_id','b.item_id','b.hsn','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.godown_id');

		}

		$this->db->select($args['columns'])->from('stock_lmsb as a')->join('stock_count_new as b','a.group_id = b.group_id');

		#$this->db->where('a.branch_id',$this->branch_id);

		//$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);

		if(!array_key_exists('a.branch_id',$args['conditions'])){

			$args['conditions']['a.branch_id']= $this->branch_id;

		}

		if(empty($args['conditions']['a.branch_id'])){

			unset($args['conditions']['a.branch_id']);

		}

		if(isset($args['conditions']))

		{

			$this->db->where($args['conditions']);

		}

		if(isset($args['numrows']))

		{

			return $this->db->get()->num_rows();

		}

		if(isset($args['order_by']))

		{

			$this->db->order_by($args['order_by'], $args['order']);

		}

		if(isset($args['limit']))

		{

			$this->db->limit($args['limit'], $args['offset']);

		}

		return $this->db->get()->row_array();

	}

	
	#-------------------------------------------------------------------------------------------------
	
	
		
}