<?php
class Stock_upload_model extends MY_Model{
	
	public function __construct(){
	    
	    #-----------fiscal year dates
		$this->fiscal_start_date = $this->dms->get_fiscal_year()['start_date'];
		$this->fiscal_end_date = $this->dms->get_fiscal_year()['end_date'];
		$this->branchID = $this->session->userdata('under_id');
		$this->companyID = $this->session->userdata('company_id');	
	}
	public function save($data){
	    
		$this->db->insert('stock_lmsb',$data);
		
	}
	
	
public function update($args = array())
	{
		
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}
	
	public function newsave($data){
	    
		$this->db->insert('stock_count_new',$data);
		
	}
	
	
	public function savedata($data){
	    
		$this->db->insert('dms_item_rates',$data);
		
	}
	
	
	#------------------------------------------------------------------------------------------------
	


	    public function get_item_id($item_code,$item_name,$item_type,$godown)
		{
			$row = $this->db->select('id')->get_where('item_master',array('item_code' => $item_code,'item_name'=>$item_name,'status' => 1))->row_array();
			if(!empty($row))
			{
				return $row['id'];
			}
			else
			{
			    $new_item_details = array();
                $new_item_details['company_id'] = $this->companyID;
                $new_item_details['item_code'] = $item_code;
                $new_item_details['item_name'] = $item_name;
                $new_item_details['item_types'] = $item_type;
                
                $new_it = $this->db->select(array('id','group_id'))->from('item_types')->where('name',$item_type)->get()->row_array();                                
                $new_item_details['item_group_id'] = $new_it['group_id'];
                $new_item_details['item_manufacturer_id'] = 5;
                
                $tp=$new_item_details['item_types'];
                $cd=$new_item_details['item_code'];
                if($tp=='contact' || $tp=='solution')
        		{
        			$new_item_details['code_id'] = substr($cd,2);
        		}
        		else
        		{
        	        $new_item_details['code_id'] = substr($cd,1);
        		}
                	
                //$new_item_details['unit_id'] = '';
                $new_item_details['hsn'] = '';
                $new_item_details['stock_type'] = 1;
                $new_item_details['status'] = 1;
                
                $new_item_id = $this->db->insert("item_master",$new_item_details); echo "<br>".$new_item_id;
                if($new_item_id)
                {
                    $new_stock = array();
                    $new_stock['company_id'] = $this->companyID;
                    $new_stock['branch_id'] = $this->branch_id;
                    $new_stock['godown_id'] = $godown;
                    $new_stock['item_id'] = $new_item_id;
                    $new_stock['qty'] = 0;
                    //$new_stock['unit_id'] = '';
                    $new_stock['rate'] = 0;
                    $new_stock['stock_date'] = $this->fiscal_start_date;
                    $new_stock['status'] = 1;
                    $this->db->insert("dms_stocks",$new_stock);
                        
                    return $new_item_id;
                }
			}
		}
	
	
	#--------------------------------------------------------------------	
	
	
	
	public function get($args = array())

	{

		if(!isset($args['columns']))

		{

			$args['select'] = array('a.id','a.company_id','a.godown_id','a.item_id','a.qty','a.unit_id','a.rate','a.amount');

			//$args['columns'] = array('a.id','a.vtype_id','a.bill_no','a.bill_date','a.s_type','a.ref_no','a.customer_id','b.item_id','b.hsn','b.qty','b.unit_id','b.rate','b.amount','b.discount_amt','b.godown_id');

		}

		$this->db->select($args['columns'])->from('stock_lmsb as a')->join('stock_count_new as b','a.group_id = b.group_id');

		#$this->db->where('a.branch_id',$this->branch_id);

		//$this->db->where("a.bill_date between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);

		if(!array_key_exists('a.branch_id',$args['conditions'])){

			$args['conditions']['a.branch_id']= $this->branch_id;

		}

		if(empty($args['conditions']['a.branch_id'])){

			unset($args['conditions']['a.branch_id']);

		}

		if(isset($args['conditions']))

		{

			$this->db->where($args['conditions']);

		}

		if(isset($args['numrows']))

		{

			return $this->db->get()->num_rows();

		}

		if(isset($args['order_by']))

		{

			$this->db->order_by($args['order_by'], $args['order']);

		}

		if(isset($args['limit']))

		{

			$this->db->limit($args['limit'], $args['offset']);

		}

		return $this->db->get()->result_array();

	}

	
	
	
	#------------------------------------------------------------------------------------------------
	}	