<?php 
	
class Unit_model extends MY_Model{


	#----------------------------------------

	#date : 18-6-2014
	#purpose : listing all the units
	public function listing($conditions = NULL){
		 if (!is_array($conditions)) {
        $conditions = array(); // Initialize as an empty array if not
    }
		$company_id = $this->session->userdata('company_id');
		$conditions['company_id'] = $company_id;
		$conditions['status'] = 1;
		$conditions['unit_type'] = 0;
		$rows = $this->db->select(array('id','symbol'))->order_by('unit_type','DESC')->get_where('unit_master',$conditions)->result_array();
			//echo $this->db->last_query();die;
		$units = array(''=>'Select A Unit');
		foreach($rows as $row){ $units[$row['id']] = $row['symbol']; }
		return $units;
	}

	#----------------------------------------

	#date : 20-6-2014
	#purpose : save unit master
	public function save($data){

		if($data['unit_type'] == 1)
		{
			$first_unit_name = $this->unit_symbol($data['first_unit']);
			$second_unit_name = $this->unit_symbol($data['second_unit']);
			$data['formal_name'] = $data['symbol'] = $first_unit_name.' of '.$data['conversion'].' '.$second_unit_name.'s';
		}
		$data['created_by'] = $this->session->userdata('id');
		$data['company_id'] = $this->session->userdata('company_id');
		$this->f_save('unit_master',$data);
		return true;			
	}


	#-------------------------------------------

	#date : 20-6-2014
	#purpose : get unit symbol
	public function unit_symbol($id){

		$row = $this->db->select('symbol')->get_where('unit_master',array('id'=>$id))->row_array();

		if(!empty($row)){ return $row['symbol']; }
		else{ return false; }
	}

	#--------------------------------------------

	#date : 20-6-2014
	#purpose : get unit details of an indvidual unit
	public function get_data($conditions = NULL){

		$conditions['company_id'] = $this->session->userdata('company_id');
		$conditions['status'] = 1;
		$rows = $this->db->order_by('unit_type','DESC')->get_where('unit_master',$conditions)->result_array();
		
		if(!empty($rows))
			return $rows;
		else
			return false;	
		
	}

	#--------------------------------------------

	#date : 02-07-2014
	#purpose : get unit IDs by passing name array
	public function get_unit_ids($unit_names){

		$rows = $this->db->select('id')->from('unit_master')->where_in('symbol',$unit_names)->get()->result_array();
		$units = array();
		foreach($rows as $row){ $units[] = $row['id']; }	
		return $units;
	}

	#--------------------------------------------
		
	#date : 16-8-2014
	#purpose : recursive function to get the conversion rate
	function get_conversion_unit_to_primary($current_unit,$per_unit,$conversion = 1){
		
		 #print_r(func_get_args());   
		
		 $this->db->select(array('second_unit','conversion'));
		 $this->db->from('unit_master');
		 $this->db->where('id',$current_unit);
		 $row = $this->db->get()->row_array();
		 
		 
		 if($row['second_unit'] == $per_unit){
			$conversion = $row['conversion'] * $conversion;
			return $conversion;
		 }else{
			$this->get_conversion_unit_to_primary($row['second_unit'],$per_unit,$conversion);
		 }           
		
	}
	
	#----------------------------------------------
	#date:10-07-2014
	#purpose:get alternate ids with names
	public function alternate_units($unit_id){

		$this->db->select(array('first_unit'));
		$this->db->from('unit_master');
		//$this->db->join('unit_master un','iu.unit_id = un.id');
		$this->db->where(array('second_unit'=>$unit_id,'unit_type'=>'1','company_id'=>$this->session->userdata('company_id')));
		$rows = $this->db->get()->result_array();

		$units = array();
		if(!empty($rows)){
			foreach ($rows as $row) {
				#geetting second unit id
				$unit_id = $row['first_unit'];

				$this->db->select(array('symbol'));
				$this->db->from('unit_master');
				//$this->db->join('unit_master un','iu.unit_id = un.id');
				$this->db->where(array('id'=>$unit_id,'unit_type'=>'0','company_id'=>$this->session->userdata('company_id')));
				$rows1 = $this->db->get()->row_array();
				if(!empty($rows1)){
					$units[$unit_id] = $rows1['symbol'];
				}
			}
		}
		else{
			$units['-1'] = 'No Alternate unit found';
		}
		
		return $units;

	}
	#--------------------------------------------
	
	#--------------------------------------------
	#date:16-12-2014
	#purpose:check compund unit exists or not
	public function get_compound_data($unit1,$unit2 = NULL,$unit_id=NULL)
	{
		$this->db->select('id')->from('unit_master');	
		if(!empty($unit_id)){
			$this->db->where('id !=',$unit_id);
		}					
		if(!empty($unit2))
		{
			$this->db->where("status = 1 and (first_unit = $unit1 and second_unit = $unit2) or (first_unit = $unit2 and second_unit = $unit1)");			
		}
		else
		{
			$this->db->where("status = 1 and unit_type = 1 and (first_unit = $unit1 or second_unit = $unit1)");
		}
		if($this->db->count_all_results() > 0)
		{
			return true;
		}
		return false;
	}
	
	#--------------------------------------------
	#date:16-12-2014
	#purpose:updation
	public function update($args = array())
	{
		if($this->my_update("unit_master",$args['data'],$args['conditions']))
		{
			return true;
		}			
		return false;
	}
	
	#--------------------------------------------------------
	public function item_count($unit_id)
	{		
		$row = $this->db->where(array('unit_id' => $unit_id,'status' => 1))->count_all_results('item_master');
		if($row == 0)
		{
			return $this->db->where(array('alt_unit_id' => $unit_id,'status' => 1))->count_all_results('item_master');
		}
		return $row;
	}
}