<?php

class Purchase_order_temp_model extends MY_Model{
	
	#--------------------------------------------------------------------------------------
	public function __construct(){
		
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');
		$this->createdBY = $this->session->userdata('id');
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
	}
	
	#--------------------------------------------------------------------------------------	
	
	public function get_purchase_order_number(){
		
		$this->db->select(array('max(po_no) as bill_no'));
		$this->db->from('dms_purchase_order_temp');
		$this->db->where(array('branch_id'=>$this->branchID));
		$this->db->where("po_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row1 = $this->db->get()->row_array();
		$billNum1=0;$billNum2=0;
		if(!empty($row1)){$billNum1 = $row1['bill_no'];}	
		
		$this->db->select(array('max(po_no) as bill_no'));
		$this->db->from('dms_purchase_orders');
		$this->db->where(array('branch_id'=>$this->branchID,'status'=>1));
		$this->db->where("po_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row2 = $this->db->get()->row_array();
		if(!empty($row2)){$billNum2 = $row2['bill_no'];}	
		$newBill = 1;
		if($billNum1 > $billNum2){
			$newBill = $newBill+$billNum1;
		}else{
			$newBill = $newBill+$billNum2;
		}
		return $newBill;			
	}
	
	#--------------------------------------------------------------------------------------	
	
	public function save_order($data){
		
		
		if($this->f_save("dms_purchase_order_temp",$data)){
			return true;
		}
		return false;
		
	}		
	
	#---------------------------------------------------------------------------------------
		
	public function save_order_item($data){
		
		if($this->f_save("dms_purchase_order_temp_items",$data)){
			return true;
		}
		return false;
				
	}

        public function save_order_items($data){
			
		if($this->f_save("dms_purchase_order_temp_items1",$data)){
			return true;
		}
		return false;
				
	}
	
	#---------------------------------------------------------------------------------------
	
	public function get($args){
		
		if(!isset($args['select'])){
			$args['select'] = array('dpot.id','dpot.branch_id','dpot.po_no','dpot.po_date','dpot.vendor_id');
		}
		$this->db->select($args['select']);
		$this->db->from('dms_purchase_order_temp as dpot');
		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		$this->db->where("dpot.po_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$args['conditions']['branch_id'] = $this->branchID;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}
		
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		if(isset($args['order_by'])){ 
			if(!isset($args['order'])){$args['order'] = 'asc';}
			$this->db->order_by($args['order_by'],$args['order']);
		}

		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		#$this->db->get();echo $this->db->last_query();die;
		return $this->db->get()->result_array();		
	}
		
	
	#============================================
	
	public function po_number_check($po_no){
		
		$this->db->select(array('id'));
		$this->db->from('dms_purchase_order_temp');
		$this->db->where(array('po_no'=>$po_no,'branch_id'=>$this->branchID,'created_by !='=>$this->createdBY));
		$this->db->where("po_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row1 = $this->db->get()->num_rows();

		$this->db->select(array('id'));
		$this->db->from('dms_purchase_orders');
		$this->db->where(array('po_no'=>$po_no,'branch_id'=>$this->branchID,'status'=>1));
		$this->db->where("po_date between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,true);
		$row2 = $this->db->get()->num_rows();

		if(empty($row1) && empty($row2)){
			return true;
		}		
		return false;
		
	}
	
	#============================================
	
	public function delete($tempItemID){
		
		$this->db->select(array('dpot_id'));
		$this->db->from('dms_purchase_order_temp_items');
		$this->db->where(array('id'=>$tempItemID));
		
		$rows = $this->db->get()->row_array();
		$po_temp_id = $rows['dpot_id'];
		
		$this->db->from('dms_purchase_order_temp_items');
		$this->db->where(array('dpot_id'=>$po_temp_id));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_purchase_order_temp',array('id'=>$po_temp_id));
		}
		
		if($this->db->delete('dms_purchase_order_temp_items',array('id'=>$tempItemID))){
			return true;
		}
	}

        public function deletes($tempItemID){
		
		$this->db->select(array('dpot_id'));
		$this->db->from('dms_purchase_order_temp_items1');
		$this->db->where(array('id'=>$tempItemID));
		
		$rows = $this->db->get()->row_array();
		$po_temp_id = $rows['dpot_id'];
		
		$this->db->from('dms_purchase_order_temp_items1');
		$this->db->where(array('dpot_id'=>$po_temp_id));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->db->delete('dms_purchase_order_temp',array('id'=>$po_temp_id));
		}
		
		if($this->db->delete('dms_purchase_order_temp_items1',array('id'=>$tempItemID))){
			return true;
		}
	}
	
	#============================================
		
}

?>