<?php
class Salary_settings_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

		#-----------fiscal year dates
		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];		
		$this->fiscal_end_date = $fiscals['end_date'];
		$this->branch_id = $this->session->userdata('under_id');
		$this->company_id = $this->session->userdata('company_id');
	}

	#__________________________________________________________

	public function save($table,$data)
	{
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}

	#__________________________________________________________

	public function get_salary_percentage($args){

		if(!isset($args['select'])){
			$args['select'] = array();
		}
		$this->db->select($args['select']);
		$this->db->from('dms_salary_percentages as dsp');

		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows---------------------
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		#-- for order by------------------------------------------
		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			if(!is_array($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				foreach($args['order_by'] as $order_field=>$order){
					$this->db->order_by($order_field,$order);
				}
			}
		}


		#--for limit ----------------------------------------------
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();
	}
	
	#__________________________________________________________

	public function list_salary_percentage(){
		
		$salary_percentages = array();
		$this->db->select(array('id','name'));
		$this->db->from('dms_salary_percentages as dsp');
		$this->db->where(array('company_id'=>$this->company_id));
		$rows = $this->db->get()->result_array();	

		foreach($rows as $key => $salary_percentage )	{

			$salary_percentages[$salary_percentage['id']] = $salary_percentage['name'];
		}
		return $salary_percentages; 
	}
	
	#__________________________________________________________
}
?>