<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class Sale_report_model extends Sales_model{

		
		#date: 08-10-2014
		#purpose : get AR wise sales report
		function ar_approved_sales($ar,$from,$to,$pagination){

			$from = date('Y-m-d',strtotime($from));
			$to = date('Y-m-d',strtotime($to));

			#get employee ids for this AR
			$emp_ids = $this->dms->ar_employee_ids($ar);

			$this->db->select(array('s.*','UCASE(CONCAT(u.fname," ",u.lname)) name','i.item_name','rs.item_quantity','unit.symbol','rs.net_amount'));
			$this->db->from('sales s');
			$this->db->join('users u','s.user_id=u.id');
			$this->db->join('requested_stocks rs','s.id=rs.request_id');
			$this->db->join('item_master i','i.id=rs.item_id');
			$this->db->join('unit_master unit','unit.id=rs.item_unit');
			$this->db->where_in('u.id',$emp_ids);
			$this->db->where('final_status',1);
			$this->db->where('DATE(s.created_on) >=',$from);
			$this->db->where('DATE(s.created_on) <=',$to);

			if(array_key_exists('total',$pagination)){
				return $this->db->count_all_results();
			}

			if(array_key_exists('offset',$pagination)){
				$this->db->limit($pagination['limit'],$pagination['offset']);
			}

			#$this->db->get();
			#echo $this->db->last_query();
			return $this->db->get()->result_array();
		}


		#-------------------------------------------------------------------------------------
		#date : 09-10-2014
		#purpose : get Branch approved sales
		function branch_approved_sales($branch,$from,$to,$pagination){

			$from = date('Y-m-d',strtotime($from));
			$to = date('Y-m-d',strtotime($to));

			#get employee ids for this AR
			$emp_ids = $this->dms->branch_employee_ids($branch);

			$this->db->select(array('s.*','UCASE(CONCAT(u.fname," ",u.lname)) name','i.item_name','rs.item_quantity','unit.symbol','rs.net_amount'));
			$this->db->from('sales s');
			$this->db->join('users u','s.user_id=u.id');
			$this->db->join('requested_stocks rs','s.id=rs.request_id');
			$this->db->join('item_master i','i.id=rs.item_id');
			$this->db->join('unit_master unit','unit.id=rs.item_unit');
			$this->db->where_in('u.id',$emp_ids);
			$this->db->where('final_status',1);
			$this->db->where('DATE(s.created_on) >=',$from);
			$this->db->where('DATE(s.created_on) <=',$to);

			if(array_key_exists('total',$pagination)){
				return $this->db->count_all_results();
			}

			if(array_key_exists('offset',$pagination)){
				$this->db->limit($pagination['limit'],$pagination['offset']);
			}

			#$this->db->get();
			#echo $this->db->last_query();
			return $this->db->get()->result_array();
		}

	}

?>