<?php
class Sales_order_model extends MY_Model{

	#------------------------------------------------------------------------------------

	public function __construct(){

		$fiscals = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscals['start_date'];
		$this->fiscal_end_date = $fiscals['end_date'];
		$this->companyID = $this->session->userdata('company_id');
		$this->branchID = $this->session->userdata('under_id');

	}

	#------------------------------------------------------------------------------------

	public function save_sales_order_items($data){

		if($this->f_save("dms_sales_items",$data)){
			return true;
		}
		return false;

	}

       public function save_sales_order_itemss($data){

		if($this->f_save("dms_sales_items1",$data)){
			return true;
		}
		return false;

	}




	#------------------------------------------------------------------------------------

	public function get_sales_order($args){

		if(!isset($args['select'])){
			$args['select'] = array('dso.branch_id','dso.so_no','dso.so_date','dso.group_id','dso.customer_type_id','dso.customer_id','dso.user_id','dso.area_id','dso.remarks','dso.so_status','dso.so_discount_per','dso.so_discount_amt','dso.cess');
		}
		$this->db->select($args['select']);
		$this->db->from('dms_sales_orders as dso');

		if(isset($args['join'])){
			foreach($args['join'] as $table=>$on){
				$this->db->join($table,$on,'left');
			}
		}
		if(!isset($args['conditions']['dso.id'])){
			if(isset($args['between'])){
				$from_date = $args['between']['from_date'];
				$to_date = $args['between']['to_date'];
			}else{
				$from_date = $this->fiscal_start_date;
				$to_date = $this->fiscal_end_date;
			}
			$this->db->where("dso.so_date between '".$from_date."' and '".$to_date."'",NULL,true);
		}
		$args['conditions']['dso.status'] = 1;
		$args['conditions']['dso.branch_id'] = $this->branchID;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows---------------------
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		#-- for order by------------------------------------------
		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			if(!is_array($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				foreach($args['order_by'] as $order_field=>$order){
					$this->db->order_by($order_field,$order);
				}
			}
		}else{
			$this->db->order_by('dso.so_date','desc');
		}

		#--for limit ----------------------------------------------
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();
	}

	#------------------------------------------------------------------------------------

	public function get_sales_order_items($args=array()){

		if(!isset($args['select'])){
			$args['select'] = array('dsi.*','im.item_code','im.item_name','um.formal_name','um.symbol');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sales_items as dsi');
		$this->db->join('item_master as im','dsi.item_id=im.id');
		$this->db->join('unit_master as um','dsi.unit_id=um.id');

		$args['conditions']['dsi.status'] = 1;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		#-- for order by
		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			if(!is_array($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				foreach($args['order_by'] as $order_field=>$order){
					$this->db->order_by($order_field,$order);
				}
			}
		}

		#--for limit
		if(isset($args['limit'])){
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();

	}

        public function get_sales_order_itemss($args=array()){

		if(!isset($args['select'])){
			$args['select'] = array('dsi.*','im.item_code','im.item_name','um.formal_name','um.symbol');
		}

		$this->db->select($args['select']);
		$this->db->from('dms_sales_items1 as dsi');
		$this->db->join('item_master as im','dsi.item_id=im.id');
		$this->db->join('unit_master as um','dsi.unit_id=um.id');

		$args['conditions']['dsi.status'] = 1;
		if(isset($args['conditions'])){
			$this->db->where($args['conditions']);
		}

		#-- returns total number of rows
		if(isset($args['num_rows'])){
			return $this->db->get()->num_rows();
		}

		#-- for order by
		if(isset($args['order_by'])){
			if(!isset($args['order'])){$args['order'] = 'asc';}
			if(!is_array($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}else{
				foreach($args['order_by'] as $order_field=>$order){
					$this->db->order_by($order_field,$order);
				}
			}
		}

		#--for limit
		if(isset($args['limit'])){
			$this->db->limit($args['limit'], $args['offset']);
		}

		return $this->db->get()->result_array();

	}



	#------------------------------------------------------------------------------------

	public function delete_so_item($soItmID){

		$this->db->select(array('group_id'));
		$this->db->from('dms_sales_items');
		$this->db->where(array('id'=>$soItmID));
		$rows = $this->db->get()->row_array();
		$so_groupID = $rows['group_id'];
		$this->db->from('dms_sales_items');
		$this->db->where(array('group_id'=>$so_groupID,'status'=>1));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->my_update('dms_sales_orders',array('status'=>0),array('group_id'=>$so_groupID));
		}

		if($this->my_update('dms_sales_items',array('status'=>0),array('id'=>$soItmID))){
			return true;
		}
		return true;

	}


public function delete_so_items($soItmID){

		$this->db->select(array('group_id'));
		$this->db->from('dms_sales_items1');
		$this->db->where(array('id'=>$soItmID));
		$rows = $this->db->get()->row_array();
		$so_groupID = $rows['group_id'];
		$this->db->from('dms_sales_items1');
		$this->db->where(array('group_id'=>$so_groupID,'status'=>1));
		$totalBillItems = $this->db->count_all_results();

		if($totalBillItems == 1){
			$this->my_update('dms_sales_orders',array('status'=>0),array('group_id'=>$so_groupID));
		}

		if($this->my_update('dms_sales_items1',array('status'=>0),array('id'=>$soItmID))){
			return true;
		}
		return true;

	}














	#-------------------------------------------------------------------------------------

	public function update_so_item($data,$conditions){
		if($this->my_update('dms_sales_items',$data,$conditions)){
			return true;
		}
		return false;
	}


public function update_so_items($data,$conditions){
		if($this->my_update('dms_sales_items1',$data,$conditions)){
			return true;
		}
		return false;
	}




	#-------------------------------------------------------------------------------------

	public function update_so($data,$conditions){
		if($this->my_update('dms_sales_orders',$data,$conditions)){
			return true;
		}
		return false;
	}

	#--------------------------------------------------------------------------------------

	public function get_so_status($soID){

		$args = array();
		$args['select'] = array('dso.group_id','dso.branch_id','dso.so_date');
		$args['conditions'] = array('dso.id'=>$soID);
		$so_details = $this->get_sales_order($args);

		if(!empty($so_details)){

			$deliveryNotes = $sales = array();
			$so_group_id = $so_details[0]['group_id'];
			$so_date = $so_details[0]['so_date'];

			#---check delivery note------
			$this->db->select(array('id','sid'));
			$this->db->from('dms_delivery_notes');
			$this->db->where(array('group_id'=>$so_group_id,'status !='=>0));
			$deliveryNotes = $this->db->get()->row_array();

			#---check sales bill-----------

			$this->db->select(array('id','sid'));
			$this->db->from('dms_sales');
			$this->db->where(array('group_id'=>$so_group_id,'status !='=>0));
			$sales = $this->db->get()->row_array();
			if(!empty($deliveryNotes) || !empty($sales)){
				return false;
			}else{
				return true;
			}
		}
	}
	#---------------------------------------------------------------------------------------
}
?>