<?php 
	
	class Request_model extends MY_Model{



		#---------------------------------------------

		public function save($main_req){

			
			#user
			$main_req['user_id'] = $main_req['created_by'] = $this->session->userdata('id');

			#date formats
			$main_req['date_of_delivery'] = date('Y-m-d',strtotime($main_req['date_of_delivery']));
			$main_req['expected_date_of_payment'] = date('Y-m-d',strtotime($main_req['expected_date_of_payment']));


			$req_id = $this->save_a('sales',$main_req);

			return $req_id;
		}

		#---------------------------------------------

		#date : 10-7-2014
		#purpose : save requested items in tbl - requested_stocks
		public function save_items($request_id,$items){

			$items['request_id'] = $request_id;
			$this->db->insert('requested_stocks',$items);
			return true;
		}

		#-------------------------------------------------


		#date : 25-7-2014
		#purpose : save mason data if added with request
		public function save_mason($data){
			$data['user_type'] = 'mason';
			$data['company_id'] = $this->session->userdata('company_id');
			$data['under_type'] = $this->session->userdata('under_type');
			$data['under_id'] = $this->session->userdata('under_id');
			$mason_id = $this->save_a('users',$data);
			return $mason_id;
		}

		#--------------------------------------------------

		#date : 25-7-2014
		#purpose : get stock requests based on conditions
		public function get_all($args = NULL){

			$args = func_get_args()[0];
			#print_r($args);

			$this->db->select(array('s.*','i.item_name','rs.id rs_id','rs.item_quantity','rs.status','u.symbol','user.fname','user.lname'));
			$this->db->from('sales s');
			$this->db->where('s.status',1);
			$this->db->join('requested_stocks rs','rs.request_id=s.id');
			$this->db->join('item_master i','rs.item_id=i.id');
			$this->db->join('unit_master u','rs.item_id=u.id');
			$this->db->join('users user','user.id=s.user_id');
			$this->db->where('rs.status',1);

			#echo '<pre>';print_r($args);

			if($args != NULL){
				foreach($args as $key=>$value){
					if($key == 'total'){ return $this->db->get()->num_rows(); }
					else if($key == 'order_by'){ $this->db->order_by($value,$args['order']);}
					else if($key == 'limit'){ $this->db->limit($value,$args['offset']); }
					else if(!in_array($key,array('offset','order','order_by'))){ $this->db->where($key,$value); }

				}
			}
			

			$rows = $this->db->get()->result_array();//echo $this->db->last_query();//
			 return $rows;
		}

		#--------------------------------------------------

		#date : 12-8-2014
		#purpose : get request basic details(without item details)
		public function get_basic_details($request){
			$this->db->select(array('s.*','u.fname','u.lname','l.ledger_name','m.fname mfname','m.lname mlname'));
			$this->db->from('sales s');
			$this->db->join('users u','s.user_id=u.id');
			$this->db->join('ledger_master l','s.payment_mode=l.id');
			$this->db->join('users m','s.mason_id=m.id','left');
			$this->db->where('s.id',$request);
			return $this->db->get()->row_array();
		}

		#--------------------------------------------------
		#date : 12-8-2014
		#purpose : get requested items
		public function get_items_for_rqst($request){
			$this->db->select(array('r.*','i.item_name','i.HSN_code','u.symbol','i.opening_rate','v.vat_rate'));
			$this->db->from('requested_stocks r');
			$this->db->join('item_master i','r.item_id=i.id'); #item name
			$this->db->join('unit_master u','r.item_unit=u.id'); #unit symbol
			$this->db->join('item_vats v','r.item_id=v.item_id'); #VAT rate
			//$this->db->where('v.valid_to','0000-00-00'); #last VAT rate only
			$this->db->where('r.request_id',$request);
			$this->db->where('r.status',1);
			return $this->db->get()->result_array();
		}

		#--------------------------------------------------

		#date : 18-8-2014
		#purpose : update stock request basic details - such as customer name, delivery date etc.
		function update_request_basic($id,$updations){
			$updations['date_of_delivery'] = date('Y-m-d',strtotime($updations['date_of_delivery']));
			$updations['expected_date_of_payment'] = date('Y-m-d',strtotime($updations['expected_date_of_payment']));
			return $this->update_a(array('table'=>'sales','conditions'=>array('id'=>$id),'data'=>$updations));
		}

		#--------------------------------------------------

		#date : 18-8-2014
		#purpose : approve requested items
		function approve_items($id,$items){
			$items['req_status'] = 'added_to_cart';
			return $this->update_requested_items($id,$items);

		}

		#---------------------------------------------------

		#date : 21-8-2014
		#purpose : add items(of an order) to cart
		function add_items_to_cart($args){

			$args['data']['req_status'] = 'added_to_cart';
			$args['data']['cart_id'] = $args['cart_id'];
			return $this->update_requested_items($args['id'],$args['data']);
		}

		#----------------------------------------------------

		#date : 18-8-2014
		#purpose : update stock requested items
		function update_requested_items($id,$updations){

			$updations['updated_by'] = $this->session->userdata('id');
			return $this->db->update('requested_stocks',$updations,array('id'=>$id));
		}

		#--------------------------------------------------

		#date : 26-7-2014
		#purpose : find out how many items are there for a request
		public function get_items($args = NULL){

			$this->db->select()->from('requested_stocks rs');
			$this->db->where('status',1);
			if($args != NULL){
				foreach($args as $key=>$value){
					if($key == 'total'){ return $this->db->get()->num_rows(); }
					else if($key == 'order_by'){ $this->db->order_by($value,$args['order']);}
					else if($key == 'limit'){ $this->db->limit($value,$args['offset']); }
					else if(!in_array($key,array('offset','order','order_by'))){ $this->db->where($key,$value); }

				}
			}

			return $this->db->get()->result_array();
		}


		#---------------------------------------------------
		public function get_request_list(){

			$rows = $this->db->select(array('id','request_ID'))->order_by('id')->get_where('sales')->result_array();
			//echo $this->db->last_query();die;
			$requests = array();
			foreach ($rows as $row){
				$requests[$row['id']] = $row['request_ID'];
			}

			return $requests;
		}
		#---------------------------------------------------

		#date : 21-8-2014
		#purpose : update basic request data as 'added-to-cart'
		function add_to_cart($args){

			$args['data']['added_to_cart'] = 'yes';
			$args['data']['final_status'] = 1; #approved

			#deal with the dates
			$args['data']['date_of_delivery'] = date('Y-m-d',strtotime($args['data']['date_of_delivery']));
			$args['data']['expected_date_of_payment'] = date('Y-m-d',strtotime($args['data']['expected_date_of_payment']));

			return $this->update_request_basic($args['id'],$args['data']);

		}

		#----------------------------------------------------

		#date : 21-8-2014
		#purpose : reject order - update basic details -sales table
		function reject_order($args){

			$total_items = $this->total_ordered_items($args['order_id']);
			if($total_items == $args['checked_items']){
				$args['data']['final_status'] = 2; #rejected
				$args['data']['added_to_cart'] = 'no';
			}

			#deal with the dates
			$args['data']['date_of_delivery'] = date('Y-m-d',strtotime($args['data']['date_of_delivery']));
			$args['data']['expected_date_of_payment'] = date('Y-m-d',strtotime($args['data']['expected_date_of_payment']));

			return $this->update_request_basic($args['id'],$args['data']);
		}

		#-----------------------------------------------------

		#date : 21-8-2014
		#purpose : reject selected items
		function reject_items($args){

			$args['data']['req_status'] = 'rejected';
			$args['data']['cart_id'] = 0; # no cart
			return $this->update_requested_items($args['id'],$args['data']);
		}


		#-----------------------------------------------------

		#date : 21-8-2014
		#purpose : get total number of items with an order/request
		function total_ordered_items($order_id){

			return $this->db->from('sales')->where('request_id',$order_id)->count_all_results();
		}

		#-----------------------------------------------------

		#date : 22-8-2014
		#purpose : get requested_stocks by id
		function get_req_item_by_id($id){
			
			$this->db->select(array('rs.*','i.item_name','u.symbol'));
			$this->db->from('requested_stocks rs');
			$this->db->join('item_master i','i.id=rs.item_id');
			$this->db->join('unit_master u','u.id=rs.item_unit');
			$this->db->where('rs.id',$id);
			return $this->db->get()->row_array();
		}

		#--------------------------------------------------------


	}

?>