<?php 
	
	class Engineer_model extends MY_Model{



		#---------------------------------------------

		#date : 17-6-2014
		#purpose : list masons
		public function listing($conditions = NULL){

			$default = $this->dms->get_default();
			$conditions['fiscal_yr_1 <='] = $default['start_date'];
			$conditions['fiscal_yr_2 <='] = $default['end_date'];
			$conditions['user_type'] = 'mason';

			$rows = $this->db->select(array('id','fname','lname'))->get_where('users',$conditions)->result_array();
			$masons = array();

			foreach($rows as $row){ $masons[$row['id']] = $row['fname'].' '.$row['lname'];}

			return $masons;

		}

		#---------------------------------------------
			public function save_area($engineer_id,$area){
			$num = $this->db->get_where('engineer_areas',array('engineer_id'=>$engineer_id,'area_name'=>$area))->num_rows();
			if($num==0){
				$this->db->insert('engineer_areas',array('engineer_id'=>$engineer_id,'area_name'=>$area,'created_by'=>$this->session->userdata('id')));
			}
		}
		#---------------------------------------------
			public function get_all($conditions=NULL,$total=0,$limit=0,$offset=0){

				$this->db->select(array('users.*','desg.designation_name','desg.id  as designation_id'));
				$this->db->from('users');
				$this->db->join('designation_master desg','users.designation_id=desg.id');
				$this->db->where('users.status',1);
				$this->db->where('users.designation_id',6);
				$this->db->where('users.company_id',$this->session->userdata('company_id'));
				$this->db->where('desg.status',1);

				if($conditions){
					foreach($conditions as $key=>$value){
						$this->db->where($key,$value);
					}
				}	

				#apply offset
				if($offset != 0)
					$this->db->limit($offset,$limit);

				if($total != 0){
					return $this->db->get()->num_rows();
				}

				$masons = $this->db->get()->result_array();

				#echo $this->db->last_query();

				return $masons;
			}
		#---------------------------------------------

		#date : 21-6-2014
		#purpose : get area names of a mason
		public function list_engineer_areas($engineer_id){

			$rows = $this->db->get_where('engineer_areas',array('engineer_id'=>$engineer_id,'status'=>1))->result_array();

			$areas = array();
			foreach($rows as $row){ $areas[$row['id']] = $row['area_name']; }
			return $areas;
		}	

		#------------------------------------------------
		public function area_update($p_areas,$engineer_id){
			
			#posted area string to array
			$posted_areas = explode(',',$p_areas);
			//print_r($posted_areas);

			#get exiisting areas#
			$exist_areas = $this->list_engineer_areas($engineer_id);

			#delere removed areas
			foreach($exist_areas as $ea){
				//echo $ea.'<hr/>';
				
				if(!in_array($ea,$posted_areas)){
					//remove ea
					$this->db->update('engineer_areas',array('status'=>0),array('engineer_id'=>$engineer_id,'area_name'=>$ea)); 
				}
			}


			#add new areas
			foreach ($posted_areas as $pa) {
				
				if(!in_array($pa,$exist_areas)){
					$this->db->insert('engineer_areas',array('engineer_id'=>$engineer_id,'area_name'=>$pa,'created_by'=>$this->session->userdata('id')));
				}
			}

			return true;
		}
		#------------------------------------------------
		public function save($data){
			$this->f_save('users',$data);
			return true;
		}
		#------------------------------------------------
		public function save_company($data){
			$data['created_by'] = $this->session->userdata('id');
			$data['created_on'] = date('Y-m-d H:i:s');
			$this->f_save('engineer_companies',$data);
			return true;
		}
		#------------------------------------------------
		public function update_company($data,$engineer_id){
			$data['created_by'] = $this->session->userdata('id');
			$data['created_on'] = date('Y-m-d H:i:s');
			$this->db->update('engineer_companies',$data,array('engineer_id'=>$engineer_id));
			return true;
		}
		#------------------------------------------------

		public function list_it(){
		
			$this->db->select('u.*');
			$this->db->from('users u');
			$this->db->where('u.user_type','engineer');
			$this->db->where('us.company_id',$this->session->userdata('company_id'));
			
			$users = $this->db->get()->result_array();

			if(empty($users)){
				return false;
			}

			$data = array();
			foreach($users as $user){
				$data[$user['id']] = ucwords($user['fname']).' '.ucwords($user['lname']);
			}

			return $data;
		}

		
		#------------------------------------------------
	}

?>