<?php 

	class Site_visit_model extends MY_Model{


		#date : 23-8-2014
		function save($data){

			$data['date_of_visit'] = date('Y-m-d',strtotime($data['date_of_visit']));
			if(!$this->is_exists(array('fs_id'=>$data['fs_id'],'site_id'=>$data['site_id'],'date_of_visit'=>$data['date_of_visit']))){
				return $this->f_save('fs_site_visits',$data);
			}
			return FALSE;
		}


		#----------------------------------
		#date : 23-8-2014
		function is_exists($data){
			$row = $this->db->get_where('fs_site_visits',$data)->row_array();
			if(empty($row)){ 
				return FALSE;
			}
			return TRUE;

		}

		#--------------------------------------

		#date : 25-8-2014
		#purpose : get all site visit data
		function get_all($args){

			$this->db->select(array('sv.*','a.area','u.fname','u.lname','asb.fname afname','asb.lname alname'));
			$this->db->from('fs_site_visits sv');
			$this->db->join('area_master a','sv.site_id=a.id');
			$this->db->join('users u','u.id=sv.fs_id');
			$this->db->join('users asb','asb.id=sv.created_by');

			$this->db->where($args['conditions']);
			$this->db->where('u.status',1);
			$this->db->where('sv.status',1);

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
				
			}
			
			return $this->db->get()->result_array();
			#return FALSE;
		}

		#---------------------------------------

		#date : 25-8-2014
		#purpose : get all data with filters
		function filter_data($args){

			#$args = array_filter($args['search']);


			#from is set
			if(isset($args['search']['from']) && $args['search']['from'] != ''){
				$conditions['date_of_visit >='] = date('Y-m-d',strtotime($args['search']['from']));
				if(isset($args['search']['to']) && $args['search']['to'] == ''){
					$conditions['date_of_visit'] = date('Y-m-d',strtotime($args['search']['from']));					
				}
			}

			#to is set
			if(isset($args['search']['to']) && $args['search']['to'] != ''){
				$conditions['date_of_visit <='] = date('Y-m-d',strtotime($args['search']['to']));
				if(isset($args['search']['from']) && $args['search']['from'] == ''){
					$conditions['date_of_visit'] = date('Y-m-d',strtotime($args['search']['to']));					
				}
			}

			#from and to are same dates
			if(isset($args['search']['from']) && isset($args['search']['to'])){
				if($args['search']['from'] == $args['search']['to']){
					$conditions['date_of_visit'] = date('Y-m-d',strtotime($args['search']['from']));					
				}
			}

			#fs
			if(isset($args['search']['fs_id']) && $args['search']['fs_id'] != ''){
				$conditions['fs_id'] = $args['search']['fs_id'];
			}

			#site search
			if(isset($args['search']['site_id']) && $args['search']['site_id'] != ''){
				$conditions['site_id'] = $args['search']['site_id'];
			}


			if(isset($args['numrows'])){
				return $this->get_all(array('conditions'=>$conditions,'numrows'=>TRUE));
			}
			if(isset($args['limit'])){
				return  $this->get_all(array('conditions'=>$conditions,'limit'=>$args['limit'],'offset'=>$args['offset']));

			}
			#echo '<pre>'; print_r($args);
			//return  $this->get_all(array('conditions'=>$conditions,'limit'=>$args['limit'],'offset'=>$args['offset']));
			#echo '<pre>'; print_r($row);die;
			return  $this->get_all(array('conditions'=>$conditions));

		}

		#------------------------------------------

		#date : 25-8-2014
		#purpose : update data
		function update($args){

			$args['table'] = 'fs_site_visits';
			$args['data']['date_of_visit'] = date('Y-m-d',strtotime($args['data']['date_of_visit']));
			return $this->update_a($args);
		}

		#------------------------------------------

	}

?>