<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	
	class User_model extends MY_Model{


	#--------------------------------------------------
		
		public function isLoggedin(){

			$user_id = $this->session->userdata('id');
			if(!$user_id){
				return false;
			}
			$rows = $this->db->select('online_status')->get_where('users',array('id'=>$user_id))->row_array();
			if(!empty($rows) && !empty($rows['online_status'])){
				return true;
			}
			return false;
		}	

	#--------------------------------------------------

		public function login($username,$password){

			#get password from table
			$this->db->select(array('id','password','designation_id','company_id','branch_id','fiscal_yr_id'));
			$this->db->from('users');
			$this->db->where('username',$username);
			$this->db->where('status',1);
			$this->db->order_by('id','DESC');
			$this->db->limit(1,0);
			$user = $this->db->get()->row_array();
			
			#echo $this->db->last_query();die;

			if($user){

				#verify the password
				$loggedIn = password_verify($password,$user['password']);
				#echo $password.'<br/>'.$user['password'];

				if($loggedIn){

					#login authenticated
					return $user;

				}else{

					#invalid password
					return false;
				}

			}else{
				#no such username
				if(empty($user)){
					$this->db->select(array('id','status'));
					$this->db->from('users');
					$this->db->where('username',$username);
					$this->db->order_by('id','DESC');
					$this->db->limit(1,0);
					$user = $this->db->get()->row_array();	
					if(!empty($user)){
						if($user['status'] == -1){
							return array('Your account has been blocked. Please contact administrator !');
						}
					}
				}
				return false;
			}

		}

	#---------------------------------------------------

		public function get_fname_lname($uid){

			$this->db->select(array('fname','lname'));
			$this->db->from('users');
			$this->db->where('id',$uid);
			$row = $this->db->get()->row_array();

			return $row['fname'].' '.$row['lname'];
		}

	#---------------------------------------------------
	


		public function get_user_privileges($user_id,$parent_id=0,$id=NULL){
						
			$this->db->cache_on();
			$this->db->select('menu_master.*');
			$this->db->from('menu_master');
			if($this->session->userdata('user_desig') != -1){
				$this->db->join('user_privileges','menu_master.id=user_privileges.menu_id');
				$this->db->where('user_privileges.owner_id',$user_id);	
				$this->db->where('user_group','individual');	
			}
			if($id != NULL){
				$this->db->where('menu_master.id',$id);
			}	
			$this->db->where('menu_master.menu_parent',$parent_id);
			$this->db->where('menu_master.menu_status',1);
			$this->db->where_in('menu_master.menu_type',array('dashboard','dashboard-actions'));
			$this->db->where('menu_group !=','settings');
			$this->db->order_by('menu_order','ASC');
			$query = $this->db->get();
			$this->db->cache_off();
			$menus = $query->result();
			return $menus;
		}

	#----------------------------------------------------	
		public function get_action_privileges($user_id,$menus){

			$this->db->select('menu_master.*');
			$this->db->from('menu_master');
			if($this->session->userdata('user_desig') != -1){
				$this->db->join('user_privileges','menu_master.id=user_privileges.menu_id');
				$this->db->where('user_privileges.owner_id',$user_id);
				$this->db->where('user_group','individual');
			}
			$this->db->where('menu_master.menu_status',1);
			$this->db->where('menu_master.menu_type','actions');
			if(!empty($menus)){
				$this->db->where_in('menu_master.id',$menus);
			}
			$this->db->order_by('menu_order','ASC');	
			$menus = $this->db->get()->result_array();
			return $menus;
		}

	#----------------------------------------------------	

		public function list_it(){

			
			$this->db->select('u.*');
			$this->db->from('users u');
			$this->db->where('company_id',$this->session->userdata('company_id'));
			//$this->db->where('u.user_type','employee');
			$users = $this->db->get()->result_array();

			if(empty($users)){
				return false;
			}
			
			$data = array();
			foreach($users as $user){
				$data[$user['id']] = ucwords($user['fname']).' '.ucwords($user['lname']);
			}
			
			return $data;
		}

	#----------------------------------------------------	

		public function list_users($user_id){

			
			$this->db->select('u.*');
			$this->db->from('users u');
			$this->db->where('id',$user_id);
			//$this->db->where('u.user_type','employee');
			$users = $this->db->get()->result_array();

			if(empty($users)){
				return false;
			}
			
			$data = array();
			foreach($users as $user){
				$data[$user['id']] = ucwords($user['fname']).' '.ucwords($user['lname']);
			}
			
			return $data;
		}

	#------------------------------------------------------



		public function does_user_have_rights($controller,$action){

			if($action == ''){
				$action = 'index';
			}
			
			$this->db->select('mm.id');
			$this->db->from('menu_master mm');
			$this->db->join('user_privileges mp','mm.id=mp.menu_id','left');
			$this->db->where('mm.menu_controller',$controller);
			$this->db->where('mm.menu_action',$action);
			$this->db->where('menu_status',1);
			
			if($this->session->userdata('user_desig') != -1){
				$this->db->where('mp.owner_id',$this->session->userdata('id'));
				$this->db->where('mp.user_group','individual');
			}

			$total = $this->db->get()->num_rows();
			//echo $this->db->last_query();die;

			if($total > 0){				
				return true;
			}else{
				return false;
			}
		}

	#------------------------------------------------------	
		
		public function listing($conditions = NULL){
		
			$conditions['status'] = 1;
			$rows = $this->db->select(array('id','fname','lname'))->get_where('users',$conditions)->result_array();
			
			$driver = array();
			foreach($rows as $row){
				//$driver[$row['id']] = $row['fname'].'&nbsp;'.$row['lname'];
				$driver[$row['id']] = $row['fname'].' '.$row['lname'];
			}
			#echo $this->db->last_query();
			//$this->db->order_by('designation_id');
			return $driver;
		
		}

	#------------------------------------------------------	

		public function save($data){

			$data['company_id'] = $this->session->userdata('company_id');
			$data['dob'] = ($data['dob'] != '')?date('Y-m-d',strtotime($data['dob'])):'';
			$data['date_of_marriage'] = ($data['date_of_marriage'] != '')?date('Y-m-d',strtotime($data['date_of_marriage'])):'';
			$data['date_of_join'] = date('Y-m-d',strtotime($data['date_of_join']));
			if($data['password'] != ''){
				$data['password'] = password_hash($data['password'],PASSWORD_DEFAULT);
			}
			//echo '<pre>';print_r($data);die;
			$this->db->trans_start();
			$result = $this->save_a('users',$data);
			$this->db->trans_complete();
			if($result){
				return $result;
			}
			return false;
		}


	#-----------------------------------------------------	

		public function save_salary($user_id,$salary){

				$row = $this->db->get_where('employee_salaries',array('user_id'=>$user_id,'valid_to'=>'0000-00-00'))->row_array();

				if(!empty($row)){
					$this->db->update('employee_salaries',array('valid_to'=>date('y-m-d'),array('id'=>$row['id'])));	
				}

				$this->db->insert('employee_salaries',array('user_id'=>$user_id,'salary'=>$salary,'valid_from'=>date('Y-m-d'),'created_by'=>$this->session->userdata('id')));
		}

	#-------------------------------------------------------	

		public function get_all($conditions=NULL,$total=0,$limit =0,$offset = 0){

			$conditions['users.status'] = 1;
			if($this->dms->get_main_branch($this->session->userdata('under_id')) === false){
				$conditions['users.branch_id'] = $this->session->userdata('under_id');
			}									
			$this->db->select(array('users.*','desg.designation_name','bm.branch_name','bm.branch_short_name'));
			$this->db->from('users');
			$this->db->join('designation_master desg','users.designation_id=desg.id');
			$this->db->join('branch_master bm','users.branch_id=bm.id');
			$this->db->where('users.company_id',$this->session->userdata('company_id'));
			

						
			if($this->session->userdata('id') > 0){
				$conditions['desg.id >'] = 0;
				$conditions['desg.department_id >'] = 0;
			}
			elseif($this->session->userdata('id') < 0){

				$this->db->where("(users.designation_id > 6 or users.designation_id = -2 or users.designation_id = -1)");
			}

			$this->db->where($conditions);			

			#apply offset
			if($offset != 0)
				$this->db->limit($offset,$limit);

			if($total != 0){
				return $this->db->get()->num_rows();
			}

			$emps = $this->db->get()->result_array();					

			//echo $this->db->last_query();die;

			return $emps;

		}
	#-------------------------------------------------------
		public function list_user_branches($user_id){
			$rows = $this->db->get_where('user_branches',array('user_id'=>$user_id))->result_array();

			$branches= array();
			foreach($rows as $row){ $branches[$row['id']] = $row['branch_id']; }
			return $branches;
		}
	#-------------------------------------------------------
		public function update_branch($p_branches,$user_id){

			#posted branches
			$posted_branches = $p_branches;
		

			#get exiisting branches#
			$exist_branches = $this->list_user_branches($user_id);
		

			#delete removed branches
			foreach($exist_branches as $eb){
				
				
				if(!in_array($eb,$posted_branches)){
					//remove ea
					$this->db->delete('user_branches',array('user_id'=>$user_id,'branch_id'=>$eb)); 
				}
			}


			#add new branches
			foreach ($posted_branches as $pb) {
				
				if(!in_array($pb,$exist_branches)){
					$this->db->insert('user_branches',array('user_id'=>$user_id,'branch_id'=>$pb,'status'=>1,'created_by'=>$this->session->userdata('id')));
				}
			}

			return true;

		}
	 	
	 #-------------------------------------------------------
	 	public function get_users_details($conditions=NULL,$total=0,$limit =0,$offset = 0){
		
		   if($conditions['designation_id'] !=3){

		 		//print_r($conditions);
		  
		    	$conditions['users.status']= -1;
				$this->db->select(array('users.*','desg.designation_name','br.branch_name'));
				$this->db->from('users');
				$this->db->join('designation_master desg','users.designation_id=desg.id');
				$this->db->join('branch_master br','users.branch_id=br.id');
				
				//$this->db->join('branch_master br','users.branch_id=br.id');
			
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
				#apply offset
				if($offset != 0)
					$this->db->limit($offset,$limit);

				if($total != 0){
					return $this->db->get()->num_rows();
				}
			 	$rows = $this->db->get()->result_array();//die;
				return $rows;
			}
			
		
			#get details of retailers
			else if($conditions['designation_id'] == 3){
				
		    	$conditions['users.status']= -1;
				$this->db->select(array('users.id','users.fname','users.lname','ret.retailer_name','desg.designation_name','ret.retailer_short_name','ret.tin_no','ret.retailer_landline','ret.retailer_mobile'));
				$this->db->from('users');
				$this->db->join('designation_master desg','users.designation_id=desg.id');
				$this->db->join('retailer_master ret','users.branch_id=ret.id');
				
			
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
				#apply offset
				if($offset != 0)
					$this->db->limit($offset,$limit);

				if($total != 0){
					return $this->db->get()->num_rows();
				}
				$rows = $this->db->get()->result_array();
				return $rows;	
			
			}
		
		}	
	#-------------------------------------------------------
		#date : 12-08-2014
		#purpose :unblock users
	 	public function unblock($users){
			foreach($users as $key=>$user_id){

			$row = $this->db->select('username')->get_where('users',array('id'=>$user_id))->row_array();	

			#delete rows from login_attempts
			$this->db->delete('login_attempts',array('username'=>$row['username']));

			//print $user_id;
			$data['status'] = 1;
			$result=$this->db->update('users',$data,array('id'=>$user_id));
			}
			return $result;
		}

	#--------------------------------------------------------
		#date: 13-08-2014
		#purpose : for getting unblocked users details
		public function get_unblock_users_details($conditions=NULL,$total=0,$limit =0,$offset = 0){

			//print_r($conditions);
			//echo '44234234';die;
			#get details of employees in branch		
		 	if($conditions['designation_id'] !=3){
		 		//echo 'sss';
		 		//print_r($conditions);die;
		  
		    	$conditions['users.status']=1;
				$this->db->select(array('users.*','desg.designation_name','br.branch_name'));
				$this->db->from('users');
				$this->db->join('designation_master desg','users.designation_id=desg.id');
				$this->db->join('branch_master br','users.branch_id=br.id');
				
				//$this->db->join('branch_master br','users.branch_id=br.id');
			
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
				#apply offset
				if($offset != 0)
					$this->db->limit($offset,$limit);

				if($total != 0){
					return $this->db->get()->num_rows();
				}
			 	$rows = $this->db->get()->result_array();//die;
				return $rows;
			}
			
		
			#get details of retailers
			else if($conditions['designation_id'] == 3){
				
		    	$conditions['users.status']=1;
				$this->db->select(array('users.id','users.fname','users.lname','ret.retailer_name','desg.designation_name','ret.retailer_short_name','ret.tin_no','ret.retailer_landline','ret.retailer_mobile'));
				$this->db->from('users');
				$this->db->join('designation_master desg','users.designation_id=desg.id');
				$this->db->join('retailer_master ret','users.branch_id=ret.id');
				
			
				foreach($conditions as $key=>$value){
					$this->db->where($key,$value);
				}
				#apply offset
				if($offset != 0)
					$this->db->limit($offset,$limit);

				if($total != 0){
					return $this->db->get()->num_rows();
				}
				$rows = $this->db->get()->result_array();
				return $rows;	
			
			}
			/*else{
				echo 'aaaa';die;
			}*/
		
		}
	 
	#--------------------------------------------------------	
		#date : 13-08-2014
		#purpose :block users
	 	public function block($users){
			foreach($users as $key=>$user_id){
			//print $user_id;
			$data['status'] = -1;
			$data['online_status'] = 0;
			$result=$this->db->update('users',$data,array('id'=>$user_id));
			}
			return $result;
		}

	#--------------------------------------------------------


		#date : 27-8-2014
		function list_user_types(){
			return array('emp'=>'Employee','mason'=>'Mason');
		}

	#--------------------------------------------------------	

		#date : 28-8-2014
		function get_all_users($args){

			$this->db->select(array('u.*','d.designation_name'));
			$this->db->from('users u');
			$this->db->join('designation_master d','d.id=u.designation_id');

			if(isset($args['conditions'])){ $this->db->where($args['conditions']);}
			if(isset($args['numrows'])){ return $this->db->count_all_results(); }
			if(isset($args['order_by'])){ $this->db->order_by($args['order_by'],$args['order']);}
			if(isset($args['limit'])){ $this->db->limit($args['limit'],$args['offset']);}
			return $this->db->get()->result_array();
		}

	#--------------------------------------------------------	

		#date : 28-8-2014
		function get_employee_users($args){
			$args['conditions']['u.user_type'] = 'employee';
			$args['conditions']['u.status'] = 1;
			return $this->get_all_users($args);
		}	

	#--------------------------------------------------------	

		#date : 28-8-2014
		function get_designation($conditions){

			$this->db->select(array('id','designation_id'));
			$this->db->from('users');
			$this->db->where($conditions);
			$type = $this->db->get()->row_array();
			return $type['designation_id'];
		}	

	#--------------------------------------------------------

		#date:01-9-2014
		#purpose:get user ids
		public function get_user_ids($conditions){

			$this->db->select('id');
			$this->db->from('users');
			$this->db->where($conditions);
			return $this->db->get()->result_array();
		}
	#--------------------------------------------------------
		public function get_max_id(){
			$this->db->select_max('id');
			$this->db->from('users');
			$row = $this->db->get()->row_array();
			return $row['id'];


		}
	#--------------------------------------------------------
		public function check_in_delete($id){
			$user = $this->db->get_where('users',array('id'=>$user_id))->row_array();
			#user privileges
			$privileges = $this->db->select('id')->get_where('user_privileges',array('owner_id'=>$id))->num_rows();
			$tasks = $this->db->select('id')->get_where('employee_tasks',array('employee_id'=>$id,'status'=>1))->num_rows();
			$attendance = $this->db->select('id')->get_where('employee_attendance',array('user_id'=>$id,'status'=>1))->num_rows();
			$targets = $this->db->select('id')->get_where('targets',array('user_id'=>$id,'status !='=>0))->num_rows();
			$points = $this->db->select('id')->get_where('user_points',array('user_id'=>$id,'status'=>0))->num_rows();
			if(empty($privileges) && empty($tasks) && empty($attendance) && empty($targets) && empty($points)){
				return true;
			}
			else{
				return false;
			}
		} 
	#----------------------------------------------------------	


   }
?>