<?php if( ! defined('BASEPATH')) exit ('No direct script access allowed');

	class User_target_model extends MY_Model{

	  #------------------------------------------------------
		public function user_target($user_id){

			$this->db->select('target');
			$this->db->from('employee_targets');
			$this->db->where(array('valid_to'=>000-00-00,'user_id'=>$user_id));
			$target = $this->db->get()->row_array();

			return $target;
		}
	  #------------------------------------------------------
		public function update_target($user_id,$target){
			$row = $this->db->get_where('employee_targets',array('user_id'=>$user_id,'valid_to'=>'0000-00-00'))->row_array();

			if(!empty($row)){
				$this->db->update('employee_targets',array('valid_to'=>date('y-m-d'),array('id'=>$row['id'])));	
			}

			$this->db->insert('employee_targets',array('user_id'=>$user_id,'target'=>$target,'valid_from'=>date('Y-m-d'),'created_by'=>$this->session->userdata('id')));
			return true;

		}
	  #------------------------------------------------------

		#date : 27-8-2014
		#purpose : get achieved/assigned target percentage
		function get_achieved_percent($assigned_target){
			
			#assigned target VALID_FROM & VALID_TO
			$valid_from = $assigned_target['valid_from'];
			$valid_to = $assigned_target['valid_to'];

			$total_order = $this->order_lib->get_all(array('conditions'=>array('user_id'=>$assigned_target['user_id'],'final_status'=>1),'between'=>array('DATE(created_on)'=>array($valid_from,$valid_to)),'numrows'=>TRUE));
			if($assigned_target['qty']>0)
                        {
			return $percentage = ($total_order / $assigned_target['qty']) * 100;
                        }
                        return 0;
		}

	  #-------------------------------------------------------	

		#date : 27-8-2014
		function get_all($args){
			$this->db->select(array('t.*','u.fname','u.lname','i.item_name','unit.symbol'));
			$this->db->from('targets t');
			$this->db->join('users u','u.id=t.user_id');
			$this->db->join('item_master i','i.id=t.item_id');
			$this->db->join('unit_master unit','unit.id=t.unit_id');
			$this->db->where($args['conditions']);

			if(isset($args['between'])){
				$this->db->where($args['between'][0].' '.$args['between'][0][0].' AND '.$args['between'][0][1],NULL,FALSE);
			}

			if(isset($args['numrows'])){
				return $this->db->count_all_results();
			}

			if(isset($args['order_by'])){
				$this->db->order_by($args['order_by'],$args['order']);
			}

			if(isset($args['limit'])){
				$this->db->limit($args['limit'],$args['offset']);
			}

			return $this->db->get()->result_array();
		}

	  #--------------------------------------------------------	

		#date : 4-9-2014
		#purpose : get total target qty
		function total_target_qty($args){
			
			$rows = $this->get_all($args);
			$total = 0;
			foreach($rows as $row){

				$conversion = $this->cart_lib->convert_to_primary(array('item_id'=>$row['item_id'],'current_unit'=>$row['unit_id']));
				$qty = $row['qty'] * $conversion;

				$total = $total + $qty;
			}
			return $total;
		}


	  #----------------------------------------------------------	
	}
?>