<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Voucher_model extends MY_Model
{
	public function __construct()
	{
		parent :: __construct();

		#-----------fiscal year dates
		$fiscal_year = $this->dms->get_fiscal_year();
		$this->fiscal_start_date = $fiscal_year['start_date'];
		$this->fiscal_end_date = $fiscal_year['end_date'];
	}

	public function insert($table,$data)
	{
		if($table != "dms_voucher_banks"){
			$data['company_id'] = $this->session->userdata('company_id');
			$data['branch_id'] = $this->session->userdata('under_id');
		}
		$result = $this->f_save($table,$data);
		if($result){
			return $result;
		}
		return false;
	}

    public function voucher_types_all($vtype_id)
	{
		$data = array();
		$this->db->select(array('id','vtype'))->from('dms_voucher_types')->where("(company_id = 0 or company_id = ".$this->session->userdata('company_id').")")->where(array('vid' => $vtype_id,'status' => 1))->order_by('id');
		$row = $this->db->get()->result_array();
		if(!empty($row))
		{
			foreach($row as $key => $value)
			{
				$data[$value['id']] = $value['vtype'];
			}
		}
		return $data;
	}

	public function voucher_types($vtype_id)
	{
		$data = array();
		$this->db->select(array('id','vtype'))->from('dms_voucher_types')->where("(company_id = 0 or company_id = ".$this->session->userdata('company_id').")")->where(array('vid' => $vtype_id,'id!='=>16,'status' => 1))->order_by('id');
		$row = $this->db->get()->result_array();
		if(!empty($row))
		{
			foreach($row as $key => $value)
			{
				$data[$value['id']] = $value['vtype'];
			}
		}
		return $data;
	}
	
	public function voucher_types_virtual($vtype_id)
	{
		$data = array();
		$this->db->select(array('id','vtype'))->from('dms_voucher_types')->where("(company_id = 0 or company_id = ".$this->session->userdata('company_id').")")->where(array('id' => $vtype_id,'id'=>16,'status' => 1))->order_by('id');
		$row = $this->db->get()->result_array();
		if(!empty($row))
		{
			foreach($row as $key => $value)
			{
				$data[$value['id']] = $value['vtype'];
			}
		}
		return $data;
	}

	public function voucher_name($vtype_id)
	{
		$row = $this->db->select('vtype')->get_where('dms_voucher_types',array('id' => $vtype_id))->row_array();
		if(!empty($row)){
			return $row['vtype'];
		}
		return false;
	}

	public function get_ledgers($cond = NULL)
	{
	    $branch_id = $this->session->userdata('under_id');
		$this->db->select(array('a.sub_group','b.id','b.ledger_name','b.branch_id','b.sgroup_id'))->from("account_sub_groups as a")->join("dms_ledgers as b","a.id=b.sgroup_id","inner")->where("(b.company_id = 0 or b.company_id = ".$this->session->userdata('company_id').")")->where(array('a.status' => 1,'b.status' => 1));
		if(!empty($cond)){
			$this->db->where($cond);
		}
		$row = $this->db->get()->result_array();
		$data = array();
		$data[""] = "select";
		foreach($row as $key => $value)
		{
		    $data[$value['sub_group']][$value['id']] = $value['ledger_name'];
		}
		return $data;
	}
	
	public function get_ledgers1($cond = NULL)
	{
		$this->db->select(array('a.sub_group','b.id','b.ledger_name'))->from("account_sub_groups as a")->join("dms_ledgers as b","a.id=b.sgroup_id","inner")->where("(b.company_id = 0 or b.company_id = ".$this->session->userdata('company_id').")")->where("(b.branch_id = 0 or b.branch_id = ".$this->session->userdata('under_id').")")->where(array('a.status' => 1,'b.status' => 1));
		if(!empty($cond)){
			$this->db->where($cond);
		}
		$row = $this->db->get()->result_array();
		$data = array();
		$data[""] = "select";
		foreach($row as $key => $value)
		{
			$data[$value['sub_group']][$value['id']] = $value['ledger_name'];
		}
		return $data;
	}
	
	public function get_ledgers2($cond = NULL)
	{
	    $branch_id = $this->session->userdata('under_id');
		$this->db->select(array('a.sub_group','b.id','b.ledger_name','b.branch_id','b.sgroup_id'))->from("account_sub_groups as a")->join("dms_ledgers as b","a.id=b.sgroup_id","inner")->where("(b.company_id = 0 or b.company_id = ".$this->session->userdata('company_id').")")->where(array('a.status' => 1,'b.status' => 1));
		if(!empty($cond)){
			$this->db->where($cond);
		}
		$row = $this->db->get()->result_array();
		$data = array();
		$data[""] = "select";
		foreach($row as $key => $value)
		{
		    if($value['sgroup_id']!='15')
		    {
			    $data[$value['sub_group']][$value['id']] = $value['ledger_name'];
		    }    
		}
		return $data;
	}

	public function next_voucher_id($vtype)
	{
		$vid = $this->get_vid($vtype);
		$this->db->select(array('a.vtype_id','a.vno','a.vdate'))->from('dms_voucher_temps as a')->join('dms_voucher_types as b','a.vtype_id=b.id','inner')->where(array('b.vid' => $vid,'branch_id'=>$this->session->userdata('under_id')))->where("a.vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false)->order_by('a.id','asc')->limit(1);
		$row = $this->db->get()->row_array();
		if(empty($row))
		{
			$this->db->select_max('vno')->from('dms_vouchers')->where(array('vtype_id' => $vtype,'status !=' => 0,'branch_id'=>$this->session->userdata('under_id')))->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
			$row = $this->db->get()->row_array();
			$cur_date=date('Y-m-d');
			$row['vtype_id'] = $vtype;
			$row['vdate'] = $cur_date;
			$row['vstatus'] = 0;
			if($row['vno'] != NULL){
				$row['vno'] = $row['vno']+1;
			}
			else{
				$row['vno'] = 1;
			}
		}
		else
		{
			$row['vstatus'] = 1;
		}
		return $row;
	}

	public function next_vorder_no($vtype)
	{
		$this->db->select_max('vorder_no')->from('dms_voucher_temps')->where('vtype_id',$vtype)->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		$row = $this->db->get()->row_array();
		$vorder_no = 1;
		if($row['vorder_no'] != NULL)
		{
			$vorder_no = $row['vorder_no']+1;
		}
		return $vorder_no;
	}

	public function get_vouchers($args = array())
	{
		if(!isset($args['columns']))
		{
			$args['columns'] = array('id','vtype_id','vno','vorder_no','vdate','dr_ledger','cr_ledger','vamount','particulars','narration');
		}
		$this->db->select($args['columns'])->from($args['table']);
		$this->db->where('company_id',$this->session->userdata('company_id'));
		$this->db->where('branch_id',$this->session->userdata('under_id'));
		$this->db->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['numrows']))
		{
			return $this->db->count_all_results();
		}
		if(isset($args['order_by']))
		{
			$this->db->order_by($args['order_by'], $args['order']);
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function get_vid($vtype)
	{
		$row = $this->db->select('vid')->get_where('dms_voucher_types',array('id' => $vtype))->row_array();
		return $row['vid'];
	}

	public function update($args = array())
	{
		if(!is_array($args['conditions'])){
			$args['conditions'] .= " and vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'";
		}
		if($this->db->update($args['table'],$args['data'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function delete($args = array())
	{
		if($this->db->delete($args['table'],$args['conditions'])){
			return true;
		}
		return false;
	}

	public function save_array($data,$status,$narration = NULL)
	{
		$group_id = $this->get_group_id();
		$array_count = count($data);
		for($i = 0;$i< $array_count;$i++){
			$data[$i]['company_id'] = $this->session->userdata('company_id');
			$data[$i]['branch_id'] = $this->session->userdata('under_id');
			$data[$i]['group_id'] = $group_id;
		//	$data[$i]['narration'] = $narration;
			$data[$i]['status'] = $status;
			$data[$i]['created_on'] = date('Y-m-d H:i:s');
			$data[$i]['created_by'] = $this->session->userdata('id');
		}
 		if($this->db->insert_batch("dms_vouchers",$data)){
 			return $group_id;
		}
		return false;
	}

	public function get_group_id()
	{
		$row = $this->db->select_max('group_id')->get_where('dms_vouchers')->row_array();
		if($row['group_id'] != NULL){
			$row['group_id'] = $row['group_id']+1;
		}
		else{
			$row['group_id'] = 1;
		}
		return $row['group_id'];
	}

	#----------to get distinct voucher no's
	public function get_voucher_ids($args = array())
	{
		$this->db->distinct()->select($args['distinct'])->from($args['table']);
		$this->db->where('company_id',$this->session->userdata('company_id'));
		$this->db->where('branch_id',$this->session->userdata('under_id'));
		//$this->db->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		$this->db->where('status',1);
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		if(isset($args['between'])){
			$this->db->where($args['between'],NULL,false);
		}
		else{
			$this->db->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		}
		if(isset($args['like']) && !empty($args['like']))
		{
			$this->db->like($args['like'],false,'before');
		}
		if(isset($args['numrows']))
		{
			return $this->db->get()->num_rows();
		}
		if(isset($args['order_by']))
		{
			$order_by = explode('|', $args['order_by']);
			foreach($order_by as $key => $value)
			{
				$this->db->order_by($value, $args['order']);
			}
		}
		if(isset($args['limit']))
		{
			$this->db->limit($args['limit'], $args['offset']);
		}
		return $this->db->get()->result_array();
	}

	public function max_vorder_no($voucher_type,$voucher_no)
	{
		$this->db->from('dms_vouchers');
		$this->db->where(array('company_id',$this->session->userdata('company_id'),'branch_id' => $this->session->userdata('under_id'),'vtype_id' => $voucher_type,'vno' => $voucher_no,'status' => 1));
		$this->db->where("vdate between '$this->fiscal_start_date' and '$this->fiscal_end_date'",NULL,false);
		return $this->db->count_all_results();
	}

	#======================================

	public function get_voucher_number($vtype){
		$vno=0;
		$this->db->select_max('vno')->from('dms_voucher_temps');
		$this->db->where(array('vtype_id' =>$vtype,'company_id'=>$this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id')));
		$this->db->where("vdate between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,false);
		$row = $this->db->get()->row_array();

		if(!empty($row)){
			$vno = $row['vno'];
		}
		$this->db->select_max('vno')->from('dms_vouchers');
		$this->db->where(array('vtype_id' => $vtype,'status !=' => 0,'company_id'=>$this->session->userdata('company_id'),'branch_id'=>$this->session->userdata('under_id')));
		$this->db->where("vdate between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,false);
		$row = $this->db->get()->row_array();

		if(!empty($row) && $row['vno'] > $vno){
			$vno = $row['vno'];
		}
		return $vno+1;
	}

	#======================================

	public function cheque_data($args = array())
	{
		$this->db->select($args['columns'])->from('dms_vouchers as a')->join('dms_voucher_banks as b','a.group_id = b.group_id');
		$this->db->where(array('a.company_id'=>$this->session->userdata('company_id')));
		if(!isset($args['conditions']['a.branch_id'])){
			$args['conditions']['a.branch_id'] = $this->session->userdata('under_id');
		}
		if(empty($args['conditions']['a.branch_id'])){
			unset($args['conditions']['a.branch_id']);
		}
		$this->db->where("a.vdate between '".$this->fiscal_start_date."' and '".$this->fiscal_end_date."'",NULL,false);
		if(isset($args['conditions']))
		{
			$this->db->where($args['conditions']);
		}
		return $this->db->get()->result_array();
	}
}
?>