<?= export_to_excel('excel/booking_excel/sales'.$redirect); ?>
<div class="table-responsive block">
    <table class="table table-striped table-condensed table-bordered tbl-brdr">
    <tr class="bg-success">
    <th>#</th>
    <th><?=$this->lang->line('date');?></th>
    <th><?=$this->lang->line('bill-no');?></th>
    <th><?=$this->lang->line('customer');?></th>
    <th><?=$this->lang->line('delivery')." ".$this->lang->line('date');?></th>
    <th><?=$this->lang->line('paid')." ".$this->lang->line('amt');?></th>
    <th><?=$this->lang->line('balance')." ".$this->lang->line('amt');?></th>
    <th colspan='5'><?=$this->lang->line('actions');?></th>
    </tr>
	<?php
	foreach($sales_array as $key => $value):
	
		$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
		$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;

                $item_details = $this->sales_obj->get_sales_items(array('columns' => array('item_id','qty','rate','amount','discount_amt','cgst_amt','sgst_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));

		foreach($item_details as $item_key => $item_value):
			$tax_amount = 0;
			$net_value = ($item_value['amount']-$item_value['discount_amt']);
                    
                        $cgst = $this->stock->get_item_cgst($item_value['item_id']);
                        $sgst = $this->stock->get_item_sgst($item_value['item_id']);
                        $tax_amount = $item_value['cgst_amt']+$item_value['sgst_amt'];

			$total_tax_amount += $tax_amount;
			$total_amount += $net_value;
		endforeach;
		$total_amount += $total_tax_amount;
                
                $total_amount += (($value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);

		?>
        <tr>
        <td class="text-center"><?=++$offset;?></td>
        <td class="text-center"><?=dateFormat($value['bill_date']);?></td>
        <td><?=$bill_prefix.' '.$value['bill_no'];?></td>
        <td><?=$this->stock->get_customer($value['customer_type_id'],$value['customer_id']);?></td>
        <td class="text-center"><?=dateFormat($value['delivery_date']);?></td>
        <td class="text-right"><?=numberFormat(get_rounded($value['paid_amount']));?></td>
        <td class="text-right"><?=numberFormat(get_rounded($value['balance_amount']));?></td>
        <?php if($value['book_status'] == 0){?>
        	<?php app_table_links('id/'.$value['id'].$redirect,array(622,623,626,621,620));?>
        <?php }else{?>
        	<?php app_table_links('id/'.$value['id'].$redirect,array(622,620),5);
		}?>
        </tr>
	<?php endforeach;?>
	</table>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="pagination"><?=$links;?></div>
	</div>
</div>