<?= form_open();
$uri_array = $this->uri->uri_to_assoc(1);
$uri_string = $this->uri->assoc_to_uri($uri_array);
$bill_prefix = $this->stock->get_voucher_prefix($sales_array[0]['vtype_id']);
?>
<script>
    $(document).ready(function(e) {
        $('#new').on('click',function(){
            if($(this).is(":checked"))
            {
                $('#det').hide();
                $('#det1').show();
            }
            else
            {
                $('#det').show();
                $('#det1').hide();
            }
        });
        $(".payment-mode2").change(function(){
    		var id = parseInt($(this).val());
    		if(id > 2){
    			$('.cd-ajax2').removeClass('hide');
    			$('.cd-ajax2').css('display','block');
    		}else{
    			$('.cd-ajax2').addClass('hide');
    			$('.cd-ajax2').css('display','none');
    		}
    	});
    	$('.pamount').keyup(function(e){
            $('.bill_advance').val('');
            var amount1 = parseFloat($(".amount1").val());
            var amount2 = parseFloat($(".amount2").val());
            var amount3 = parseFloat($(".amount3").val());
                
            if(isNaN(amount1) || amount1 == null){amount1=0;}
            if(isNaN(amount2) || amount2 == null){amount2=0;}
            if(isNaN(amount3) || amount3 == null){amount3=0;}
                
        	var amount = amount1+amount2+amount3;
        	$('.bill_advance').val(amount)
        });
    });    
</script>
<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("edit")." ".$this->lang->line("$voucher_name-bill"); ?></h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('voucher-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                        <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                        <?=form_input('bill_no',set_value('bill_no',$sales_array[0]['bill_no']),"class='form-control text-right number' id='sbill-ajax'");?>
                    </div>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
    				<?=form_input('bill_date',set_value('bill_date',cdateFormat($sales_array[0]['bill_date'])),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">            
                <div class="col-md-4">
                    <label><?=$this->lang->line('phone');?></label>                  
                    <?= form_input(array('name'=>'sales[mobile]','class'=>'form-control mobile'),set_value('sales[mobile]',$cust_mob)); ?> 
                    <?= form_error('sales[mobile]');?> 
                </div> 
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('customer-name');?></label>                  
                    <?= form_input(array('name'=>'sales[customer_id]','class'=>'form-control customer-name '),set_value('sales[customer_id]',$cust_name)); ?> 
                    <?= form_error('sales[customer_id]');?> 
                </div> 
                <div class="col-md-4">
        			<label><?=$this->lang->line('address');?></label>
        			<?=form_textarea(array('name'=>'sales[address]','class'=>'form-control addr','rows'=>1),set_value('sales[address]',$cust_addr));?>
        			<?=form_error('sales[address]');?>
			    </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
    				<label><?=$this->lang->line('email');?></label>
    				<?=form_input(array('name'=>'sales[email_id]','class'=>'form-control mail'),set_value('sales[email_id]',$cust_mail));?>
    				<?=form_error('sales[email_id]');?>
    			</div>
    			<div class="col-md-4">
                    <label ><?=$this->lang->line('sales-man');?></label>	
		            <?=form_dropdown('sales[salesman]',$user_name,set_value('sales[salesman]',$user_id),'class=" user-name select-full" placeholder=>"enter sales man name"');?>
                    <?=form_error('sales[salesman]');?>
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">  
                <div class="col-md-6 text-right">
                    <label><?=$this->lang->line('prescription');?></label>    
                </div>
            </div>
            <div class="row">  
                <div class="col-md-6 text-center">
                    <label>Right</label>
                    <table class="table table-bordered">
                        <thead>
	                    <tr class="boardered">
	                        <th class="disabled"></th>
	                        <th class="disabled">SPH</th>
	                        <th class="disabled">CYL</th>
	                        <th class="disabled">AXIS</th>
	                        <th class="disabled">V/N</th>	                             
                        </tr>
                        <tr>
                            <th class="disabled">DV</th> 
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rdv1" name="des[rdv1]" value="<?php echo $des_array['rdv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rdv2" name="des[rdv2]" value="<?php echo $des_array['rdv2'] ?>"></td>                                         
                            <td><?= form_input(array('name'=>'des[rdv3]','class'=>'form-control text-right','id'=>'rdv3'),set_value('des[rdv3]',$des_array['rdv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[rdv4]','class'=>'form-control text-right','id'=>'rdv4'),set_value('des[rdv4]',$des_array['rdv4'])); ?></td>
                        </tr>
                        <tr>
                            <th class="disabled">NV</th>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rnv1" name="des[rnv1]" value="<?php echo $des_array['rnv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="rnv2" name="des[rnv2]" value="<?php echo $des_array['rnv2'] ?>"></td>                                        
                            <td><?= form_input(array('name'=>'des[rnv3]','class'=>'form-control text-right','id'=>'rnv3'),set_value('des[rnv3]',$des_array['rnv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[rnv4]','class'=>'form-control text-right','id'=>'rnv4'),set_value('des[rnv4]',$des_array['rnv4'])); ?></td>
                        </tr>
                        <tr>
                            <th colspan="2" class="disabled">ADD</th>
                            <td><?= form_input(array('name'=>'des[radd]','class'=>'form-control','id'=>'radd' ),set_value('des[radd]',$des_array['radd'])); ?></td>
                            <th class="disabled">IPD</th>
                            <td><?= form_input(array('name'=>'des[ripg]','class'=>'form-control','id'=>'ripg' ),set_value('des[ripg]',$des_array['ripg'])); ?></td>
                        </tr>
                    </table>                         
                </div>
                <div class="col-md-6 text-center">
                    <label>Left</label>
                    <table class="table table-bordered">
                        <thead>
	                    <tr class="boardered">
	                        <th class="disabled"></th>
	                        <th class="disabled">SPH</th>
	                        <th class="disabled">CYL</th>
	                        <th class="disabled">AXIS</th>
	                        <th class="disabled">V/N</th>	                             
                        </tr>
                        <tr>
                            <th class="disabled">DV</th>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="ldv1" name="des[ldv1]" value="<?php echo $des_array['ldv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="ldv2" name="des[ldv2]" value="<?php echo $des_array['ldv2'] ?>"></td>                                        
                            <td><?= form_input(array('name'=>'des[ldv3]','class'=>'form-control text-right','id'=>'ldv3' ),set_value('des[ldv3]',$des_array['ldv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[ldv4]','class'=>'form-control text-right','id'=>'ldv4' ),set_value('des[ldv4]',$des_array['ldv4'])); ?></td>
                        </tr>
                        <tr>
                            <th class="disabled">NV</th>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="lnv1" name="des[lnv1]" value="<?php echo $des_array['lnv1'] ?>"></td>
                            <td><input type="number" class="form-control" step="0.25" min="-20.00" max="+5.00" id="lnv2" name="des[lnv2]" value="<?php echo $des_array['lnv2'] ?>"></td>                                        
                            <td><?= form_input(array('name'=>'des[lnv3]','class'=>'form-control text-right','id'=>'lnv3' ),set_value('des[lnv3]',$des_array['lnv3'])); ?></td>
                            <td><?= form_input(array('name'=>'des[lnv4]','class'=>'form-control text-right','id'=>'lnv4' ),set_value('des[lnv4]',$des_array['lnv4'])); ?></td>
                        </tr>
                        <tr>
                            <th colspan="2" class="disabled">ADD</th>
                            <td><?= form_input(array('name'=>'des[ladd]','class'=>'form-control','id'=>'ladd' ),set_value('des[ladd]',$des_array['ladd'])); ?></td>
                            <th class="disabled">IPD</th>
                            <td><?= form_input(array('name'=>'des[lipg]','class'=>'form-control','id'=>'lipg' ),set_value('des[lipg]',$des_array['lipg'])); ?></td>
                        </tr>
                    </table>                         
                </div>
            </div>
        </div>
        <input type="checkbox" id="new" name="newp" class="check-main styled"><?=$this->lang->line('new');?> <?=$this->lang->line('product');?>
        <div id="det">
        	<div class="form-group">
            	<div class="row">
                	<div class="col-md-4">
			            <label class="required"><?=$this->lang->line('item-name');?></label>
			            <?= form_dropdown('item_id',$items,set_value('item_id'),'class=" form-control item_name select-full"'); ?>
			            <?= form_error('item_id');?>
                	</div>
            	</div>
        	</div>		        
        </div>
		<div id="det1" style="display:none;">
		    <div class="form-group">
		        <div class="row">
		            <div class="col-md-4">
						<label class="required"><?=$this->lang->line('item-type');?></label>
						<?=form_dropdown('new_item[item_group_id]',$groups,set_value('new_item[item_group_id]'),'class=" form-control item_group select-full"');?>
						<?=form_error('new_item[item_group_id]');?>	
					</div>
		            <div class="col-md-4">
		                <label class="required"><?=$this->lang->line('item-code');?></label>
		                <?= form_input(array('name'=>'new_item[item_code]','class'=>'form-control item-code1'),set_value('new_item[item_code]')); ?>
		                <?= form_error('new_item[item_code]');?>
		            </div>                		 
			        <div class="col-md-4">
			            <label class="required"><?=$this->lang->line('item-name');?></label>
			            <?= form_input(array('name'=>'new_item[item_name]','class'=>'form-control item-id1'),set_value('new_item[item_name]')); ?>
			            <?= form_error('new_item[item_name]');?>
			        </div>			
		        </div>
		    </div>
		    <div class="form-group">
		        <div class="row"> 
			        <div class="col-md-4">
						<label class="required dis-block"><?=$this->lang->line('units');?></label>
						<?=form_dropdown('new_item[unit_id]',$units1,set_value('new_item[unit_id]'),'class="form-control simple-unit1"');?>	
						<?=form_error('new_item[unit_id]');?>
					</div>			       
			        <div class="col-md-4">
			            <label><?=$this->lang->line('model-no');?></label>
			            <?= form_input(array('name'=>'new_item[model_no]','class'=>'form-control modelno'),set_value('new_item[model_no]')); ?>
			            <?= form_error('new_item[model_no]');?>
			        </div>
			        <div class="col-md-4">
			            <label><?=$this->lang->line('hsn-code');?></label>
			            <?= form_input(array('name'=>'new_item[hsn]','class'=>'form-control hsn1'),set_value('new_item[hsn]')); ?>
			            <?= form_error('new_item[hsn]');?>
			        </div>
		        </div>
		    </div>
	    </div> 
        <div class="form-group">
            <div class="row">
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty qty-rate decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate qty-rate decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount'),set_value('amount')); ?>
                    <?= form_error('amount');?>
                </div>
                <div class="col-md-2">
                    <label><?=$this->lang->line('discount');?> %</label>
                    <?= form_input(array('name'=>'discount_per','class'=>'form-control text-right discount_per decimal','id'=>'discount_per'),set_value('discount_per')); ?>
                    <?= form_error('discount_per');?>
                </div>
                <div class="col-md-2">
                    <label><?=$this->lang->line('discount');?> <?=$this->lang->line('amt');?></label>
                    <?= form_input(array('name'=>'discount_amt','class'=>'form-control text-right discount_amt decimal'),set_value('discount_amt')); ?>
                    <?= form_error('discount_amt');?>
                </div>
            </div>
        </div>
        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>
        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>
	</div>
</div>
    <div class="row">
        <div class="col-md-12">
            <div class='table-responsive'>
                <table class="table table-bordered table-striped">
                    <thead>
                    <tr class="bg-success">
                        <th>#</th>
                        <th width="30%" colspan="2"><?= $this->lang->line('item-name');?></th>
                        <th><?= $this->lang->line('cqty');?></th>
                    	<th><?= $this->lang->line('qty');?></th>
                    	<th><?= $this->lang->line('price'); ?></th>
                    	<th><?= $this->lang->line('cash'); ?> <?= $this->lang->line('dis'); ?></th>
                    	<th><?= $this->lang->line('taxable'); ?></th>
                        <th><?= $this->lang->line('tax'); ?>(%) <?= $this->lang->line('vat'); ?></th>
                        <th><?= $this->lang->line('tax'); ?> <?= $this->lang->line('amt'); ?></th>
                        <th><?= $this->lang->line('cess'); ?> (%)</th>
                        <th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
                    	<th width="10%"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                        <th colspan='2'><?=$this->lang->line('actions');?></th>
                    </tr>
                    </thead>
<?php
                    $i=0; $totalAmount=0; $totalDiscountAmt=0; $totalNetValue=0; $totalVatAmt=0; $totalCessAmt=0; $totalNetAmount=0; $totalFreight=0; $totalTaxable=0;
                    $grandNetAmount=0; $total_cst_amount = 0; $a=12; $b=10;
                    $cess = $sales_array[0]['cess'];
                    foreach($sales_array as $key => $item)
                    {
                        $i++;
                        $itemID = $item['item_id'];
                        $item_details = $this->stock->get_item($itemID,array('item_code','item_name','model_no'));
                        $qty = $item['qty'];
                        $rate = $item['rate'];
                        $godown = $item['godown_id'];
                		$cqty = $this->stock->get_stock_count($godown,$itemID,date('Y-m-d'));
                        $perc = $discount_per = $item['discount_per'];
                        
                        $discount_amt = $item['discount_amt'];
                        $cst_percent = $item['cst'];
                        $vat = 0;$vatAmount = 0;$cst_amount = 0;
                        $amount = $item['amount'];
                        $taxable = $item['taxable_amt'];
                        $totalAmount += $amount;
                        $netValue = $amount-$discount_amt;
                        
                        $vat= $item['vat'];
                        $vatAmt = $item['vat_amt'];
                        $cessAmt = $item['cess_amt'];
                        
                        $totalVatAmt += $vatAmt;
                		$totalTaxable += $taxable;
                		$totalCessAmt += $cessAmt;
                		
                		$total_cst_amount += $cst_amount;
                		$totalNetValue += $taxable;
                		$netAmount = $taxable+$vatAmt+$cessAmt;
                		$totalNetAmount += $netAmount;
                		$totalDiscountAmt += $discount_amt;
?>
                        <tr>
                            <td><?= $i; ?></td>
                            <td colspan="2"><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?> / <?= $item_details['model_no']; ?></td>
                            <td class="text-right"><b><font color="#2F5923"><?= $cqty; ?></font></b></td>
                    		<td class="text-right"><?= $qty; ?></td>
                    		<td class="text-right"><?= numberFormat($rate); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
                    		<td class="text-right"><?= numberFormat(round_this($taxable)); ?></td>
            				<td class="text-right"><?= $vat; ?></td>
            				<td class="text-right"><?= numberFormat(round_this($vatAmt)); ?></td>	
                            <td class="text-right"><?= numberFormat($cess); ?></td>
                            <td class="text-right"><?= numberFormat($cessAmt); ?></td>
		                    <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                            <?php app_table_links('idu/'.$item['id'].$redirect,array(624,625));?>
                        </tr>
<?php
                    }
                    $grandNetAmount = round_this($totalNetAmount);
?>
                    <tr>
                    	<td class="text-right text-bold" colspan="6"><?= $this->lang->line('total'); ?></td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalTaxable)); ?></td>
                    	<td class="disabled"></td>
                    	<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
		                <td class="disabled"></td>
		                <td class="text-right text-bold"><?= numberFormat(round_this($totalCessAmt)); ?></td>
                	    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                	    <td colspan="2" class="disabled"></td>
                	</tr>
<?php 
                    $presumptive_tax_amt = 0;
                	if(!empty($presumptive_tax))
                	{
                		$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
                		$grandNetAmount += round_this($presumptive_tax_amt);
                		$totalVatAmt = $presumptive_tax_amt;
?>
                        <tr>
                            <td colspan="<?=($a-$colspan);?>" class="text-right">
                            <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
                            <td class="text-right"><?=numberFormat($presumptive_tax_amt);?></td>
                            <td colspan="2" class="disabled"></td>
                        </tr>
<?php 
	                }
?>
                    <tr>
                        <td colspan="2" class="text-right text-bold"><?=$this->lang->line('area');?></td>
                        <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                            <div class="row">
                                <div class="col-md-9"><?= form_dropdown('area_id',$areas,set_value('area_id',$area_id),'class="form-control"'); ?><?= form_error('area_id');?></div>
                                <div class="col-md-3 pull-right"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</div>
                            </div>
                        </td>
                        <td class="text-right"><?=numberFormat(round_this($totalcess));?></td>
                        <td colspan="2" class="disabled"></td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?> 1</td>
                    	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                            <div class="row">
                            	<div class="col-md-2"><?= form_dropdown('payment_mode',$payment_modes,set_value('payment_mode',$sales_array[0]['payment_mode']),'class="form-control payment-mode"'); ?><?= form_error('payment_mode');?></div>
                                <div class="col-md-2 required"><?=$this->lang->line('amount');?> 1</div>
                                <div class="col-md-2"><?= form_input(array('name'=>'amount1','class'=>'form-control decimal text-right pull-right amount1 pamount'),set_value('amount1',$sales_array[0]['amount1'])); ?><?=form_error('amount1');?></div>
                                <div class="col-md-2"><?= $this->lang->line('credit-period');?></div>
                                <div class="col-md-2"><?= form_input(array('name'=>'credit_period','class'=>'form-control number text-right'),set_value('credit_period')); ?><?=form_error('credit_period');?></div>
                            	<div class="col-md-2 pull-right"><?= $this->lang->line('freight');?></div>
                            </div>
                    	</td>
                	    <td><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight',$sales_array[0]['bill_freight'])); ?><?=form_error('freight');?></td>
                	    <td colspan="2" class="disabled"></td>
                	</tr>
                	<tr>
                	    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
                            <div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
                                <div class="row">
                                    <div class="col-md-3">
                                        <?php $transaction_types = $this->dms->transaction_types();?>
                                        <?= form_dropdown('ccd',$transaction_types,set_value('ccd'),'class="form-control"'); ?>
                                        <?=form_error('ccd');?>
                                    </div>
                                    <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
                                    <div class="col-md-3">
                                        <?=form_input('cd_no',set_value('cd_no'),"class='form-control'");?>
                                        <?=form_error('cd_no');?>
                                    </div>
                                    <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
                                    <div class="col-md-2">
                                        <?=form_input('cheque_date',set_value('cheque_date',cdateFormat($voucher_date)),"class='datepicker form-control'");?>
                                        <?=form_error('cheque_date');?>
                                    </div>
                                </div>
                            </div>
    	                </td>
                        <td></td>
                        <td colspan="2" class="disabled"></td>
	                </tr>
	                <tr>
                        <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?> 2</td>
                    	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                            <div class="row">
                            	<div class="col-md-2"><?= form_dropdown('payment_mode2',$payment_modes,set_value('payment_mode2',$sales_array[0]['payment_mode2']),'class="form-control payment-mode2"'); ?><?= form_error('payment_mode2');?></div>
                                <div class="col-md-2"><?=$this->lang->line('amount');?> 2</div>
                                <div class="col-md-2"><?= form_input(array('name'=>'amount2','class'=>'form-control decimal text-right pull-right amount2 pamount'),set_value('amount2',$sales_array[0]['amount2'])); ?><?=form_error('amount2');?></div>
                                <div class="col-md-6"></div>
                            </div>
                    	</td>
                	    <td></td>
                	    <td colspan="2" class="disabled"></td>
                	</tr>
                	<tr>
                	    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
                            <div class="cd-ajax2 <?php if($cd_status){?>hide<?php }?>">
                                <div class="row">
                                    <div class="col-md-3">
                                        <?php $transaction_types = $this->dms->transaction_types();?>
                                        <?= form_dropdown('ccd2',$transaction_types,set_value('ccd2'),'class="form-control"'); ?>
                                        <?=form_error('ccd2');?>
                                    </div>
                                    <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
                                    <div class="col-md-3">
                                        <?=form_input('cd_no2',set_value('cd_no2'),"class='form-control'");?>
                                        <?=form_error('cd_no2');?>
                                    </div>
                                    <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
                                    <div class="col-md-2">
                                        <?=form_input('cheque_date2',set_value('cheque_date2',cdateFormat($voucher_date)),"class='datepicker form-control'");?>
                                        <?=form_error('cheque_date2');?>
                                    </div>
                                </div>
                            </div>
    	                </td>
                        <td></td>
                        <td colspan="2" class="disabled"></td>
	                </tr>
                    <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                        <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                            <div class="row">
                                <div class="col-md-9 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks',$sales_array[0]['narration'])); ?><?=form_error('remarks');?></div>
                                <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
                            </div>
                        </td>
                        <td class="text-right"><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense',$sales_array[0]['other_expense'])); ?><?=form_error('other_expense');?></td>
                        <td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
                    </tr>
<?php
                	if($this->input->post('freight'))
                	{
                		$grandNetAmount += $this->input->post('freight');
                	}
                	else
                	{
                		$grandNetAmount += $sales_array[0]['bill_freight'];
                	}
                	if($this->input->post('other_expense'))
                	{
                		$grandNetAmount += $this->input->post('other_expense');
                	}
                	else
                	{
                		$grandNetAmount += $sales_array[0]['other_expense'];
                	}
      
                    if(show_round_off())
                    { 
?>
                        <tr>
                            <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
                                <div class="row">
                                    <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                                </div>
                            </td>
                            <td class="text-right text-bold"><div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div></td>
                            <td colspan="2" class="disabled"></td>
                        </tr>
<?php 
                    } 
?>
                    <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
                        <td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
                            <div class="row">
                                <div class="col-md-3 pull-left"><?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent_old decimal'),set_value('bill_discount_per',$sales_array[0]['bill_discount_per'])); ?><?=form_error('bill_discount_per');?></div>
                                <div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
                                <div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount_old decimal text-right'),set_value('bill_discount_amt',$sales_array[0]['bill_discount_amt'])); ?><?=form_error('bill_discount_amt');?></div>
                                <div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                            </div>
                        </td>
                        <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
                        <td colspan="2" class="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-right text-bold" colspan="2"><?=$this->lang->line('delivery');?> <?=$this->lang->line('date');?></td>
                    	<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
                    		<div class="row">
                        		<div class="col-md-5 pull-left">
                        		    <?= form_input(array('name'=>'d_date','class'=>'datepicker form-control text-right d_date decimal'),set_value('d_date',cdateFormat($del_date))); ?>
                                    <?=form_error('d_date');?>
                                </div>
                                <div class="col-md-3 pull-right required"><?=$this->lang->line('advance');?> <?=$this->lang->line('amount');?></div>
                    		</div>
                    	</td>
                    	<td>
                    	    <?= form_input(array('name'=>'bill_advance','class'=>'form-control text-right bill_advance decimal','readonly'=>'true'),set_value('bill_advance',$paid_amt)); ?>
                            <?=form_error('bill_advance');?>
                        </td>
                        <td colspan="2" class="disabled"></td>
                	</tr>
                    <input type="hidden" name="round_off_amount" id="round_value" value="<?=round_off($grandNetAmount); ?>">
                    <input type="hidden" name="vat_total" value="<?=round_this($totalVatAmt); ?>">
                    <input type="hidden" name="cess_total" value="<?=round_this($totalCessAmt); ?>">
                    <input type="hidden" name="grand_total" value="<?=round_this($totalNetValue); ?>">
                    <input type="hidden" name="net_total" value="<?=round_this($totalAmount); ?>">
                    <input type="hidden" name="old_perc" id="old_per" value="<?=round_this($perc); ?>">
                </table>
            </div>
            <div class="row">
            	<div class="col-md-12">
            		<div class="form-group">
            			<div class="text-right">
            				<?= form_submit(array('name'=>'btn_update','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('update')."  ".$this->lang->line('bill')));?>
            			</div>
            		</div>
            	</div>
        	</div>
        </div>
    </div>
<?= form_close(); ?>