<?=form_open("customer_master/customer_data");?>
<?php if(!empty($customers)){ ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-md-4">
                <label ><?=$this->lang->line('branch');?></label>
                <?=form_dropdown('branch_id',$branches,set_value('branch_id'),'class="select-full"');?>
                <?=form_error('branch_id');?>
            </div>
            <div class="col-md-2">
                <label ><?=$this->lang->line('from-date');?></label>
                <?=form_input('from_date',set_value('from_date',cdateFormat($from_date)),"class='datepicker form-control'");?>
                <?= form_error('from_date');?>
            </div>
            <div class="col-md-4">
                <label ><?=$this->lang->line('to-date');?></label>
                <div class="row">
                    <div class="col-md-6">
                        <?=form_input('to_date',set_value('to_date',cdateFormat($to_date)),"class='datepicker form-control'");?>
                        <?= form_error('to_date');?>
                    </div>
                    <div class="col-md-6"> 
                        <?=form_button(array('name'=>'filter','class'=>'btn btn-primary btn-loading','type'=>'submit','content'=>$this->lang->line('filter')));?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?= export_to_excel('excel/customer_excel/customer_data'.$redirect); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class='table-responsive'>
                <table class="table table-bordered table-striped">
                    <thead class="bg-success">
                    <tr>
                        <th>#</th>
                        <th><?=$this->lang->line('customer-name');?></th>
                        <th><?=$this->lang->line('branch-name');?></th>
                        <th><?=$this->lang->line('mobile');?></th>
                        <th><?=$this->lang->line('address');?></th>
                        <th><?=$this->lang->line('bill-no');?></th>
                        <th><?=$this->lang->line('bill-date');?></th>
                    </tr>    
                    </thead>
<?php
                    $i=0;
                    foreach($customers as $key => $customer)
                    { 
?>
                        <tr>
                            <td><?=++$i;?></td>
                            <td><?=$customer['fname'].' '.$customer['lname'];?></td>
                            <td><?=$customer['branch_name'];?></td>
                            <td><?=$customer['mobile_no'];?></td>
                            <td><?=$customer['address'];?></td>
                            <td><?=$customer['bill_no'];?></td>
                            <td><?=dateFormat($customer['bill_date']);?></td>
                        </tr>
<?php 
                    } 
?>
                </table>
            </div>
		</div>
	</div>
<?php } ?>
<?=form_close();?>