<?= form_open(); ?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('customer-point'); ?> </h6>
</div>
<div class="panel-body">

	<div class="form-group">
        <div class="row">          
           <div class="col-md-6">
                <label class=""><?=$this->lang->line('customer');?></label>
                <?= form_dropdown('cust_id',$customers,set_value('cust_id'),"class='form-control customers'"); ?>
                <?= form_error('cust_id');?>
            </div>
        </div>
	</div> 
    
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <?=form_button(array('type'=>'submit','class'=>'btn btn-primary pull-right','content'=>$this->lang->line('get')));?>
            </div>
        </div>
    </div>    
</div>
</div>  
<?= form_close(); ?>

<?php if(!empty($customer_points)){ ?>
<div class="form-group">
    <div class="row">
        <div class="col-md-12">
        <div class='table-responsive'>
            <table class="table table-bordered table-striped">
            <thead>
            <tr class="bg-success">
            <th>#</th>
            <th><?=$this->lang->line('date');?></th>
            <th><?=$this->lang->line('points');?></th>
	    <th><?= $this->lang->line('bill-ref-no'); ?></th>
            
            </tr>
            </thead>
            <?php
			
			foreach($customer_points as $key=>$point){
				$scored_point = $point['sms_point'];
				?>
                <tr>
                <td class="text-center"><?= $count++; ?></td>
                <td><?= dateFormat($point['point_date']); ?></td>
                <td><?= $scored_point; ?></td>
                <td><?= $point['group_id']; ?></td>
                
                </tr>
                <?php
			}
			?>
            </table>
        </div>
    </div>
    

</div>
<div class="pagination"><?= $links; ?></div>

<div class="form-group">
    <div class="row">
        <div class="col-md-6">
            <label><?= $this->lang->line('total-scored-point'); ?> : <?= $total_points; ?></label>
        </div>
         <?php if($this->dms->have_access(578)){?>
    	<div class="col-md-6 text-right">
	        <a href="<?=base_url('customer_points/add/cust_id/'.$cust_id);?>"><input type="button" class="btn btn-info" value="Click here to add bonus point"></a>
        </div>
        <?php } ?>
    </div>
</div>
<?php
}
?>
