
<div class="panel panel-info">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-file4"></i><?=$this->lang->line('performance-graph');?></h6>
    </div>
    <div class="panel-body" id="graph-container">

<?=form_open('');?>

<div class="form-group">
    <div class="row">
 
        <div class="col-md-4">
            <label><?=$this->lang->line('from');?></label>
            <div class="input-group">
				<?= form_input(array('name'=>'from_date','class'=>'form-control datepicker'),set_value('from_date',cdateFormat($from_date))); ?>
				<span class="input-group-addon"><i class="icon-cancel-circle"></i></span>
			</div>
            <?= form_error('from_date');?>       
        </div>
        <div class="col-md-4">
            <label><?=$this->lang->line('to');?></label>
            <div class="input-group">
				<?= form_input(array('name'=>'to_date','class'=>'form-control datepicker'),set_value('to_date',cdateFormat($to_date))); ?>
				<span class="input-group-addon"><i class="icon-cancel-circle"></i></span>
			</div>            
            <?= form_error('to_date');?>          
        </div>        

    </div>    
</div>
<div class="form-group">
    <div class="row">
        <div class="col-md-8">
			<?=form_button(array('name'=>'filter','class'=>'btn btn-primary pull-right','type'=>'submit','content'=>$this->lang->line('filter')));?>
        </div>        
    </div>    
</div>
<?=form_close();?>

        <div class="graph-standard" id="vertical_bars"></div>
    </div>


	<?php # style="position:absolute;-webkit-transform:rotate(-40deg); color:black;  font-size:10px; white-space:nowrap; left:-<?= $left; ? >px; top:<?= $top; ? >px;"
	$ar_array = array();
	?>
	<script type="text/javascript">
	$(document).ready(function () {
		var width = $('.panel-heading').width()-100;
		$('#graph-container').width(width).css('overflow','auto').css('margin-left','auto').css('margin-right','auto');		
		var orders = new Array();
		<?php $count=1; foreach($sales as $id=>$sale):?>
			orders.push([<?=$count++;?>,'<?=$sale;?>']);
		<?php endforeach;?>
		var data1 = [{label:'sales',data:orders,bars:{show:true,order:1,barWidth:.2,align:'center'}}];
    	//var data1 = new Array();
	    var tticks = new Array();
    	<?php $count = 0;foreach($ars as $id=>$name):
			$count++;
			$ar_array[$count] = $name;
			?>
    		tticks.push([<?=$count;?>,'<div ><?= $count;?></div>']);
    		<?php endforeach;$graph_width = $count*30;?>
			$('#vertical_bars').width('<?php echo $graph_width; ?>px');
			$.plot($("#vertical_bars"), data1, {
				xaxis: {
					axisLabel: 'ARs',
					axisLabelUseCanvas: true,
					axisLabelFontSizePixels: 12,
					axisLabelFontFamily: 'Verdana, Arial, Helvetica, Tahoma, sans-serif',
					axisLabelPadding: 23,
					ticks:tticks,
					max:'<?=count($sales);?>'
				},yaxis: {
					axisLabel: 'Amount in Rs',
					axisLabelUseCanvas: true,
					axisLabelFontSizePixels: 12,
					axisLabelFontFamily: 'Verdana, Arial, Helvetica, Tahoma, sans-serif',
					axisLabelPadding: 3
				},
				colors :["#ee7951"],
				grid :{hoverable:true,borderWidth:0}
			});
	});
	</script>
<div class="table-responsive block max-height-300">
<table class="table table-striped table-condensed table-bordered tbl-brdr">
<thead>
<tr>
<th>#</th>
<th>AR Name</th>
</tr>
</thead>
<?php
foreach($ar_array as $number=>$ar){
	?>
    <tr>
    <td><?php echo $number; ?></td>
    <td><?php echo $ar; ?></td>
    </tr>
    <?php
}
?>
</table>
</div>
</div>