<?= form_open(base_url('my_bills/delivery_notes')); ?>
<div class="panel panel-primary">
<div class="panel-heading"><h6 class="panel-title"><i class="icon-database"></i><?=$this->lang->line('search');?></h6></div>
    <div class="panel-body">
    
    <div class="form-group">
        <div class="row">
            <label class="col-md-2"><?= $this->lang->line('dnote-status'); ?></label>
            <div class="col-md-3">
            <?= form_dropdown('dnote_sts',$dnote_status,set_value('dnote_sts',$d_status),'class="form-control"'); ?>
            <?= form_error('dnote_sts');?>
            </div>
            
			<label class="col-md-2"><?=$this->lang->line('date');?></label>
            <div class="col-md-3">
                <?= form_input(array('name'=>'date','class'=>'form-control datepicker'),set_value('date',cdateFormat($srch_date))); ?>
                <?= form_error('date');?>
            </div>
            <div class="col-md-2">
            <?=form_button(array('type'=>'submit','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('search')));?>
            </div>
        </div>
    </div> 
        
	</div>
</div>
<?= form_close(); ?>

<?php if(!empty($delivery_notes)){ ?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('my-receipt-note'); ?></h6>
</div>
<div class="panel-body">
<div class="row">
    <div class="col-md-12">
        <?= export_to_word('word/delivery_notes_word/delivery_notes/status/'.$d_status.'/date'.'/'.$srch_date); ?>
    </div>
    </div>

<div class="row">
<div class="col-md-12">
<div class='table-responsive'>
<table class="table table-bordered table-striped">
<thead>
<tr class="bg-success">
<th>#</th>
<th><?= $this->lang->line('bill-no'); ?></th>
<th><?= $this->lang->line('bill-date'); ?></th>
<th><?= $this->lang->line('net-amount'); ?></th>
<!--<th><?php //$this->lang->line('payment-mode');?></th>-->
<th><?= $this->lang->line('status'); ?></th>
<th><?= $this->lang->line('view'); ?></th>
<th><?= $this->lang->line('receipt-note'); ?></th>
</tr>
</thead>

<?php
foreach($delivery_notes as $key=>$dnote){

	$bill_status = ($dnote['bill_status'] == 0 || $dnote['bill_status'] == 1)?'<span class="pending">'.$this->lang->line('pending').'</span>':'<span class="approved">'.$this->lang->line('approved').'</span>';
	?>
    <tr>
    <td class="text-center"><?= $count++; ?></td>
    <td><?= $dnote['bill_no']; ?></td>
    <td class="text-center	"><?= dateFormat($dnote['bill_date']); ?></td>
    <td class="text-right"><?= numberFormat(get_rounded($dnote['amount'])); ?></td>
<!--    <td><?php //$dnote['payment_mode']; ?></td>-->
    <td><?= $bill_status; ?></td>
    <td class="text-center">
		<a href="javascript:void();" class="view-delivery-note" id="<?= $dnote['id']; ?>" data-toggle="modal" data-target="#large_modal" title="<?= $this->lang->line('view'); ?>"><i class="glyphicon icon-zoom-in"></i></a> 
    </td>
    <?php 
	if($dnote['bill_status'] != 2){
		app_table_links($dnote['id'],array(476));
	}else{
		?><td class="text-center"><a href="javascript:void();" data-placement="left" title="<?= $this->lang->line('delivery-receipt-converted'); ?>"><i class="icon-box-add"></i></a></td> <?php
	}?>
    </tr>
    <?php
} ?>
</table>
</div>
</div>
</div>

<div class="row">
<div class="col-md-12">
<div class="pagination"><?= $links; ?></div>
</div>
</div>


</div>
</div>
<?php } ?>