<?= form_open(base_url('my_bills/purchase_bills')); ?>
<div class="panel panel-primary">
<div class="panel-heading"><h6 class="panel-title"><i class="icon-database"></i><?=$this->lang->line('search');?></h6></div>
    <div class="panel-body">
    
    <div class="form-group">
        <div class="row">
            <label class="col-md-2"><?= $this->lang->line('payment-mode'); ?></label>
            <div class="col-md-3">
            <?= form_dropdown('payment_mode',$payment_modes,set_value('payment_mode',$p_mode),'class="form-control"'); ?>
            <?= form_error('payment_mode');?>
            </div>
            
			<label class="col-md-2"><?=$this->lang->line('date');?></label>
            <div class="col-md-3">
                <?= form_input(array('name'=>'date','class'=>'form-control datepicker'),set_value('date',cdateFormat($srch_date))); ?>
                <?= form_error('date');?>
            </div>
            <div class="col-md-2">
            <?=form_button(array('type'=>'submit','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('search')));?>
            </div>
        </div>
    </div> 
        
	</div>
</div>
<?= form_close(); ?>

<?php if(!empty($purchase_report)){ 
	$customerType = $purchase_report[key($purchase_report)]['customer_type'];
?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('my-purchases'); ?></h6>
</div>
<div class="panel-body">
<div class="row">
    <div class="col-md-12">
        <?= export_to_word('word/purchase_bills_word/purchase_bills/'.$this->uri->assoc_to_uri(array_filter(array('payment_mode'=>$p_mode,'date'=>$srch_date)))); ?>
    </div>
    </div>

<div class="row">
<div class="col-md-12">
<div class='table-responsive'>
<table class="table table-bordered table-striped">
<thead>
<tr class="bg-success">
<th>#</th>
<th><?= $this->lang->line('bill-no'); ?></th>
<th><?= $this->lang->line('bill-date'); ?></th>
<th><?= $this->lang->line('net-amount'); ?></th>
<th><?=$this->lang->line('payment-mode');?></th>
<th><?= $this->lang->line('view'); ?></th>
<?php if($customerType != 3){ ?>
<th><?= $this->lang->line('status'); ?></th>
<th><?= $this->lang->line('purchase'); ?></th>
<?php } ?>
</tr>
</thead>

<?php
foreach($purchase_report as $key=>$purchase){
		$bill_status = ($purchase['bill_status'] == 0 || $purchase['bill_status'] == 1)?'<span class="pending">'.$this->lang->line('pending').'</span>':'<span class="approved">'.$this->lang->line('approved').'</span>';

	?>
    <tr>
    <td class="text-center"><?= $count++; ?></td>
    <td><?= $purchase['bill_no']; ?></td>
    <td class="text-center	"><?= dateFormat($purchase['bill_date']); ?></td>
    <td class="text-right"><?= numberFormat(get_rounded($purchase['amount'])); ?></td>
    <td><?= $purchase['payment_mode']; ?></td>
    <td class="text-center">
		<a href="javascript:void();" class="view-bill" id="<?= $purchase['id']; ?>" data-toggle="modal" data-target="#large_modal" title="<?= $this->lang->line('view'); ?>"><i class="glyphicon icon-zoom-in"></i></a> 
    </td>    
    <?php if($customerType != 3){ ?>
    	<td><?= $bill_status; ?></td>
		<?php 
        if($purchase['bill_status'] != 2){
            app_table_links($purchase['id'],array(464));
        }else{
            ?><td class="text-center"><a href="javascript:void();" title="<?= $this->lang->line('sales-purchase-converted'); ?>"><i class="icon-box-add"></i></a></td> <?php
        }?>
    <?php } ?>
    </tr>
    <?php
} ?>
</table>
</div>
</div>
</div>

<div class="row">
<div class="col-md-12">
<div class="pagination"><?= $links; ?></div>
</div>
</div>


</div>
</div>
<?php } ?>