<?= form_open();$disabled='disabled';
if(!empty($payments)){
	$receiptDetails = $payments[0];
	$receiptID = $receiptDetails['id'];
	$bill_no = $receiptDetails['bill_no'];
	$bill_date = $receiptDetails['bill_date'];
	$payment_mode = $receiptDetails['payment_mode'];
	$cash_type = $receiptDetails['cash_type'];
	$ledger_name = $receiptDetails['ledger_name'];
	$cheque_no = $receiptDetails['cheque_no'];
	$cheque_date = $receiptDetails['cheque_date'];
	$narration = $receiptDetails['narration'];
	$args = array();
	$args['return'] = 1;
	$args['conditions'] = array('id'=>$receiptDetails['customer_id']);
	$vendorDetails = $this->stock->get_vendors($args);

	$uriString=NULL;
	if($this->uri->uri_to_assoc(3)){
		$uriArray = $this->uri->uri_to_assoc(3);
		$uriString = $this->uri->assoc_to_uri($uriArray);
	}else{
		$uriString = $from_date.'/'.$to_date;
	}
	?>
	<div class="panel panel-primary">
        <div class="panel-heading">
        	<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('payment-against-bill'); ?> </h6>
        </div>
        <div class="panel-body">
		<div class="row">
        	<div class="col-md-12">
            	<?= app_export_menus($receiptID.'/'.$uriString,array(396)); ?>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('bill-no');?></label>
                    <?= form_input(array('name'=>'bill_no','class'=>'form-control number text-right required'),set_value('bill_no',$bill_no),"$disabled"); ?>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-6">
                    <label class=""><?=$this->lang->line('bill-date');?></label>
                    <?= form_input(array('name'=>'bill_date','class'=>'form-control datepicker required'),set_value('bill_date',cdateFormat($bill_date)),"$disabled"); ?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="requiread col-md-2">
                	<label><?= $this->lang->line('vendor'); ?></label>
                </div>
                <div class="col-md-10 ">
                	<div class="text-bold"><?= $vendorDetails['name']; ?></div>
                	<div class=""><?= $vendorDetails['address']; ?> <?= (!empty($vendorDetails['pincode']))?$vendorDetails['pincode']:''; ?></div>
                	<div class=""><?= $vendorDetails['phone']; ?> <?= $vendorDetails['email']; ?></div>
                </div>
            </div>
        </div>

		<?php if(!empty($payments)){?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                    <table class="table table-bordered table-striped">
                    <thead>
                    <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('bill-no'); ?></th>
                    <th><?= $this->lang->line('bill-date'); ?></th>
                    <th><?= $this->lang->line('bill-amount'); ?></th>
                    <th><?= $this->lang->line('previous-payments'); ?></th>
                    <th><?= $this->lang->line('current-payment'); ?></th>
                    <th><?= $this->lang->line('discount'); ?></th>
                    <th><?= $this->lang->line('balance-amount'); ?></th>
                    </tr>
                    </thead>
            		<?php
					$i=0;$total_bill_amount=$total_paid_amount=$total_received_amount=$total_balance_amount=$total_discount_amount=0;
					foreach($payments as $key=>$payment){$i++;

						$previous_receipts=$bill_amount=$received_amount=$paid_amount=0;
						$purchase_bill = $this->payment_ab_lib->get_purchase_bill($payment['ps_id']);
						$bill_amount = get_rounded($purchase_bill['bill_amount']);

						$received_amount = $payment['received_amount'];
						$condition = array('dvab.bill_date <='=>$payment['bill_date'],'dvab.bill_no <='=>$payment['bill_no']);
						$paid_amount = $this->payment_ab_lib->get_bill_payment($payment['ps_id'],$condition);
						if($paid_amount >0){
							$previous_receipts = $paid_amount-$received_amount;
						}
						$balance_amount = $bill_amount-($paid_amount);
						$receipt_discount = $payment['discount'];

						$total_bill_amount += $bill_amount;
						$total_paid_amount += $previous_receipts;
						$total_received_amount += $received_amount;
						$total_balance_amount += $balance_amount;
						$total_discount_amount += $receipt_discount;
						?>
                        <tr>
                        <td class="text-center"><?= $i; ?></td>
                        <td><?= $payment['purchase_bill_no']; ?></td>
                        <td><?= dateFormat($payment['purchase_bill_date']); ?></td>
                        <td class="text-right"><?= numberFormat($bill_amount); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($previous_receipts)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($received_amount)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($receipt_discount)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($balance_amount)); ?></td>
                        </tr>
                        <?php
					}?>
                    <tr>
                    <td colspan="3" class="text-right text-bold">Total</td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($total_bill_amount)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($total_paid_amount)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($total_received_amount)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($total_discount_amount)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($total_balance_amount)); ?></td>
                    </tr>
                    </table>
            		</div>
        		</div>
    		</div>
		</div>
		<?php
       $cash_type0 = true;$cash_type1 = false;
        if($cash_type > 0){
            $cash_type1 = true;
            $cash_type0 = false;
        }
        ?>
        <div class="form-group">
                <div class="row">
                    <label class="col-md-3"><?= $this->lang->line('payment-mode'); ?></label>
                    <div class="col-md-2">
                        <?= form_radio('receipt_mode','0',set_radio('receipt_mode','0',$cash_type0),'class="receipt-mode" disabled'); ?>
                        <label><?= $this->lang->line('cash'); ?></label>
                    </div>
                    <div class="col-md-2">
                        <?= form_radio('receipt_mode','1',set_radio('receipt_mode','1',$cash_type1),'class="receipt-mode" disabled'); ?>
                        <label><?= $this->lang->line('bank'); ?></label>
                    </div>
                </div>
            </div>
		<?php
		$disPDC = 'disabled="disabled"';
		if($this->input->post('receipt_mode') && $this->input->post('receipt_mode')>0){
			$disPDC = NULL;
		}
		if($cash_type == 0){$ledger_name = NULL;}
		?>
        <div class="form-group">
            <div class="row">
                <div class="col-md-12">
					<?= form_input(array('name'=>'bank','class'=>'form-control'),set_value('',$ledger_name),$disPDC); ?>
                    <?= form_error('payment_mode');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('transaction-type');?></label>
                    <?php $transaction_types = $this->dms->transaction_types();?>
                    <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$cash_type),"class='form-control pdc' $disPDC"); ?>
                    <?=form_error('ccd');?>
                </div>
                <div class="col-md-4">
                    <label class="pdcl"><?=$this->lang->line('cd-no');?></label>
                    <?= form_input(array('name'=>'cheque_no','class'=>'form-control number pdc'),set_value('cheque_no',$cheque_no),$disPDC); ?>
                    <?= form_error('cheque_no');?>
                </div>
                <div class="col-md-4">
                    <label class="pdcl"><?=$this->lang->line('cheque-date');?></label>
                    <?= form_input(array('name'=>'cheque_date','class'=>'form-control pdc required'),set_value('cheque_date',cdateFormat($cheque_date)),$disPDC); ?>
                    <?= form_error('cheque_date');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class="col-md-3"><?= $this->lang->line('narration'); ?></label>
                <div class="col-md-9">
					<?= form_textarea(array('name'=>'narration','class'=>'form-control','rows'=>3),set_value('narration',$narration),$disPDC); ?>
                    <?= form_error('narration');?>
                </div>
            </div>
        </div>
		<?php
		}
		?>
	</div>
</div>
<?php
}
?>
<?= form_close(); ?>