<?php if(!empty($counters)) { ?>
<div class="row">
	<div class="col-sm-12">
		<div class="panel panel-primary">
			<div class="panel-heading">
            	<h6 class="panel-title"><i class="icon-home"></i>
					<?=$this->lang->line('retailers');?>
				</h6>
			</div>
			<div class="panel-body">
				<div class="row">
				    <div class="col-md-12">
        				<?= export_to_word('word/retailers_word/retailers/'); ?>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12 block">
						<div class="table-responsive">
                        <table class="table table-bordered table-striped table-condensed">
                        <thead class="bg-success">
                        <th>#</th>
                        <th><?=$this->lang->line('name');?></th>
                        <th><?=$this->lang->line('short-name');?></th>
                        <th><?=$this->lang->line('tin-no');?></th>
                        <th><?=$this->lang->line('gstn');?></th>
                        <th><?=$this->lang->line('mobile');?></th>
                        <th><?=$this->lang->line('email');?></th>
                        <th><?=$this->lang->line('credit-limit');?></th>
                        <th><?=$this->lang->line('address');?></th>
                        <th class="text-center" colspan="3"><?= $this->lang->line('actions'); ?></th>
                        </thead>

						<?php foreach($counters as $counter):?>

                            <tr>
                            <td><?=++$count;?></td>
                            <td><?=$counter['retailer_name'];?></td>
                            <td><?=$counter['retailer_short_name'];?></td>
                            <td><?=$counter['tin_no'];?></td>
                            <td><?=$counter['gstn'];?></td>
                            <td><?=$counter['retailer_mobile'];?></td>
                            <td><?=$counter['retailer_email'];?></td>
                            <td><?=$counter['credit_limit'];?></td>
                            <td><?= getTrim($counter['retailer_address']);?></td>
                            <td class="text-center">
                                <a href="#" class="show-retailer" title="<?=$this->lang->line('more-details');?>" data-toggle="modal" data-target="#large_modal"  data-id="<?=$counter['id'];?>">
                                    <i class="icon-zoom-in"></i>
                                </a>
                            </td>
                            <?php app_table_links($counter['id'],array(31,32));?>
                            </tr>
						<?php endforeach;?>
						</table>
                        </div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
    	<div class="pagination"><?=$links;?></div>
    </div>
</div>
<?php } ?>