<?= form_open(); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title">
            <i class="icon-database"></i><?=$this->lang->line('open-stock-details');?>
        </h6>
    </div>
	<div class="panel-body">

        <div class="form-group">
            <div class="row">
                <label class="required col-md-2"><?=$this->lang->line('item-name');?></label>
                <div class="col-md-8">
                	<?php $this->load->view('products/select');?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="row">
                <label class="required col-md-2"><?=$this->lang->line('opening-date');?></label>
                <div class="col-md-8">
					<?php $fiscalStartDate = $this->dms->get_fiscal_year()['start_date']; ?>
                    <?= form_input(array('name'=>'opening_date','class'=>'form-control','value'=>dateFormat($fiscalStartDate),'readonly'=>true)); ?>
                </div>
            </div>
        </div>

	<?php if(!empty($godowns)){ ?>
    <?=form_error('check');?>	
        <div class='table-responsive'>
            <table class="table table-bordered table-striped">
            <thead>
            <tr class="bg-success">
            <th>#</th>
            <th><input type="checkbox" class="check-main styled"></th>
            <th>Godown</th>
            <th>Qty.</th>
            <th>Unit</th>
            <th>Rate</th>
            </tr>
            </thead>
            <?php
            $i=0;
            foreach($godowns as $key=>$goDown){$i++;
                $goDownID = $goDown['id'];
                $checkSts = false;
                if(in_array($goDownID,$checkedItems)){
                    $checkSts = true;
                }
                ?>
                <tr>
                <td class="text-center"><?= $i; ?></td>
                <td class="text-center"><?= form_checkbox(array('name'=>'check[]','value'=>$goDownID,'class'=>'item-check check-child styleds','id'=>$goDownID,'checked'=>$checkSts)); ?></td>
                <td><?= $goDown['godown_code']; ?> <?= $goDown['godown_name']; ?> - <?= $goDown['branch_name']; ?></td>
                <td>
                    <?=form_input(array('name'=>'qty'.$goDownID,'class'=>'form-control text-right'),set_value('qty'.$goDownID));?>
                    <?= form_error('qty'.$goDownID); ?>
                </td>
                <td><div class="unit_name"><span title="<?= $unit_name ?>"><?= $unit_symbol; ?></span></div></td>
                <td>
                    <?=form_input(array('name'=>'rate'.$goDownID,'class'=>'form-control text-right'),set_value('rate'.$goDownID));?>
                    <?= form_error('rate'.$goDownID); ?>
                </td>
                </tr>
                <?php
            }?>
            </table>
        </div>
    
        <div class="form-group">
            <div class="text-right">
                <?=form_button(array('type'=>'submit','class'=>'btn btn-primary pull-right btn-loading','content'=>$this->lang->line('save')));?>
            </div>	
        </div>
    <?php } ?>
	</div>
</div>
<?= form_close(); ?>