<?= export_to_excel('excel/purchase_excel/purchase_registry'.$redirect); ?>
<div class="table-responsive block">
	<table class="table table-striped table-condensed table-bordered tbl-brdr">
		<tr class="bg-success">
			<th>Sl.No.</td>
			<th><?=$this->lang->line('date');?></th>
    		<th><?=$this->lang->line('particulars');?></th>
    		<th><?=$this->lang->line('voucher-types');?></th>
    		<th><?=$this->lang->line('voucher-no');?></th>
			<th><?=$this->lang->line('invoice-no');?></th>      			
			<th><?=$this->lang->line('taxable');?></th>			
     	    <th><?=$this->lang->line('vat')." ".$this->lang->line('amt');?></th>
     		<th><?=$this->lang->line('cess')." ".$this->lang->line('amt');?></th>
     		<th><?=$this->lang->line('gross_total');?></th>     			
        </tr>
<?php
			$TOTAL_TAXABLE_AMT=0; $TOTAL_TAX_AMT=0; $TOTAL_CESS_AMT=0; $TOTAL_GROSS=0;

			foreach($purchase_array as $key => $value):
				$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
				$total_taxable=0; $total_tax=0; $total_cess=0; $presum_amount = 0; $total_amount=0;
				
             	$item_details = $this->purchase_obj->get_purchase_items(array('columns' => array('item_id','unit_id','qty','rate','amount','discount_amt','taxable_amt','vat_amt','cess_amt'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
        
				foreach($item_details as $item_key => $item_value):
									
					$taxable = $item_value['taxable_amt'];
                 	$vat_amt = $item_value['vat_amt'];
                 	$cess_amt = $item_value['cess_amt'];  
                 	$amount = $taxable+$vat_amt+$cess_amt;
                			
                    $total_taxable += $taxable;
                	$total_tax += $vat_amt;
					$total_cess += $cess_amt;
					$total_amount += $amount;
				endforeach;
				
				if(!empty($presumptive_tax)){
					$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
					$total_amount += $presum_amount;
				}
				
				$total_amount += (($value['bill_freight']+$value['other_expense']+$value['courier_charge'])-$value['bill_discount_amt']);

                $TOTAL_TAXABLE_AMT += $total_taxable;
                $TOTAL_TAX_AMT += $total_tax;
                $TOTAL_CESS_AMT += $total_cess;
                $TOTAL_GROSS += $total_amount;
?>
				<tr>
				    <td class="text-center"><?=++$offset;?></td>
				    <td class="text-center date"><?=dateFormat($value['bill_date']);?></td>
				    <td><?=$this->stock->vendor_name($value['vendor_id']);?></td>
				    <td><?=$value['vtype'];?></td>
				    <td><?=$bill_prefix.' '.$value['bill_no'];?></td>
				    <td><?=$value['invoice_no'];?></td>					
        			<td class="text-right"><?=numberFormat($total_taxable);?></td>        				
    				<td class="text-right"><?=numberFormat($total_tax); ?></td> 
    				<td class="text-right"><?=numberFormat($total_cess); ?></td>  
    				<td class="text-right"><?=numberFormat($total_amount); ?></td>   
				</tr>
<?php 
			endforeach;
?>
		<tr>
			<th colspan="6" class="text-right disabled" >Grant Total</th>
			<th class="text-right disabled"><?=numberFormat($TOTAL_TAXABLE_AMT); ?></td>
			<th class="text-right disabled"><?=numberFormat($TOTAL_TAX_AMT); ?></td>		
			<th class="text-right disabled"><?=numberFormat($TOTAL_CESS_AMT); ?></td>
            <th class="text-right disabled"><?=numberFormat($TOTAL_GROSS); ?></td>
		</tr> 
	</table>
</div>

<!--pagination-->
<div class="row">
	<div class="col-md-12">
		<div class="pagination"><?=$links;?></div>
	</div>
</div>