<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("view")." ".$this->lang->line("bill"); ?></h6>
	</div>
	<div class="panel-body">
		<?php $bill_prefix = $this->stock->get_voucher_prefix($purchase_array[0]['vtype_id']); ?>
		<div class="row">
    	    <div class="col-md-12">
        		<?php app_export_menus('id/'.$purchase_array[0]['primary_id'],452);?>
    		</div>
		</div>

		<div class="form-group">
			<div class="row">
		    	<div class="col-md-4">
		        	<label><?=$this->lang->line('voucher-types');?></label>
		        	<input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
		    	</div>
    			<div class="col-md-4">
        			<label><?=$this->lang->line('bill-no');?></label>
        			<div class="input-group">
            			<span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
            			<input type="text" class="form-control" disabled value="<?=$purchase_array[0]['bill_no'];?>">
        			</div>
    			</div>
    			<div class="col-md-4">
        			<label><?=$this->lang->line('bill-date');?></label>
        			<input type="text" class="form-control" disabled value="<?=dateFormat($purchase_array[0]['bill_date']);?>">
    			</div>
			</div>
		</div>

		<div class="form-group">
    		<div class="row">
        		<div class="col-md-4">
            		<label><?=$this->lang->line('invoice-no');?></label>
            		<input type="text" class="form-control" disabled value="<?=$purchase_array[0]['invoice_no'];?>">
        		</div>
        		<div class="col-md-4">
            		<label><?=$this->lang->line('invoice-date');?></label>
            		<input type="text" class="form-control" disabled value="<?=dateFormat($purchase_array[0]['invoice_date']);?>">
        		</div>
        		<div class="col-md-4">
            		<label><?=$this->lang->line('vendor');?></label>
            		<input type="text" class="form-control" disabled value="<?=$vendor_name;?>">
        		</div>
    		</div>
		</div>

		<div class="row">
			<div class="col-md-12">
    			<div class='table-responsive'>
    				<table class="table table-bordered table-striped">
    					<thead>
    					<tr class="bg-success">
    						<th>#</th>
    						<th><?= $this->lang->line('item-name');?></th>
    						<th><?= $this->lang->line('quantity');?></th>
    						<th><?= $this->lang->line('rate'); ?></th>
    						<th><?= $this->lang->line('amount'); ?></th>
    						<th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
    						<th><?= $this->lang->line('taxable'); ?></th>
                            <th><?= $this->lang->line('vat'); ?> (%)</th>
               				<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
              				<th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
    						<th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    					</tr>
    					</thead>
<?php					    					
    					$i=0; $totalAmount=0; $totalDiscountAmt=0; $totalTaxable=0; $totalVatAmt=0; $totalCessAmt=0; $totalNetAmount=0; $total_qty=0;
    					$a=10; $b=8;
    					$grandNetAmount=0; $total_cst_amount = 0;
					    $cess = $purchase_array[0]['cess'];
    					foreach($purchase_array as $key => $item)
    					{
					        $i++;
					        $itemID = $item['item_id'];
					        $item_details = $this->stock->get_item($itemID,array('item_code','item_name','model_no'));
					        $qty = $item['qty'];
					        $rate = $item['rate'];
					        $discount_per = $item['discount_per'];
					        $discount_amt = $item['discount_amt'];
					        $cst_percent = $item['cst'];
					        $vat=0; $vatAmt=0; $cst_amount=0;
					        $amount = $item['amount'];
					        $taxable = $item['taxable_amt'];
					        $totalAmount += $amount;
					        $netValue = $amount-$discount_amt;
					        
					        $vat=0; $vatAmt=0; 
                		    $vat = $item['vat'];					            				
    						$vatAmt = $item['vat_amt'];	
    						$cessAmt = $item['cess_amt'];
             					
             				$total_qty += $qty;
    				        $totalVatAmt += $vatAmt;
    				        $totalCessAmt += $cessAmt;
    				        $netAmount = $taxable+$vatAmt+$cessAmt;
            				$totalAmount += $amount;
    	    				$totalTaxable += $taxable;
    					    $totalNetAmount += $netAmount;
    					    $totalDiscountAmt += $discount_amt;
?>
        					<tr>
						        <td><?= $i; ?></td>
						        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?> /  <?= $item_details['model_no']; ?></td>
						        <td class="text-right"><?= $qty; ?></td>
						        <td class="text-right"><?= numberFormat($rate); ?></td>
						        <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
						        <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
						        <td class="text-right"><?= numberFormat(round_this($taxable)); ?></td>
                                <td class="text-right"><?= $vat; ?></td>
				                <td class="text-right"><?= numberFormat(round_this($vatAmt)); ?></td>
				                <td class="text-right"><?= numberFormat(round_this($cessAmt)); ?></td>		
        					    <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        					</tr>
<?php
    					}
    					$grandNetAmount = round_this($totalNetAmount);
?>
    					<tr>
				    		<td class="text-right text-bold" colspan="2"><?= $this->lang->line('total'); ?></td>
				    		<td class="text-right text-bold"><?= $total_qty; ?></td>
    					    <td class="disabled"></td>
				    		<td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
				    		<td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
				    		<td class="text-right text-bold"><?= numberFormat(round_this($totalTaxable)); ?></td>
					        <td class="disabled"></td>        
	          				<td class="text-right text-bold"><?= numberFormat($totalVatAmt); ?></td>
          				    <td class="text-right text-bold"><?= numberFormat($totalCessAmt); ?></td>
    						<td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    					</tr>
<?php 
    					$presumptive_tax_amt = 0;
    					if(!empty($presumptive_tax))
    					{
				    		$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
				    		$grandNetAmount += round_this($presumptive_tax_amt);
?>
    						<tr>
    							<td colspan="<?=(12-$colspan);?>" class="text-right">
    								<span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span>
    							</td>
    							<td class="text-right"><?=numberFormat($presumptive_tax_amt);?></td>
    						</tr>
<?php 
					    }
?>
    					<tr>
    						<td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
    						<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
    							<div class="row">
							        <div class="col-md-3"><input class="form-control" type="text" disabled value="<?=$payment_mode;?>"></div>
							        <div class="col-md-3"><?= $this->lang->line('credit-period');?></div>
							        <div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$purchase_array[0]['cr_period'];?>"></div>
							        <div class="col-md-3 pull-right"><?= $this->lang->line('freight');?></div>
    							</div>
    						</td>
    						<td class="text-right"><?=numberFormat(round_this($purchase_array[0]['bill_freight']));?></td>
    					</tr>
    					<tr>
						    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold">
    							<div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
    								<div class="row">
        								<div class="col-md-3">
            								<?php $transaction_types = $this->dms->transaction_types();?>
            								<?= form_dropdown('ccd',$transaction_types,set_value('ccd',$ccd),'class="form-control" disabled'); ?>
            								<?=form_error('ccd');?>
        								</div>
        								<div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
								        <div class="col-md-3">
								            <?=form_input('cd_no',set_value('cd_no',$cd_no),"class='form-control' disabled");?>
								            <?=form_error('cd_no');?>
								        </div>
        								<div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
								        <div class="col-md-2">
								        	<?=form_input('cheque_date',set_value('cheque_date',dateFormat($pdc)),"class='datepicker form-control' disabled");?>
								        	<?=form_error('cheque_date');?>
								        </div>
    								</div>
    							</div>
						    </td>
    						<td></td>
					    </tr>
    					<tr>
    						<td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    						<td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        						<div class="row">
							        <div class="col-md-9 pull-left"><textarea class="form-control" disabled><?=$purchase_array[0]['narration'];?></textarea></div>
							        <div class="col-md-3 pull-right"><?= $this->lang->line('other-expense');?></div>
							    </div>
    						</td>
    						<td class="text-right"><?=numberFormat(round_this($purchase_array[0]['other_expense']));?></td>
    					</tr>
<?php
					    $grandNetAmount += (($purchase_array[0]['bill_freight']+$purchase_array[0]['other_expense'])-$purchase_array[0]['bill_discount_amt']+$purchase_array[0]['courier_charge']+$purchase_array[0]['courier_gst']);

    					if(show_round_off())
    					{ 
?>
    					    <tr>
    							<td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
    								<div class="row">
        								<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
    								</div>
    							</td>
    							<td class="text-right text-bold">
    								<div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
    							</td>
    						</tr>
<?php 
					    }
?>
					    <tr>
    						<td class="text-right text-bold" colspan="2"></td>
    						<td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
    							<div class="row">
	        						<div class="col-md-9 pull-left"></div>
	        						<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('courier-charge');?></div>
	    						</div>
    						</td>
    						<td class="text-right">
    							<div class="col-md-12"><?= form_input(array('name'=>'courier_charge','class'=>'form-control tot_cour_amt text-right decimal','disabled'=>'disabled'),set_value('courier_charge',$purchase_array[0]['courier_charge'])); ?><?=form_error('tot_cour_amt');?></div>
						    </td>
    					</tr>
    					<tr>
    						<td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
    						<td class="text-right text-bold" colspan="<?=($b-$colspan);?>">
    							<div class="row">
        							<div class="col-md-3 pull-left"><input class="form-control text-right" type="text" disabled value="<?=$purchase_array[0]['bill_discount_per'];?>"></div>
						        	<div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
						        	<div class="col-md-3"><input class="form-control text-right" type="text" disabled value="<?=$purchase_array[0]['bill_discount_amt'];?>"></div>
						        	<div class="col-md-3 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    							</div>
    						</td>
    						<td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    					</tr>
    				</table>
    			</div>

    			<div class="row">
    				<div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($purchase_array[0]['created_by']);?></div>
    				<div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($purchase_array[0]['created_on']);?></div>
    			</div>
		    </div>
	    </div>
    </div>
</div>