<?= form_open();
if(!empty($purchase_orders)){
	$l_date = '2017-07-01';
	$po_date = $vendor_id = NULL;$disabled = 'disabled';
	$po_details = $purchase_orders[0];
	$po_no = $po_details['po_no'];
	$purchaseOrderID = $po_details['id'];
	$po_date = $po_details['po_date'];
	$vendor_id = $po_details['vendor_id'];
	$vendorName = $po_details['vendor_name'];
	$po_status = $po_details['po_status'];
	$po_discount_amt = $po_details['po_discount_amt'];
	$po_discount_per = $po_details['po_discount_per'];
	$po_remarks = $po_details['remarks'];
	$cess = $po_details['cess'];
	$presumtiveTax = $this->stock->get_tax_type();
	$offset = ($this->uri->segment(4))?$this->uri->segment(4):NULL;
	$uriArray = $this->uri->uri_to_assoc(4);
	$uriString = $this->uri->assoc_to_uri($uriArray);
	$bill_prefix = $this->stock->get_voucher_prefix(-2);
	?>
	<div class="panel panel-primary">
		<div class="panel-heading">
			<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('purchase-order'); ?> </h6>
		</div>

		<div class="row">
        	<div class="col-md-12">
            	<?php app_export_menus($purchaseOrderID.'/'.$uriString,array(345)); ?>
            </div>
        </div>
		<div class="panel-body">

            <div class="form-group">
                <div class="row">
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('po-no');?></label>
                        <div class="input-group">
                            <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                            <?= form_input(array('name'=>'po_no','class'=>'form-control number text-right'),set_value('po_no',$po_no),"$disabled"); ?>
                        </div>
                        <?= form_error('po_no');?>
                    </div>
                    <div class="col-md-6">
                        <label class=""><?=$this->lang->line('po-date');?></label>
                        <?= form_input(array('name'=>'po_date','class'=>'form-control datepicker'),set_value('po_date',cdateFormat($po_date)),"$disabled"); ?>
                        <?= form_error('po_date');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <label class="requiread col-md-2"><?= $this->lang->line('vendor'); ?></label>
                    <div class="col-md-10">
						<?= form_input(array('name'=>'vendor','class'=>'form-control'),set_value('po_date',$vendorName),"$disabled"); ?>
                        <?= form_error('vendor_id');?>
                    </div>
                </div>
            </div>

			<?php if(!empty($purchase_orders)){	?>
                <div class="form-group">
					<div class="row">
                		<div class="col-md-12">
    						<div class='table-responsive'>
                            <table class="table table-bordered table-striped">
                            <thead>
                            <tr class="bg-success">
                            <th>#</th>
                            <th><?=$this->lang->line('item-name');?></th>
                            <th><?=$this->lang->line('quantity');?></th>
                            <th><?= $this->lang->line('unit'); ?></th>
                            <th><?= $this->lang->line('rate'); ?></th>
                            <th><?= $this->lang->line('amount'); ?></th>
                            <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
							<?php 
								if($po_date <$l_date)
								{
									$a=7;
									if(!empty($cst_enabled) && empty($presumtiveTax))
									{ 
							?>
                                		<th><?= $this->lang->line('cst'); ?></th>
                            <?php 
									} 
							?>
                            <?php 
									if(empty($presumtiveTax))
									{ 
							?>
                            			<th><?= $this->lang->line('vat'); ?> (%)</th>
                           				<th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
                            <?php 
									} 
								}
								else
								{
									$a=9;
							?>	
                            		<th><?= $this->lang->line('cgst'); ?> (%)</th>
                                    <th><?= $this->lang->line('sgst'); ?> (%)</th>
                           			<th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
                           			<th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>	
							<?php		
								}
							?>
                            <th><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                            </tr>
                            </thead>
							<?php
							$i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;$grandNetAmount=0;$totalCst=0;	$cst=0;
							$count=$totalAmount=$totalDiscountAmt=$totalVatAmount=$totalNetAmount=0;
							foreach($purchase_orders as $key=>$po_item){ $count++;
								$tempItemID = $po_item['dpi_id'];
								$vatAmount=$vat=$amount=$netAmount=0;
								$itemID = $po_item['item_id'];
								$qty = $po_item['qty'];
								$rate = $po_item['rate'];
								$cstPercent = $po_item['cst'];
								$discountPer = $po_item['discount_per'];
								$discountAmt = $po_item['discount_amt'];
								$vatAmount=0;$cstAmount=0;$vat=0;
								if($po_date <$l_date)
								{
									if($cstPercent == 0)
									{
										$vat = $this->stock->get_item_vat($itemID);
									}
									else
									{
										$cst=1;
									}
									$cstAmount = ($cstPercent*$netValue)/100;
									if(empty($presumtiveTax))
									{
										$vatAmount = $po_item['vat_amt'];//($vat*$netValue)/100;
									}
									else
									{
										$cstAmount=0;
									}
									$totalCst += $cstAmount;
									$netValue += $cstAmount;
								}
								else
								{
									$cgst = $this->stock->get_item_cgst($itemID);
									$sgst = $this->stock->get_item_sgst($itemID); 
									$cgstAmt = 	$po_item['cgst_amt'];
									$sgstAmt = 	$po_item['sgst_amt'];
									$vatAmount = $cgstAmt + $sgstAmt;
								}
								$amount = $po_item['amount'];
								$totalAmount += $amount;
								$totalDiscountAmt += $discountAmt;
								$netValue = $amount-$discountAmt;
								$totalNetValue += $netValue;					
								$totalVatAmount += $vatAmount;
								$netAmount = $netValue+$vatAmount;
								$totalNetAmount += $netAmount;
								
								?>
                                <tr>
                                <td class="text-center"><?= $count; ?></td>
                                <td><?= $po_item['item_code']; ?> / <?= $po_item['item_name']; ?></td>
                                <td class="text-right"><?= $qty; ?></td>
                                <td class="text-right"><?= $po_item['symbol']; ?></td>
                                <td class="text-right"><?= numberFormat($rate); ?></td>
                                <td class="text-right"><?= numberFormat(round_this($amount)); ?></td>
                                <td class="text-right"><?= numberFormat(round_this($discountAmt)); ?></td>
								<?php 
									if($po_date < $l_date)
									{
										if(!empty($cst_enabled) && empty($presumtiveTax))
										{ 
								?>
											<td class="text-right"><?= numberFormat(round_this($cstAmount)); ?></td>
								<?php 
										} 
								?>
                                <?php 
										if(empty($presumtiveTax))
										{ 
								?>
                                		    <td class="text-right"><?= $vat; ?></td>
                                    		<td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
                                <?php 
										}
									}
									else
									{
								?>
                                		<td class="text-right"><?= $cgst; ?></td>
                                        <td class="text-right"><?= $sgst; ?></td>
                                    	<td class="text-right"><?= numberFormat(round_this($cgstAmt)); ?></td>
                                    	<td class="text-right"><?= numberFormat(round_this($sgstAmt)); ?></td>
                                <?php		
									}
								?>
                                		<td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                                		</tr>
							<?php 	}?>
                            <tr>
                            <td colspan="5" class="text-right text-bold"><?= $this->lang->line('total'); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalAmount)); ?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
                            <?php 
								if($po_date < $l_date)
								{
									if(!empty($cst_enabled) && empty($presumtiveTax))
									{ 
							?>
    		                        	<td class="text-right text-bold"><?= numberFormat(round_this($totalCst)); ?></td>
                            <?php 
									} 
							?>
                            <?php 
									if(empty($presumtiveTax))
									{ 
							?>
                            			<td class="disabled"></td>
                            			<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmount)); ?></td>
                            <?php 
									} 
								}
								else
								{
							?>	
                            		<td class="disabled"></td>
                                    <td class="text-right text-bold" colspan="2">GST Amt.</td>
                            		<td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmount)); ?></td>	
							<?php		
								}
							?>
                           			<td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                            		</tr>
							<?php
							$gnTotalVatAmount=$totalVatAmt;
							$pCol =2;
							if(!empty($presumtiveTax)){
								$pCol=0;
								$pmTaxAmt = ($presumtiveTax[0]*$totalNetAmount)/100;
								$gnTotalVatAmount = round_this($pmTaxAmt);
								$totalNetAmount += round_this($pmTaxAmt);
								?>
                                <tr>
                                	<td class="text-right text-bold" colspan="<?= $a+$pCol+$cst; ?>"><?= $this->lang->line('presum-tax') ?> @ <?= $presumtiveTax[0]; ?> %</td>
                                	<td class="text-right text-bold"><?= numberFormat(round_this($pmTaxAmt)); ?></td>
                                </tr>
							<?php
							}
							$cessAmount=0;
							$cessAmount = ($cess*($gnTotalVatAmount+$totalCst))/100;
							$totalNetAmount += round_this($cessAmount);
							?>
                            <tr>
                            <td class="text-right text-bold" colspan="<?= $a+$pCol+$cst; ?>"><?= $this->lang->line('cess');?> @ <?= $cess; ?> %</td>
                            <td class="text-right text-bold"><?= numberFormat($cessAmount); ?>
                            <input type="hidden" id="gnTotalAmt" value="<?= ($totalNetAmount); ?>">
                            </td>
                            </tr>
           					<?php $totalNetAmount -= $po_discount_amt; ?>
                            <?php if(show_round_off()){ ?>
                            <tr>
                            <td class="text-right text-bold" colspan="<?= $a+$pCol+$cst; ?>"><?= $this->lang->line('round-off');?></td>
                            <td class="text-right text-bold"><?= numberFormat(round_off($totalNetAmount)); ?></td>
                            </tr>
							<?php } ?>
                            <tr>
                            <td class="" colspan="<?= $a+$pCol+$cst; ?>">
                            <div class="row">
                                <div class="col-md-4">
                                	<label><?=$this->lang->line('discount');?> %</label>
                                	<?= form_input(array('name'=>'bill_discount_per','class'=>'form-control bill_discount_per text-right decimal'),set_value('bill_discount_per',$po_discount_per),"$disabled"); ?>
                                </div>
                                <div class="col-md-4">
                                	<label><?=$this->lang->line('discount');?> <?=$this->lang->line('amount');?></label>
                                	<?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amt text-right decimal'),set_value('bill_discount_amt',$po_discount_amt),"$disabled"); ?>
                                </div>
                                <div class="col-md-4">
                                	<span class="text-bold pull-right"><?=$this->lang->line('net-amount');?></span>
                                </div>
                            </div>
							</td>
                            <td class="text-right text-bold">
                            	<div id="gn_net_amount"><?= numberFormat(get_rounded($totalNetAmount)); ?></div>
                            </td>
                            </tr>
							</table>
						</div>
    				</div>
    			</div>
			</div>

            <div class="form-group">
                <div class="row">
                    <label class="requiread col-md-2"><?= $this->lang->line('remarks'); ?></label>
                    <div class="col-md-10">
                        <div class="form-control"><?= $po_remarks; ?></div>
                        <?= form_error('remarks');?>
                    </div>
                </div>
            </div>
<?php	} ?>
            <div class="row">
            <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($purchase_orders[0]['created_by']);?></div>
            <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($purchase_orders[0]['created_on']);?></div>
            </div>
		</div>
    </div>
<?php } ?>
<?= form_close(); ?>