<?= form_open();?>
<?php $bill_prefix = $this->stock->get_voucher_prefix($purchase_array[0]['vtype_id']); ?>
<div class="panel panel-primary">
    <div class="panel-heading">
        <h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("edit")." ".$this->lang->line("$voucher_name")." ".$this->lang->line("bill"); ?></h6>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-4">
                    <label><?=$this->lang->line('voucher-types');?></label>
                    <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-no');?></label>
                    <div class="input-group">
                        <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
                        <?=form_input('bill_no',set_value('bill_no',$purchase_array[0]['bill_no']),"class='form-control text-right number' id='sbill-ajax'");?>
                    </div>
                    <?= form_error('bill_no');?>
                </div>
                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('bill-date');?></label>
    				<?=form_input('bill_date',set_value('bill_date',cdateFormat($purchase_array[0]['bill_date'])),"class='datepicker form-control bill-date' id='sdate-ajax'");?>
                    <?= form_error('bill_date');?>
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
            	<div class="col-md-6">
                    <label><?=$this->lang->line('invoice-no');?></label>
                    <input type="text" class="form-control" disabled value="<?=$return_bill_no;?>">
                </div>
            	<div class="col-md-6">
                    <label class="required"><?=$this->lang->line('vendor');?></label>
                    <?=form_dropdown("vendor_id",$vendors,array(),"class='form-control' disabled");?>
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('item-name');?></label>
                    <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                    <?= form_error('item_id');?>
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="row">
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('quantity');?></label>
                    <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty amount-ajax decimal'),set_value('qty')); ?>
                    <?= form_error('qty');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('unit');?></label>
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit"'); ?>
                    <?= form_error('unit_id');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('rate');?></label>
                    <?= form_input(array('name'=>'rate','class'=>'form-control text-right rate amount-ajax decimal'),set_value('rate')); ?>
                    <?= form_error('rate');?>
                </div>
                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('amount');?></label>
                    <?= form_input(array('name'=>'amount','class'=>'form-control text-right amount'),set_value('amount')); ?>
                </div>
            </div>
        </div>
        <div class="float-left"><?=$this->lang->line('stock-bal')." : ";?></div><div class="float-left text-bold marg-left-10" id="stock-balance"><?=$stock_count." ".$primary_unit;?></div>
        <div class="form-group">
            <div class="text-right">
                <?=form_submit(array('name' => 'btn_add','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('add-to-bill')));?>
            </div>
        </div>
	</div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class='table-responsive'>
            <table class="table table-bordered table-striped">
                <thead>
                <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('item-name');?></th>
                    <th><?= $this->lang->line('quantity');?></th>
                    <th><?= $this->lang->line('rate'); ?></th>
                    <th><?= $this->lang->line('dis'); ?> <?= $this->lang->line('amt'); ?></th>
                    <th><?= $this->lang->line('taxable'); ?></th>
                    <th><?= $this->lang->line('vat'); ?> (%)</th>
	                <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
            	    <th><?= $this->lang->line('cess'); ?> <?= $this->lang->line('amt'); ?></th>
                    <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
                    <th colspan='2'><?=$this->lang->line('actions');?></th>
                </tr>
                </thead>
<?php
                $i=0; $totalTaxable=0; $totalVatAmt=0; $totalCessAmt=0; $totalNetAmount=0; $totdisc_amt=0;
                $grandNetAmount=0;$total_cst_amount = 0; $a=7; $b=9;
                foreach($purchase_array as $key => $item)
                {
                    $i++;
                    $itemID = $item['item_id'];
                    $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
                    $qty = $item['qty'];
                    $rate = $item['rate'];
                    $tax_type=$item['tax_type'];
                    $discount_per = $item['discount_per'];
            		$discount_amt = $item['discount_amt'];
            		$totdisc_amt +=$discount_amt;
                    $cst_percent = $item['cst'];
                    $vat = 0;$vatAmount = 0;$cst_amount = 0;
                    $netValue = $item['amount'];
                    $taxable = $item['taxable_amt'];
                    
                    $vat = $item['vat'];
                    $vatAmt = $item['vat_amt'];
                    $cessAmt = $item['cess_amt'];
                    
                    $netAmount = $taxable+$vatAmt+$cessAmt;
                    $totalNetValue += $netValue;
                    $totalTaxable += $taxable;
                    $totalVatAmt += $vatAmt;
                    $totalCessAmt += $cessAmt;
                    $totalNetAmount += $netAmount;
?>
                    <tr>
                        <td class="text-center"><?=$i;?></td>
                        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
                        <td class="text-right"><?= $qty; ?></td>
                        <td class="text-right"><?= numberFormat($rate); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($taxable)); ?></td>
                        <td class="text-right"><?= $vat; ?></td>
                        <td class="text-right"><?= numberFormat(round_this($vatAmt)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($cessAmt)); ?></td>
                        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
                        <?php app_table_links('idu/'.$item['id'].$redirect,array(458,459));?>
                    </tr>
<?php
                }
                $grandNetAmount = round_this($totalNetAmount);
?>
                <tr>
                    <td class="text-right text-bold" colspan="4"><?= $this->lang->line('total'); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($totdisc_amt)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($totalTaxable)); ?></td>
                    <td class="disabled" align="right"></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
                    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
                    <td colspan="2" class="disabled"></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-right text-bold"><?=$this->lang->line('payment-mode');?></td>
                    <td colspan="<?=(7-$colspan);?>" class="text-right text-bold">
                    <div class="row">
                        <div class="col-md-8"><?= form_dropdown('payment_mode',$payment_modes,set_value('payment_mode',$payment_mode),'class="form-control payment-mode"'); ?><?= form_error('payment_mode');?></div>
                        <div class="col-md-4 pull-right"><?= $this->lang->line('freight');?></div>
                    </div>
                    </td>
                    <td class="text-right"><?= form_input(array('name'=>'freight','class'=>'form-control decimal text-right width-150 pull-right freight-amt'),set_value('freight',$purchase_array[0]['bill_freight'])); ?><?=form_error('freight');?></td>
                    <td colspan="2" class="disabled"></td>
                </tr>
                <tr>
                	<td colspan="<?=(9-$colspan);?>" class="text-right text-bold">
                        <div class="cd-ajax <?php if($cd_status){?>hide<?php }?>">
                            <div class="row">
                                <div class="col-md-3">
                                    <?php $transaction_types = $this->dms->transaction_types();?>
                                    <?= form_dropdown('ccd',$transaction_types,set_value('ccd',$ccd),'class="form-control"'); ?>
                                    <?=form_error('ccd');?>
                                </div>
                                <div class="col-md-2"><label><?=$this->lang->line('cd-no');?></label></div>
                                <div class="col-md-3">
                                    <?=form_input('cd_no',set_value('cd_no',$cd_no),"class='form-control'");?>
                                    <?=form_error('cd_no');?>
                                </div>
                                <div class="col-md-2"><label><?=$this->lang->line('cheque-date');?></label></div>
                                <div class="col-md-2">
                                    <?=form_input('cheque_date',set_value('cheque_date',cdateFormat($pdc)),"class='datepicker form-control'");?>
                                    <?=form_error('cheque_date');?>
                                </div>
                            </div>
                        </div>
                	</td>
                    <td></td>
                    <td colspan="2" class="disabled"></td>
            	</tr>
                <tr>
                    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
                    <td colspan="<?=(7-$colspan);?>" class="text-right text-bold">
                        <div class="row">
                            <div class="col-md-8 pull-left"><?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks',$purchase_array[0]['narration'])); ?><?=form_error('remarks');?></div>
                            <div class="col-md-4 pull-right"><?= $this->lang->line('other-expense');?></div>
                        </div>
                    </td>
                    <td class="text-right"><?= form_input(array('name'=>'other_expense','class'=>'form-control text-right width-150 pull-right other-expense decimal'),set_value('other_expense',$purchase_array[0]['other_expense'])); ?><?=form_error('other_expense');?></td>
                    <td colspan="2" class="disabled"><input type="hidden" id="gnTotalAmt" value="<?= round_this($grandNetAmount); ?>"></td>
                </tr>
                <tr>
			    	<td class="text-right text-bold" colspan="2"><?=$this->lang->line('discount');?> %</td>
			    	<td class="text-right text-bold" colspan="<?=($b-$colspan-1);?>">
			    		<div class="row">
			        		<div class="col-md-3 pull-left">
			        			<?= form_input(array('name'=>'bill_discount_per','class'=>'form-control text-right bill_discount_percent decimal'),set_value('bill_discount_per',$purchase_array[0]['bill_discount_per'])); ?><?=form_error('bill_discount_per');?>
			        		</div>
			        		<div class="col-md-3"><?= $this->lang->line('discount');?> <?=$this->lang->line('amount');?></div>
			        		<div class="col-md-3"><?= form_input(array('name'=>'bill_discount_amt','class'=>'form-control bill_discount_amount decimal text-right'),set_value('bill_discount_amt',$purchase_array[0]['bill_discount_amt'])); ?><?=form_error('bill_discount_amt');?></div>
			        	</div>
			    	</td>
			    	<td colspan="2" class="disabled"></td>
			    </tr>
                <?php
            	if($this->input->post('freight')){
            		$grandNetAmount += $this->input->post('freight');
            	}else{
            		$grandNetAmount += $purchase_array[0]['bill_freight'];
            	}
            	if($this->input->post('other_expense')){
            		$grandNetAmount += $this->input->post('other_expense');
            	}else{
            		$grandNetAmount += $purchase_array[0]['other_expense'];
            	}
            	if($this->input->post('bill_discount_amt')){
            		$grandNetAmount -= $this->input->post('bill_discount_amt');
            	}else{
            		$grandNetAmount -= $purchase_array[0]['bill_discount_amt'];
            	}
            	?>
                <?php if(show_round_off()){ ?>
                    <tr>
                        <td class="text-right text-bold" colspan="<?=(9-$colspan);?>">
                        <div class="row">
                            <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('round-off');?></div>
                        </div>
                        </td>
                        <td class="text-right text-bold">
                        	<div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
                    	</td>
                        <td colspan="2" class="disabled"></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td class="text-right text-bold" colspan="<?=(9-$colspan);?>">
                        <div class="row">
                            <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
                        </div>
                    </td>
                    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
                    <td colspan="2" class="disabled"></td>
                </tr>
                <input type="hidden" name="round_off_amount" id="round_value" value="<?= round_off($grandNetAmount); ?>">
                <input type="hidden" name="vat_total" value="<?=round_this($totalVatAmt); ?>">
                <input type="hidden" name="cess_total" value="<?=round_this($totalCessAmt); ?>">
            	<input type="hidden" name="grand_total" value="<?=round_this($totalTaxable); ?>">
            </table>
        </div>
        <div class="row">
        	<div class="col-md-12">
        		<div class="form-group">
        			<div class="text-right">
        				<?= form_submit(array('name'=>'btn_update','class'=>'btn btn-primary btn-loading pull-right','value'=>$this->lang->line('update')."  ".$this->lang->line('bill')));?>
        			</div>
        		</div>
        	</div>
    	</div>
    </div>
</div>
<?= form_close(); ?>