<style>
*{	font-size:10px;}
.pdf-head{	font-weight:bold; margin-left:auto; margin-right:auto; text-align:center; font-size:12px;}
.data-table{	font-size:10px;}
.text-right{	text-align:right;}
.text-center{	text-align:center;}
.text-bold{	font-weight:bold;}
.vendor{ text-indent:20px;}
.data-list{	padding:2px;}
.data-list th{	font-size:10px; text-align:center; background-color:#E4E4E4; font-weight:700;}
.data-list td{	font-size:8px;}
.disabled{background-color:#E2E2E1;}
.italic{ font-style:italic;}
.has-border{ border:1px solid #666;}
.has-border-left{border-left:1px solid #666;}
.data-list tr td{  border-right:1px solid #666;}
.data-list tr th{border:1px solid #666;}
.declaration{font-size:8px;}
.g-total{ font-size:10px; font-weight:bold;}
.terms-conditions{font-size:8px;font-family: ss;}
</style>
<?php
$bill_prefix = $this->stock->get_voucher_prefix($purchase_array[0]['vtype_id']);
$vendorID = $purchase_array[0]['vendor_id'];
$vendors = $this->stock->get_vendors(array('conditions'=>array('id'=>$vendorID),'return'=>1));
$vendor_name = $vendor_phone = $vendor_mail = $vendor_address = $vendor_tin = $vendor_pin = $vendor_pan = NULL;
if(!empty($vendors)){
	$vendor_name = $vendors['name'];
	$vendor_phone = (!empty($vendors['phone']))?'Ph : '.$vendors['phone'].',':'';
	$vendor_mail = (!empty($vendors['email']))?' Email : '.$vendors['email']:'';
	$vendor_address = $vendors['address'];
	$vendor_tin = (!empty($vendors['tin_no']))?' TIN : '.$vendors['tin_no']:'';
	$vendor_pin = (!empty($vendors['pincode']))?' Pin : '.$vendors['pincode']:'';
	$vendor_pan = (!empty($vendors['pan_no']))?' PAN : '.$vendors['pan_no']:'';
}
$itmSpc=$qtySpc=$untSpc=$rtSpc=$amtSpc=0;
if(!empty($presumptive_tax)){
	$itmSpc=20;
	$qtySpc=$untSpc=$rtSpc=$amtSpc=20;
}
if($purchase_cst){
	$itmSpc = 0;
}else{
	$itmSpc = 50;
}

?>
<div class="pdf-head">RECEIPT NOTE</div>
<table  class="data-table">
<tr>
<td class="text-left">
<span class="text-bold">Bill No. : <?= $bill_prefix.' '.$purchase_array[0]['bill_no'];?></span>
</td>
<td class="text-right"><span class="text-bold">Bill Date : <?=dateFormat($purchase_array[0]['bill_date']);?></span></td>
</tr>
<tr>
<td class="text-left">
<span class="text-bold">Invoice No. : <?=$purchase_array[0]['invoice_no'];?></span>
</td>
<td class="text-right"><span class="text-bold">Invoice Date : <?=dateFormat($purchase_array[0]['invoice_date']);?></span></td>
</tr>
</table>
<div></div>
<table  class="data-table" border="0">
<tr><td>From ,</td></tr>
<tr><td class="vendor text-bold"><?= $vendor_name; ?></td></tr>
<tr><td class="vendor"><?= $vendor_address; ?> <?= $vendor_pin; ?></td></tr>
<tr><td class="vendor"><?= $vendor_phone; ?> <?= $vendor_mail; ?></td></tr>
<tr><td class="vendor"><?= $vendor_tin; ?> <?= $vendor_pan; ?></td></tr>
</table>
<?php if(!empty($vehicle_details)){ ?>
<table  class="data-table" border="0">
<tr>
<td class="text-left" width="10%">
<span class="text-bold">Vehicle</span>
<span class="small"></span>
</td>
<td  width="90%">
    <?php $vCnt=0;
	foreach($vehicle_details as $key=>$vehicle){ $vCnt++;

		if(empty($vehicle['vehicle_type'])){
			$vehicle_number = $vehicle['vehicle_no'];
		}else{
			$vehicle_number = $vehicle['vehicle_number'];
		}
		echo $vCnt.') . '.$vehicle_number ." , ";
		} ?>
</td>
</tr>
</table>
<div></div>
<?php
}
?>
<table class="data-list">
<thead>
<tr class="bg-success">
<th width="20">#</th>
<th width="<?= 135+$itmSpc; ?>">Item</th>
<th width="<?= 50+$qtySpc; ?>">Qty.</th>
<th width="<?= 50+$rtSpc; ?>">Rate</th>
<th width="<?= 60+$amtSpc; ?>">Amount</th>
<th width="50">Discount</th>
<?php
$colspan = 2;
if(empty($presumptive_tax) && $purchase_cst){
	$colspan-=1;
?>
<th width="50">CST</th>
<?php }
if(empty($presumptive_tax)){$colspan-=2;?>
<th width="30">VAT (%)</th>
<th width="50">VAT Amt.</th>
<?php }?>
<th width="70">Amount</th>
</tr>
</thead>
    <?php
    $i=0;$totalAmount=0;$totalDiscountAmt=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
    $grandNetAmount=0;$total_cst_amount = 0;
	$cess = $purchase_array[0]['cess'];
    foreach($purchase_array as $key => $item){
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $discount_per = $item['discount_per'];
        $discount_amt = $item['discount_amt'];
        $cst_percent = $item['cst'];
        $vat = 0;$vatAmount = 0;$cst_amount = 0;
        $amount = $item['amount'];
        $totalAmount += $amount;
        $netValue = $amount-$discount_amt;
        if(empty($presumptive_tax)){
            if($cst_percent == 0){
                $vat = $this->stock->get_item_vat($itemID);
                $vatAmount = $item['vat_amt'];
                $totalVatAmt += $vatAmount;
            }else{
                $cst_amount = ($netValue*$cst_percent)/100;
            }
        }
        $total_cst_amount += $cst_amount;
        $totalNetValue += $netValue;
        $netAmount = $netValue+$vatAmount+$cst_amount;
        $totalNetAmount += $netAmount;
        $totalDiscountAmt += $discount_amt;
        ?>
        <tr>
        <td width="20" class="has-border-left text-center"><?= $i; ?></td>
        <td width="<?= 135+$itmSpc; ?>"><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
        <td width="<?= 50+$qtySpc; ?>" class="text-right"><?= $qty; ?> <?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
        <td width="<?= 50+$rtSpc; ?>" class="text-right"><?= numberFormat($rate); ?></td>
        <td width="<?= 60+$amtSpc; ?>" class="text-right"><?= numberFormat(round_this($amount)); ?></td>
        <td width="50" class="text-right"><?= numberFormat(round_this($discount_amt)); ?></td>
        <?php if(empty($presumptive_tax) && $purchase_cst){?>
        	<td width="50" class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
		<?php }
		if(empty($presumptive_tax)){
		?>
            <td width="30" class="text-right"><?= $vat; ?></td>
            <td width="50" class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php }?>
        <td width="70" class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        </tr>
        <?php
    }
    $grandNetAmount = round_this($totalNetAmount);
    ?>
    <tr>
    <td class="text-right text-bold disabled has-border" colspan="4"><?= $this->lang->line('total'); ?></td>
    <td class="text-right text-bold disabled has-border"><?= numberFormat(round_this($totalAmount)); ?></td>
    <td class="text-right text-bold disabled has-border"><?= numberFormat(round_this($totalDiscountAmt)); ?></td>
    <?php if(empty($presumptive_tax) && $purchase_cst){?>
    	<td class="text-right text-bold disabled has-border"><?= numberFormat(round_this($total_cst_amount)); ?></td>
	<?php }?>
    <?php if(empty($presumptive_tax)){?>
        <td class="disabled has-border"></td>
        <td class="text-right text-bold disabled has-border"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php }?>
    <td class="text-right text-bold disabled has-border"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    </tr>
    <?php
	$presumptive_tax_amt = 0;
	if(!empty($presumptive_tax)){
		$presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
		$grandNetAmount += round_this($presumptive_tax_amt);
    	?>
        <tr>
        <td colspan="<?=(8-$colspan);?>" class="text-right">Presumptive tax @ <?=$presumptive_tax[0];?> %</td>
        <td class="text-right has-border"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
        </tr>
    <?php }
	$cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
    $grandNetAmount += round_this($cess_amt);
	?>
    <tr>
    <td colspan="<?=(8-$colspan);?>" class="text-right">cess @ <?=$cess;?> %</td>
    <td class="text-right has-border"><?=numberFormat(round_this($cess_amt));?></td>
	</tr>
    <tr>
    <td colspan="<?=(8-$colspan);?>" class="text-right">Freight</td>
    <td class="text-right has-border"><?=numberFormat(round_this($purchase_array[0]['bill_freight']));?></td>
    </tr>
    <tr>
    <td class="text-right" colspan="<?=(8-$colspan);?>">Other Expense</td>
    <td class="text-right has-border"><?=numberFormat(round_this($purchase_array[0]['other_expense']));?></td>
    </tr>
    <tr>
    <td class="text-right" colspan="<?=(8-$colspan);?>">Discount</td>
    <td class="text-right has-border"><?=numberFormat(round_this($purchase_array[0]['bill_discount_amt']));?></td>
    </tr>
    <?php
	$grandNetAmount += (($purchase_array[0]['bill_freight']+$purchase_array[0]['other_expense'])-$purchase_array[0]['bill_discount_amt']);
	?>
    <?php if(show_round_off()){ ?>
    <tr>
    <td class="text-right" colspan="<?=(8-$colspan);?>">Round Off</td>
    <td class="text-right has-border"><?=numberFormat(round_off($grandNetAmount));?></td>
    </tr>
    <?php } ?>
    <tr>
    <td class="text-right text-bold" colspan="<?=(8-$colspan);?>"><span class=" g-total">Net Amount (<?= get_currency();?>)</span></td>
    <td class="text-right has-border g-total"><span class=" g-total"><?=numberFormat(get_rounded($grandNetAmount));?></span></td>
    </tr>
</table>
<div class="text-left italic"><?= $this->to_words->num_to_words(get_rounded($grandNetAmount)); ?></div>
<div class="text-right text-bold">Authorised Signatory.</div>