<?= export_to_excel('excel/receipt_note_excel/receipt_note'.$redirect); ?>
<div class="table-responsive block">
<table class="table table-striped table-condensed table-bordered tbl-brdr">
<tr class="bg-success">
	<th>#</td>
	<th><?=$this->lang->line('date');?></th>
	<th><?=$this->lang->line('bill-no');?></th>
	<th><?=$this->lang->line('vendor');?></th>
    <th><?=$this->lang->line('net')." ".$this->lang->line('amt');?></th>
    <th colspan="6"><?=$this->lang->line('actions');?></th>
</tr>
<?php foreach($purchase_array as $key => $value):
	$bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);
	$total_amount = 0;$total_tax_amount = 0;$presum_amount = 0;
	$item_details = $this->purchase->get_purchase_items(array('columns' => array('item_id','qty','rate','amount','discount_amt','vat_amt','cst'),'conditions' => array('group_id' => $value['group_id'],'status' => 1,'item_status >' => 0)));
	foreach($item_details as $item_key => $item_value):
		$tax_amount = 0;
		$net_value = ($item_value['amount']-$item_value['discount_amt']);
		if(empty($presumptive_tax)){
			if($item_value['cst'] == 0){
				$vat = $this->stock->get_item_vat($item_value['item_id']);
				$tax_amount = $item_value['vat_amt'];
			}else{
				$tax_amount = ($item_value['cst']*$net_value)/100;
			}
		}
		$total_tax_amount += $tax_amount;
		$total_amount += $net_value;
	endforeach;
	$total_amount += $total_tax_amount;
	if(!empty($presumptive_tax)){
		$presum_amount = ($presumptive_tax[0]*$total_amount)/100;
		$total_amount += $presum_amount;
	}
	$cess_amount = (($total_tax_amount+$presum_amount)*$value['cess'])/100;
	$total_amount += (($cess_amount+$value['bill_freight']+$value['other_expense'])-$value['bill_discount_amt']);
	?>
	<tr>
        <td class="text-center"><?=++$offset;?></td>
        <td class="text-center"><?=dateFormat($value['bill_date']);?></td>
        <td><?= $bill_prefix.' '.$value['bill_no'];?></td>
        <td><?= $this->stock->vendor_name($value['vendor_id']);?></td>
        <td class="text-right"><?=numberFormat(get_rounded($total_amount));?></td>
        <?php
		if($value['r_status'] == 0){
			if($value['p_status'] == 4){
				$action_array = array(410,413,543,558);
			}else{
				$action_array = array(410,411,412,413,543,558);
			}
		}
		else{
			$action_array = array(410,543,558);
		}
		app_table_links('id/'.$value['id'].$redirect,$action_array,6);?>
	</tr>
<?php endforeach;?>
</table>
</div>

<!--pagination-->
<div class="row">
	<div class="col-md-12">
		<div class="pagination"><?=$links;?></div>
	</div>
</div>
