<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line("view")." ".$this->lang->line("bill"); ?></h6>
</div>
<div class="panel-body">
<?php $bill_prefix = $this->stock->get_voucher_prefix($purchase_array[0]['vtype_id']); ?>
<?php if($this->uri->segment(1) == 'rejection_out'){ ?>
    <div class="row">
        <div class="col-md-12">
            <?php app_export_menus('id/'.$purchase_array[0]['primary_id'],541);?>
        </div>
    </div>
<?php } ?>

<div class="form-group">
<div class="row">
    <div class="col-md-4">
        <label><?=$this->lang->line('voucher-types');?></label>
        <input type="text" class="form-control" disabled value="<?=$voucher_type;?>">
    </div>

    <div class="col-md-4">
        <label><?=$this->lang->line('bill-no');?></label>
        <div class="input-group">
            <span class="input-group-addon text-bold" id="bill-prefix"><?= $bill_prefix; ?></span>
            <input type="text" class="form-control" disabled value="<?=$purchase_array[0]['bill_no'];?>">
        </div>
    </div>
    <div class="col-md-4">
        <label><?=$this->lang->line('bill-date');?></label>
        <input type="text" class="form-control" disabled value="<?=dateFormat($purchase_array[0]['bill_date']);?>">
    </div>
</div>
</div>

<div class="form-group">
    <div class="row">
        <div class="col-md-6">
            <label><?=$this->lang->line('invoice-no');?></label>
            <input type="text" class="form-control" disabled value="<?=$return_bill_no;?>">
        </div>
        <div class="col-md-6">
            <label><?=$this->lang->line('vendor');?></label>
            <?=form_dropdown("vendor_id",$vendors,set_value('vendor_id'),"class='form-control' disabled");?>
        </div>
    </div>
</div>

<div class="row">
<div class="col-md-12">

    <div class='table-responsive'>
    <table class="table table-bordered table-striped">
    <thead>
    <tr class="bg-success">
    <th>#</th>
    <th><?= $this->lang->line('item-name');?></th>
    <th><?= $this->lang->line('quantity');?></th>
    <th><?= $this->lang->line('unit'); ?></th>
    <th><?= $this->lang->line('rate'); ?></th>
    <th><?= $this->lang->line('net-value'); ?></th>
    <?php 
        $b_date = $purchase_array[0]['bill_date'];
        $l_date = '2017-07-01';
        if($b_date < $l_date)
        {
              $a=8;$b=6;
              $colspan = 2;
              if(empty($presumptive_tax) && $purchase_cst)
              {
                    $colspan-=1;
    ?>
    	            <th><?= $this->lang->line('cst').". ".$this->lang->line('amt'); ?></th>
    <?php 
              }
    ?>
    <?php 
              if(empty($presumptive_tax))
              {
                    $colspan-=2;
    ?>
                    <th><?= $this->lang->line('vat'); ?> (%)</th>
                    <th><?= $this->lang->line('vat'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php 
              }
         }
         else
         {
               $a=10;$b=8;
    ?>
               <th><?= $this->lang->line('cgst'); ?> (%)</th>
               <th><?= $this->lang->line('sgst'); ?> (%)</th>
               <th><?= $this->lang->line('cgst'); ?> <?= $this->lang->line('amt'); ?></th>
               <th><?= $this->lang->line('sgst'); ?> <?= $this->lang->line('amt'); ?></th>
    <?php
         }
    ?>
    <th class="width-150"><?= $this->lang->line('net'); ?> <?= $this->lang->line('amt'); ?></th>
    </tr>
    </thead>
    <?php
    $i=0;$totalNetValue=0;$totalVatAmt=0;$totalNetAmount=0;//$totalFreight=0;
    $grandNetAmount=0;$total_cst_amount = 0;
	$cess = $purchase_array[0]['cess'];
    foreach($purchase_array as $key => $item)
    {
        $i++;
        $itemID = $item['item_id'];
        $item_details = $this->stock->get_item($itemID,array('item_code','item_name'));
        $qty = $item['qty'];
        $rate = $item['rate'];
        $cst_percent = $item['cst'];
        $vat = 0;$vatAmount = 0;$cst_amount = 0;
        $netValue = $item['amount'];
        if($b_date < $l_date)
        {
                if(empty($presumptive_tax))
                {
                      if($cst_percent == 0)
                      {
                            $vat = $this->stock->get_item_vat($itemID);
                            $vatAmount = $item['vat_amt'];
                            $totalVatAmt += $vatAmount;
                      }else{
                            $cst_amount = ($netValue*$cst_percent)/100;
                      }
                }
                $total_cst_amount += $cst_amount;
                $netAmount = $netValue+$vatAmount+$cst_amount;
        }
        else
        {
               $cgst = $this->stock->get_item_cgst($itemID);
               $sgst = $this->stock->get_item_sgst($itemID);
               $cgstAmount = $item['cgst_amt'];
               $sgstAmount = $item['sgst_amt'];
               $vatAmount = $cgstAmount +  $sgstAmount;
               $totalVatAmt += $vatAmount;
               $netAmount = $netValue+$vatAmount+$cst_amount;
        }
        $totalNetValue += $netValue;
        $totalNetAmount += $netAmount;
        ?>
        <tr>
        <td class="text-center"><?= $i; ?></td>
        <td><?= $item_details['item_code']; ?> / <?= $item_details['item_name']; ?></td>
        <td class="text-right"><?= $qty; ?></td>
        <td><?=$this->stock->get_unit_symbol($item['unit_id']); ?></td>
        <td class="text-right"><?= numberFormat($rate); ?></td>
        <td class="text-right"><?= numberFormat(round_this($netValue)); ?></td>
        <?php 
            if($b_date< $l_date)
            {
                 if(empty($presumptive_tax) && $purchase_cst)
                 {
        ?>
        	      <td class="text-right"><?= numberFormat(round_this($cst_amount)); ?></td>
	<?php 
                 }
         ?>
        <?php 
                 if(empty($presumptive_tax))
                 {
        ?>
                      <td class="text-right"><?= $vat; ?></td>
                      <td class="text-right"><?= numberFormat(round_this($vatAmount)); ?></td>
        <?php 
                 }
             }
             else
             {
        ?>
                 <td class="text-right"><?= $cgst; ?></td>
                 <td class="text-right"><?= $sgst; ?></td>
                 <td class="text-right"><?= numberFormat(round_this($cgstAmount)); ?></td>
                 <td class="text-right"><?= numberFormat(round_this($sgstAmount)); ?></td>
        <?php
             }
        ?>
        <td class="text-right"><?= numberFormat(round_this($netAmount)); ?></td>
        </tr>
        <?php
    }
    $grandNetAmount = round_this($totalNetAmount);
    ?>
    <tr>
    <td class="text-right text-bold" colspan="5"><?= $this->lang->line('total'); ?></td>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetValue)); ?></td>
    <?php 
        if($b_date <  $l_date )
        {
              if(empty($presumptive_tax) && $purchase_cst)
              {
    ?>
    	           <td class="text-right text-bold"><?= numberFormat(round_this($total_cst_amount)); ?></td>
    <?php 
              }
    ?>
    <?php 
              if(empty($presumptive_tax))
              {
    ?>
                  <td class="disabled"></td>
                  <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php 
              }
         }
         else
         {
    ?>
              <td class="disabled"></td>
              <td class="text-right text-bold" colspan="2">GST Amt.</td>
              <td class="text-right text-bold"><?= numberFormat(round_this($totalVatAmt)); ?></td>
    <?php
         }
    ?>
    <td class="text-right text-bold"><?= numberFormat(round_this($totalNetAmount)); ?></td>
    </tr>

    <?php $presumptive_tax_amt = 0;
        if($b_date < $l_date)
        {
	        if(!empty($presumptive_tax))
                {
		       $presumptive_tax_amt = ($totalNetAmount*$presumptive_tax[0])/100;
		       $grandNetAmount += round_this($presumptive_tax_amt);
    ?>
                       <tr>
                       <td colspan="<?=(8-$colspan);?>" class="text-right">
                       <span class="text-bold"><?=$this->lang->line('presum-tax');?> @ <?=$presumptive_tax[0];?> %</span></td>
                       <td class="text-right"><?=numberFormat(round_this($presumptive_tax_amt));?></td>
                       </tr>
    <?php 
                }
    ?>
    <?php 
                $cess_amt = (($totalVatAmt+$total_cst_amount+$presumptive_tax_amt)*$cess)/100;
                $grandNetAmount += round_this($cess_amt);?>
        }
    <tr>
    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold"><?=$this->lang->line('cess');?> @ <?=$cess;?> %</td>
    <td class="text-right"><?=numberFormat(round_this($cess_amt));?></td>
	</tr>

    <tr>
    <td colspan="<?=($a-$colspan);?>" class="text-right text-bold"><?= $this->lang->line('freight');?></td>
    <td class="text-right"><?=numberFormat(round_this($purchase_array[0]['bill_freight']));?></td>
    </tr>

    <tr>
    <td class="text-right text-bold" colspan="2"><?=$this->lang->line('remarks');?></td>
    <td colspan="<?=($b-$colspan);?>" class="text-right text-bold">
        <div class="row">
        <div class="col-md-8 pull-left"><textarea class="form-control" disabled><?=$purchase_array[0]['narration'];?></textarea></div>
        <div class="col-md-4 pull-right"><?= $this->lang->line('other-expense');?></div>
        </div>
    </td>
    <td class="text-right"><?=numberFormat(round_this($purchase_array[0]['other_expense']));?></td>
    </tr>

    <?php
	$grandNetAmount += (($purchase_array[0]['bill_freight']+$purchase_array[0]['other_expense']));
	?>
    <?php if(show_round_off()){ ?>
        <tr>
        <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
        <div class="row">
            <div class="col-md-12 pull-right"><?=$this->lang->line('round-off');?></div>
        </div>
        </td>
        <td class="text-right text-bold">
			<div class="in-line" id="roundOff"><?= numberFormat(round_off($grandNetAmount)); ?></div>
        </td>
        </tr>
    <?php } ?>

    <tr>
    <td class="text-right text-bold" colspan="<?=($a-$colspan);?>">
    <div class="row">
        <div class="col-md-12 pull-right text-bold"><?=$this->lang->line('net-amount');?></div>
    </div>
    </td>
    <td class="text-right text-bold"><div class="in-line" id="grandTotalAmount"><?= numberFormat(get_rounded($grandNetAmount)); ?></div></td>
    </tr>
    </table>
    </div>

    <div class="row">
    <div class="col-md-7 pull-left text-bold"><?=$this->lang->line('last-updated-by')." : ".get_username($purchase_array[0]['created_by']);?></div>
    <div class="col-md-5 text-right text-bold"><?=$this->lang->line('last-updated-on')." : ".dateTimeFormat($purchase_array[0]['created_on']);?></div>
    </div>

</div>
</div>
</div>
</div>