<?= form_open(); 
$uri_array = $this->uri->uri_to_assoc(1);
$uri_string = $this->uri->assoc_to_uri($uri_array);

if(!empty($purchase_requests)){
	
$request_no = $purchase_requests[0]['request_no'];
$request_date = $purchase_requests[0]['request_date'];
$requestStatus = $purchase_requests[0]['req_status'];
$delivery_on = $purchase_requests[0]['delivery_date'];
$remarks = $purchase_requests[0]['remarks'];
$customerID = $purchase_requests[0]['customer_id'];
?>
<div class="panel panel-primary">
<div class="panel-heading">
<h6 class="panel-title"><i class="icon-database"></i><?= $this->lang->line('purchase-request'); ?> </h6>
</div>
<div class="panel-body">

<div class="form-group">
    <div class="row">
        <div class="col-md-6">
            <label><?=$this->lang->line('request-no');?></label>
            <?= form_input(array('name'=>'request_no','class'=>'form-control text-right number','readonly'=>true),set_value('request_no',$request_no)); ?>
            <?= form_error('request_no');?>
        </div>
        <div class="col-md-6">
            <label class="required"><?=$this->lang->line('requested-on');?></label>
            <?= form_input(array('name'=>'request_date','class'=>'form-control','readonly'=>true),set_value('request_date',cdateFormat($request_date))); ?>
            <?= form_error('request_date');?>
        </div>
    </div>
</div>
   
 <?php if($requestStatus <= 1){ ?>
    <div class="form-group">
        <div class="row">
            <div class="col-md-4">
                <label class="required"><?=$this->lang->line('item-name');?></label>
                <?= form_dropdown('item_id',$items,set_value('item_id'),'class="form-control item_name"'); ?>
                <?= form_error('item_id');?>        
            </div>
            <div class="col-md-4">
                <label class="required"><?=$this->lang->line('quantity');?></label>
                <?= form_input(array('name'=>'qty','class'=>'form-control text-right qnty discount_per decimal'),set_value('qty')); ?>
                <?= form_error('qty');?>        
            </div>         
            <div class="col-md-4">
                <label class="required"><?=$this->lang->line('unit');?></label>
                <div class="row">
                    <div class="col-md-8">
                    <?= form_dropdown('unit_id',$units,set_value('unit_id'),'class="form-control unit discount_per"'); ?>
                    <?= form_error('unit_id');?>        
                    </div>
                    <div class="col-md-4">
                        <?=form_button(array('type'=>'submit','name'=>'add_item','class'=>'btn btn-primary pull-left','content'=>$this->lang->line('add')));?>
                    </div>
                </div>
            </div> 
        </div>
    </div>
   
<?php } ?>

<div class="row">
    <div class="col-md-12">
    
        <div class='table-responsive'>
        <table class="table table-bordered table-striped">
        <thead>
        <tr class="bg-success">
        <th>#</th>
        <th><?= $this->lang->line('item-name'); ?></th>
        <th><?= $this->lang->line('quantity'); ?></th>
        <th><?= $this->lang->line('unit'); ?></th>
        <th><?= $this->lang->line('delete'); ?></th>
        </tr>       
        </thead>
        <?php $i=0;
		foreach($purchase_requests as $key=>$requestItem){$i++;
			?>
            <tr>
            <td><?= $i; ?></td>
            <td><?= $requestItem['item_code']; ?> / <?= $requestItem['item_name']; ?></td>
            <td><?= $requestItem['qty']; ?></td>
            <td><?= $requestItem['symbol']; ?></td>
            <td class="text-center"><?php if($requestStatus <= 1){ ?><a href="<?= base_url('purchase_requests/remove_item/'.$requestItem['dpri_id']); ?>" class="text-danger" title="<?= $this->lang->line('remove'); ?>"><i class="glyphicon glyphicon-remove delete"></i></a><?php }else{ ?><i class="glyphicon glyphicon-remove"></i><?php } ?></td>
            </tr>
            <?php
		}?>
        </table>
        </div>
    
    </div>
</div>

<?php if($designation_id > 3 && $designation_id <= 6){ ?>
<div class="form-group">
    <div class="row">
        <div class="col-md-12">
            <label><?=$this->lang->line('customer');?></label>
            <?php if($this->dms->have_access(484)){ ?>
            <div class="input-group">
			<?= form_dropdown('customer_id',$customers,set_value('customer_id',$customerID),'class="form-control"'); ?>
            <span class="input-group-addon cursor-p add-customer" title="<?= $this->lang->line('edit'); ?>" >
            <a href="<?= base_url('customer_master/edit_customer/'.$customerID.'/'.$uri_string); ?>"><i class="icon-pencil"></i></a>
            </span>
            </div>
            <?php }else{ 
			echo	form_dropdown('customer_id',$customers,set_value('customer_id',$customerID),'class="form-control"');
			} ?>
            <?= form_error('customer_id');?>
        </div>
    </div>    
</div>

<?php } ?>

<?php if(!empty($purchase_requests)){ ?>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?=$this->lang->line('delivery-on');?></label>
                <?= form_input(array('name'=>'delivery_date','class'=>'form-control datepicker'),set_value('delivery_date',cdateFormat($delivery_on))); ?>
                <?= form_error('delivery_date');?>
            </div>
    
            <div class="col-md-6">
                <label><?=$this->lang->line('remarks');?></label>
                <?= form_textarea(array('name'=>'remarks','rows'=>3,'class'=>'form-control'),set_value('remarks',$remarks)); ?>
                <?= form_error('remarks');?>
            </div>
        </div>    
    </div>
    
	<?php if($requestStatus <= 1){ ?>
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <?=form_button(array('type'=>'submit','name'=>'post_request','class'=>'btn btn-primary pull-right','content'=>$this->lang->line('update')));?>
            </div>
        </div>    
    </div>
    <?php
 }
}
?>

</div>
</div>
<?php } ?>
<?= form_close(); ?>