<?= form_open();?>
<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('salary-percentage'); ?> </h6>
	</div>
	<div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('name');?></label>
                    <?= form_input(array('name'=>'name','class'=>'form-control'),set_value('name')); ?>
                    <?= form_error('name');?>
                </div>

                <div class="col-md-4">
                    <label class="required"><?=$this->lang->line('vehicle types');?></label>
					<?= form_dropdown('vehicle_type',$vehicleTypes,set_value('vehicle_type'),"class='form-control vehicle_type' "); ?>
                    <?= form_error('vehicle_type');?>
                </div>

                <div class="col-md-2">
                    <label class="required"><?=$this->lang->line('salary-percentage');?></label>
                    <?= form_input(array('name'=>'percentage','class'=>'form-control'),set_value('percentage')); ?>
                    <?= form_error('percentage');?>
                </div>                
            </div>
		</div>


		<div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'save_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('save')));?>
                    </div>
                </div>
            </div>
		</div>
		

<?= form_close(); ?>
<br>
<?php
if(!empty($salary_percentages)) {

    ?>

    <div class="row">
        <div class="col-md-12">
            <div class='table-responsive'>
                <table class="table table-bordered table-striped">
                <thead>
                <tr class="bg-success">
                    <th>#</th>
                    <th><?= $this->lang->line('name'); ?></th>
                    <th><?= $this->lang->line('vehicle types'); ?></th>
                    <th><?= $this->lang->line('percentage'); ?></th>
                    <th colspan="2"><?= $this->lang->line('actions'); ?></th>
                </tr>
                </thead>
                <?php
                $i=0;
                foreach($salary_percentages as $key => $percentage ) {$i++;
                    ?>
                    <tr>
                        <td><?= $i; ?></td>
                        <td><?= $percentage['name']; ?></td>
                        <td><?= $percentage['vehicle_type']; ?></td>
                        <td><?= $percentage['percentage']; ?></td>
                        <?php
                            $menuArray = array(589,590);
                            app_table_links($percentage['id'],$menuArray,2);
                        ?>
                    </tr>
                    <?php
                }
                ?>
                </table>
            </div>
        </div>
    </div>
    <?php
}
?>

    </div>
</div>