<?= form_open();?>
<div class="panel panel-primary">
	<div class="panel-heading">
		<h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('driver-salary'); ?> </h6>
	</div>
	<div class="panel-body">
        <div class="form-group">
            <div class="row">
                <div class="col-md-6">
                    <label class="required"><?=$this->lang->line('driver');?></label>
                    <?= form_dropdown('driver_id',$drivers,set_value('driver_id',$sel_driver_id),"class='form-control'"); ?>
                    <?= form_error('driver_id');?>
                </div>

                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('from');?></label>
					<?= form_input(array('name'=>'from_date','class'=>'form-control datepicker'),set_value('from_date',cdateFormat($sel_from_date))); ?>
                    <?= form_error('from_date');?>
                </div>

                <div class="col-md-3">
                    <label class="required"><?=$this->lang->line('to');?></label>
                    <?= form_input(array('name'=>'to_date','class'=>'form-control datepicker'),set_value('to_date',cdateFormat($sel_to_date))); ?>
                    <?= form_error('to_date');?>
                </div>                
            </div>
		</div>


		<div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <div class="text-right">
                        <?= form_button(array('type'=>'submit','name'=>'get_details','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('get')));?>
                    </div>
                </div>
            </div>
		</div>
		
	</div>
</div>
<?= form_close(); ?>

<?php
if(!empty($driver_bills)){

    ?>
    <div class="panel panel-primary">
        <div class="panel-heading">
            <h6 class="panel-title"><i class="icon-database"></i> <?= $this->lang->line('bill'); ?> </h6>
        </div>
        <div class="panel-body">
            <?= form_open();?>
            <?= form_hidden('driver_id',$sel_driver_id); ?>
            <?= form_hidden('from_date',cdateFormat($sel_from_date)); ?>
            <?= form_hidden('to_date',cdateFormat($sel_to_date)); ?>
            <div class="row">
                <div class="col-md-12">
                    <div class='table-responsive'>
                        <table class="table table-bordered table-striped">
                        <thead>
                        <tr class="bg-success">
                        <th>#</th>
                        <th><?= $this->lang->line('bill-date'); ?></th>
                        <th><?= $this->lang->line('voucher-type'); ?></th>
                        <th><?= $this->lang->line('bill-no'); ?></th>
                        <th><?= $this->lang->line('customer-name'); ?></th>
                        <th><?= $this->lang->line('route'); ?></th>
                        <th><?= $this->lang->line('vehicle-rent'); ?></th>
                        <th><?= $this->lang->line('percentage'); ?></th>
                        <th><?= $this->lang->line('amount'); ?></th>
                        </tr>
                        </thead>
                        <?php
                        
                        $i=0;$total_salary_amount = $salary_amount = $total_vehicle_rent = 0;$salary_percent_id ='';
                        foreach($driver_bills as $key => $driver_bills_a):
                            
                            foreach($driver_bills_a as $key => $value):$i++;
                        
                            $vehicle_rent = $value['vehicle_rent'];
                            $sales_id = $value['id'];
                           # $salary_percent_id = $value['salary_percent_id'];
                            #$salary_amount = get_rounded(($vehicle_rent*$value['percentage'])/100);
                            $total_salary_amount += $salary_amount;
                            $total_vehicle_rent += $vehicle_rent;
                            $bill_prefix = $this->stock->get_voucher_prefix($value['vtype_id']);

                            ?>
                            <tr>
                            <td class="text-center no-wrap"><?= $i;?></td>
                            <td class="text-center no-wrap"><?=dateFormat($value['bill_date']);?></td>
                            <td><?= $value['voucher_type']; ?></td>
                            <td class="no-wrap"><?=$bill_prefix.' '.$value['bill_no'];?></td>
                            <td><?= $value['party_name']; ?>
                            </td>
                            <td><?= $value['route_name']; ?></td>
                            <td class="text-right"><?=numberFormat(get_rounded($vehicle_rent));?><input type="hidden" id="net-<?php echo $sales_id; ?>" value="<?php echo $vehicle_rent; ?>"></td>
                            <td><?= form_dropdown('salary_percent_'.$sales_id,$salary_percentages,set_value('salary_percent_'.$sales_id,$salary_percent_id),"class='form-control salary_percentage width-200' id='".$sales_id."'"); ?></td>
                            <td><?= form_input(array('name'=>'amount_'.$sales_id,'class'=>'form-control salary_percentage_amount width-100 text-right','id'=>'percentage_amt_'.$sales_id),set_value('amount_'.$sales_id,$salary_amount),'readonly'); ?></td>
                            </tr>
                        <?php 
                        endforeach;
                         endforeach;
                         $total_salary_amount = ($total_salary_amount);
                        ?>
                        <tr>
                            <td colspan="8" class="text-right h5">Total Amount</td>
                            <td class="text-right h5"><?= form_input(array('name'=>'total_amount','id'=>'total-amount','class'=>'form-control width-100 text-right'),set_value('total_amount',$total_salary_amount),'readonly'); ?></td>
                        </tr>
                        </table>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label class="required"><?=$this->lang->line('payment-date');?></label>
                        <?= form_input(array('name'=>'paid_date','class'=>'form-control datepicker'),set_value('paid_date',cdateFormat($paid_date))); ?>
                        <?= form_error('paid_date');?>
                    </div>                    

                    <div class="col-md-8">
                        <label class=""><?=$this->lang->line('remarks');?></label>
                        <?= form_textarea(array('name'=>'remarks','class'=>'form-control','rows'=>2),set_value('remarks')); ?>
                        <?= form_error('remarks');?>
                    </div>
                </div> 
            </div>       

            <div class="form-group">

            <div class="row">
                <label class="required col-md-3"><?= $this->lang->line('payment-mode'); ?></label>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','0',set_radio('receipt_mode','0',true),'class="receipt-mode"'); ?>
                    <label><?= $this->lang->line('cash'); ?></label>
                </div>
                <div class="col-md-2">
                    <?= form_radio('receipt_mode','1',set_radio('receipt_mode','1'),'class="receipt-mode"'); ?>
                    <label><?= $this->lang->line('bank'); ?></label>
                </div>
                <?= form_error('receipt_mode'); ?>
            </div>                
            </div> 
     
            <?php
            $disPDC = 'disabled="disabled"';
            if($this->input->post('receipt_mode') && $this->input->post('receipt_mode')>0){
                $disPDC = NULL;
            }
            ?>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-12">
                        <?= form_dropdown('payment_mode',$bank_accounts,set_value('payment_mode',$bank),"class='form-control payment-mode pdc' $disPDC"); ?>
                        <?= form_error('payment_mode');?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label><?=$this->lang->line('transaction-type');?></label>
                        <?php $transaction_types = $this->dms->transaction_types();?>
                        <?= form_dropdown('ccd',$transaction_types,set_value('ccd'),"class='form-control pdc' $disPDC"); ?>
                        <?=form_error('ccd');?>
                    </div>
                    <div class="col-md-4">
                        <label class="pdcl"><?=$this->lang->line('cd-no');?></label>
                        <?= form_input(array('name'=>'cheque_no','class'=>'form-control pdc'),set_value('cheque_no'),$disPDC); ?>
                        <?= form_error('cheque_no');?>
                    </div>
                    <div class="col-md-4">
                        <label class="pdcl"><?=$this->lang->line('cheque-date');?></label>
                        <?= form_input(array('name'=>'cheque_date','class'=>'form-control pdc datepicker required'),set_value('cheque_date'),$disPDC); ?>
                        <?= form_error('cheque_date');?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <div class="text-right">
                            <?= form_button(array('type'=>'submit','name'=>'save_bill','class'=>'btn btn-primary btn-loading pull-right','content'=>$this->lang->line('payment')));?>
                        </div>
                    </div>
                </div>
            </div>        
            <?= form_close(); ?>
        </div>
    </div>
    <?php
}
?>